/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.control_exceptions.InterruptException;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.ListRelationResult;
import org.rascalmpl.interpreter.result.NumberResult;
import org.rascalmpl.interpreter.result.RationalResult;
import org.rascalmpl.interpreter.result.RealResult;
import org.rascalmpl.interpreter.result.RelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;

public class IntegerResult
extends ElementResult<IInteger> {
    public IntegerResult(Type type, IInteger n, IEvaluatorContext ctx) {
        super(type, n, ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> result) {
        return result.addInteger(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> multiply(Result<V> result) {
        return result.multiplyInteger(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> subtract(Result<V> result) {
        return result.subtractInteger(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> divide(Result<V> result) {
        return result.divideInteger(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> remainder(Result<V> result) {
        return result.remainderInteger(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> modulo(Result<V> result) {
        return result.moduloInteger(this);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> makeRange(Result<V> that) {
        return that.makeRangeFromInteger(this);
    }

    @Override
    public <U extends IValue, V extends IValue, W extends IValue> Result<U> makeStepRange(Result<V> to, Result<W> step) {
        return to.makeStepRangeFromInteger(this, step);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToInteger(this);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return that.nonEqualToInteger(this);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> result) {
        return result.lessThanInteger(this);
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> result) {
        return result.lessThanOrEqualInteger(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThan(Result<V> result) {
        return result.greaterThanInteger(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThanOrEqual(Result<V> result) {
        return result.greaterThanOrEqualInteger(this);
    }

    @Override
    public <U extends IValue> Result<U> negative() {
        return ResultFactory.makeResult(this.type, ((IInteger)this.getValue()).negate(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addInteger(IntegerResult n) {
        return ResultFactory.makeResult(this.type, ((IInteger)this.getValue()).add((IInteger)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addRational(RationalResult that) {
        return that.addInteger(this);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyRational(RationalResult that) {
        return that.multiplyInteger(this);
    }

    @Override
    protected <U extends IValue> Result<U> divideRational(RationalResult that) {
        try {
            return ResultFactory.makeResult(this.getTypeFactory().rationalType(), ((IRational)that.getValue()).divide((IInteger)this.getValue()), this.ctx);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected <U extends IValue> Result<U> subtractRational(RationalResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().rationalType(), ((IRational)that.getValue()).subtract((IInteger)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractInteger(IntegerResult n) {
        return ResultFactory.makeResult(this.type, ((IInteger)n.getValue()).subtract((IInteger)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyInteger(IntegerResult n) {
        return ResultFactory.makeResult(this.type, ((IInteger)this.getValue()).multiply((IInteger)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> divideInteger(IntegerResult n) {
        try {
            return ResultFactory.makeResult(this.type, ((IInteger)n.getValue()).divide((IInteger)this.getValue()), this.ctx);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected <U extends IValue> Result<U> remainderInteger(IntegerResult n) {
        try {
            return ResultFactory.makeResult(this.type, ((IInteger)n.getValue()).remainder((IInteger)this.getValue()), this.ctx);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected <U extends IValue> Result<U> moduloInteger(IntegerResult n) {
        try {
            return ResultFactory.makeResult(this.type, ((IInteger)n.getValue()).mod((IInteger)this.getValue()), this.ctx);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected <U extends IValue> Result<U> addReal(ElementResult<IReal> n) {
        return n.addInteger(this);
    }

    @Override
    protected <U extends IValue> Result<U> addListRelation(ListRelationResult that) {
        return that.addInteger(this);
    }

    @Override
    protected <U extends IValue> Result<U> addRelation(RelationResult that) {
        return that.addInteger(this);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyReal(ElementResult<IReal> n) {
        return n.multiplyInteger(this);
    }

    @Override
    protected <U extends IValue> Result<U> subtractReal(ElementResult<IReal> n) {
        return this.widenToReal().subtractReal(n);
    }

    @Override
    protected <U extends IValue> Result<U> divideReal(ElementResult<IReal> n) {
        return this.widenToReal().divideReal(n);
    }

    @Override
    protected <U extends IValue> Result<U> makeRangeFromInteger(IntegerResult from) {
        return this.makeRangeWithDefaultStep(from);
    }

    private <U extends IValue, V extends INumber> Result<U> makeRangeWithDefaultStep(Result<V> from) {
        if (((INumber)from.getValue()).less((IInteger)this.getValue()).getValue()) {
            return IntegerResult.makeStepRangeFromToWithSecond(from, this, ResultFactory.makeResult(from.getStaticType(), ((INumber)from.getValue()).add(this.getValueFactory().integer(1)), this.ctx), this.getValueFactory(), this.getTypeFactory(), this.ctx);
        }
        return IntegerResult.makeStepRangeFromToWithSecond(from, this, ResultFactory.makeResult(from.getStaticType(), ((INumber)from.getValue()).subtract(this.getValueFactory().integer(1)), this.ctx), this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> makeStepRangeFromInteger(IntegerResult from, Result<V> second) {
        return IntegerResult.makeStepRangeFromToWithSecond(from, this, second, this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> makeRangeFromReal(ElementResult<IReal> from) {
        return this.makeRangeWithDefaultStep(from);
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> makeStepRangeFromReal(ElementResult<IReal> from, Result<V> second) {
        return this.toReal(this).makeStepRangeFromReal(from, second);
    }

    @Override
    protected <U extends IValue> Result<U> makeRangeFromNumber(NumberResult from) {
        return this.makeRangeWithDefaultStep(from);
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> makeStepRangeFromNumber(NumberResult from, Result<V> second) {
        return IntegerResult.makeStepRangeFromToWithSecond(from, this, second, this.getValueFactory(), this.getTypeFactory(), this.ctx);
    }

    public static <U extends IValue, V extends INumber, W extends INumber, X extends IValue> Result<U> makeStepRangeFromToWithSecond(Result<V> from, Result<W> to, Result<X> second, IValueFactory vf, TypeFactory tf, IEvaluatorContext ctx) {
        IListWriter w;
        Type resultType;
        block4: {
            INumber zero;
            INumber diff;
            INumber iTo;
            INumber iFrom;
            block3: {
                iFrom = (INumber)from.getValue();
                iTo = (INumber)to.getValue();
                if (!second.getStaticType().isSubtypeOf(tf.numberType())) {
                    throw new UnexpectedType(tf.numberType(), second.getStaticType(), ctx.getCurrentAST());
                }
                INumber iSecond = (INumber)second.getValue();
                diff = iSecond.subtract(iFrom);
                zero = diff.subtract(diff);
                resultType = second.getStaticType().lub(from.getStaticType().lub(to.getStaticType()));
                w = vf.listWriter();
                if (!iFrom.lessEqual(iTo).getValue() || !diff.greater(zero).getValue()) break block3;
                while (iFrom.less(iTo).getValue()) {
                    w.append(iFrom);
                    iFrom = iFrom.add(diff);
                    if (!ctx.isInterrupted()) continue;
                    throw new InterruptException(ctx.getStackTrace(), ctx.getCurrentAST().getLocation());
                }
                break block4;
            }
            if (!iFrom.greaterEqual(iTo).getValue() || !diff.less(zero).getValue()) break block4;
            while (iFrom.greater(iTo).getValue()) {
                w.append(iFrom);
                iFrom = iFrom.add(diff);
            }
        }
        return ResultFactory.makeResult(tf.listType(resultType), w.done(), ctx);
    }

    @Override
    protected Result<IBool> equalToInteger(IntegerResult that) {
        return that.equalityBoolean(this);
    }

    @Override
    protected Result<IBool> nonEqualToInteger(IntegerResult that) {
        return that.nonEqualityBoolean(this);
    }

    @Override
    protected Result<IBool> nonEqualToReal(RealResult that) {
        return that.nonEquals(this.widenToReal());
    }

    @Override
    protected Result<IBool> greaterThanInteger(IntegerResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IInteger)that.getValue()).greater((IInteger)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanNumber(NumberResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((INumber)that.getValue()).greater((IInteger)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualInteger(IntegerResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IInteger)that.getValue()).greaterEqual((IInteger)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualNumber(NumberResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((INumber)that.getValue()).greaterEqual((IInteger)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanInteger(IntegerResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IInteger)that.getValue()).less((IInteger)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanNumber(NumberResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((INumber)that.getValue()).less((IInteger)this.getValue()), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualInteger(IntegerResult that) {
        return new LessThanOrEqualResult(((IInteger)that.getValue()).less((IInteger)this.getValue()).getValue(), ((IInteger)that.getValue()).equal((IInteger)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> equalToReal(RealResult that) {
        return that.equals(this.widenToReal());
    }

    @Override
    protected Result<IBool> equalToRational(RationalResult that) {
        return that.equalToInteger(this);
    }

    @Override
    protected Result<IBool> lessThanReal(RealResult that) {
        return that.lessThan(this.widenToReal());
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualReal(ElementResult<IReal> that) {
        return new LessThanOrEqualResult(((IReal)that.getValue()).less((IInteger)this.getValue()).getValue(), ((IReal)that.getValue()).equal((IInteger)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanReal(ElementResult<IReal> that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IReal)that.getValue()).greater((IInteger)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualReal(ElementResult<IReal> that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IReal)that.getValue()).greaterEqual((IInteger)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanRational(RationalResult that) {
        return that.lessThan(this.widenToRational());
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualRational(RationalResult that) {
        return new LessThanOrEqualResult(((IRational)that.getValue()).less((IInteger)this.getValue()).getValue(), ((IRational)that.getValue()).equal((IInteger)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanRational(RationalResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IRational)that.getValue()).greater((IInteger)this.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualRational(RationalResult that) {
        return ResultFactory.makeResult(this.getTypeFactory().boolType(), ((IRational)that.getValue()).greaterEqual((IInteger)this.getValue()), this.ctx);
    }

    <U extends IValue> Result<U> widenToReal() {
        return ResultFactory.makeResult(this.getTypeFactory().realType(), ((IInteger)this.getValue()).toReal(this.getValueFactory().getPrecision()), this.ctx);
    }

    <U extends IValue> Result<U> widenToRational() {
        return ResultFactory.makeResult(this.getTypeFactory().rationalType(), ((IInteger)this.getValue()).toRational(), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addNumber(NumberResult n) {
        return ResultFactory.makeResult(n.getStaticType(), ((IInteger)this.getValue()).add((INumber)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractNumber(NumberResult n) {
        return ResultFactory.makeResult(n.getStaticType(), ((INumber)n.getValue()).subtract((IInteger)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyNumber(NumberResult n) {
        return ResultFactory.makeResult(n.getStaticType(), ((IInteger)this.getValue()).multiply((INumber)n.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> divideNumber(NumberResult n) {
        try {
            return ResultFactory.makeResult(n.getStaticType(), ((INumber)n.getValue()).divide((IInteger)this.getValue(), this.getValueFactory().getPrecision()), this.ctx);
        }
        catch (ArithmeticException ae) {
            throw RuntimeExceptionFactory.arithmeticException(ae.getMessage(), this.ctx.getCurrentAST(), null);
        }
    }

    @Override
    protected Result<IBool> equalToNumber(NumberResult that) {
        return ResultFactory.bool(((INumber)that.getValue()).equal((IInteger)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected Result<IBool> nonEqualToNumber(NumberResult that) {
        return ResultFactory.bool(!((INumber)that.getValue()).equal((IInteger)this.getValue()).getValue(), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualNumber(NumberResult that) {
        return new LessThanOrEqualResult(((INumber)that.getValue()).less((IInteger)this.getValue()).getValue(), ((INumber)that.getValue()).equal((IInteger)this.getValue()).getValue(), this.ctx);
    }
}

