/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.FunctionDeclaration;
import org.rascalmpl.ast.FunctionModifier;
import org.rascalmpl.ast.KeywordFormal;
import org.rascalmpl.ast.NullASTVisitor;
import org.rascalmpl.ast.Signature;
import org.rascalmpl.ast.Tag;
import org.rascalmpl.ast.TagString;
import org.rascalmpl.ast.Tags;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.util.ExpiringFunctionResultCache;

public abstract class NamedFunction
extends AbstractFunction {
    private static final String RESOURCE_TAG = "resource";
    private static final String RESOLVER_TAG = "resolver";
    protected final String name;
    protected final boolean isDefault;
    protected final boolean isTest;
    protected final boolean isStatic;
    protected final String resourceScheme;
    protected final String resolverScheme;
    protected final Map<String, IValue> tags;
    private SoftReference<ExpiringFunctionResultCache<Result<IValue>>> memoization;
    protected final boolean hasMemoization;
    private final int memoizationTimeout;
    private final int memoizationMaxEntries;

    public NamedFunction(AbstractAST ast, IEvaluator<Result<IValue>> eval, Type functionType, Type dynamicType, List<KeywordFormal> initializers, String name, boolean varargs, boolean isDefault, boolean isTest, Environment env) {
        super(ast, eval, functionType, dynamicType, initializers, varargs, env);
        this.name = name;
        this.isDefault = isDefault;
        this.isTest = isTest;
        boolean bl = this.isStatic = env.isRootScope() && eval.__getRootScope() != env;
        if (ast instanceof FunctionDeclaration) {
            this.tags = this.parseTags((FunctionDeclaration)ast);
            this.resourceScheme = NamedFunction.getResourceScheme((FunctionDeclaration)ast);
            this.resolverScheme = NamedFunction.getResolverScheme((FunctionDeclaration)ast);
            IValue memoTag = this.tags.get("memo");
            if (memoTag != null) {
                this.hasMemoization = true;
                if (!(memoTag instanceof ISet)) {
                    memoTag = this.vf.set(memoTag);
                }
                this.memoizationTimeout = this.getMemoizationTimeout((ISet)memoTag);
                this.memoizationMaxEntries = this.getMemoizationMaxEntries((ISet)memoTag);
            } else {
                this.hasMemoization = false;
                this.memoizationTimeout = (int)TimeUnit.HOURS.toSeconds(1L);
                this.memoizationMaxEntries = -1;
            }
        } else {
            this.tags = new HashMap<String, IValue>();
            this.resourceScheme = null;
            this.resolverScheme = null;
            this.hasMemoization = false;
            this.memoizationTimeout = 0;
            this.memoizationMaxEntries = 0;
        }
    }

    protected static boolean hasTestMod(Signature sig) {
        for (FunctionModifier m4 : sig.getModifiers().getModifiers()) {
            if (!m4.isTest()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void clearMemoizationCache() {
        if (this.memoization != null) {
            ExpiringFunctionResultCache<Result<IValue>> m4 = this.memoization.get();
            if (m4 != null) {
                m4.clear();
                this.memoization.clear();
            }
            this.memoization = null;
        }
    }

    protected Result<IValue> getMemoizedResult(IValue[] argValues, Map<String, IValue> keyArgValues) {
        if (this.hasMemoization()) {
            ExpiringFunctionResultCache<Result<IValue>> memoizationActual = this.getMemoizationCache(false);
            return memoizationActual == null ? null : memoizationActual.lookup(argValues, keyArgValues);
        }
        return null;
    }

    private ExpiringFunctionResultCache<Result<IValue>> getMemoizationCache(boolean returnFresh) {
        ExpiringFunctionResultCache<Result<IValue>> result;
        ExpiringFunctionResultCache<Result<IValue>> expiringFunctionResultCache = result = this.memoization == null ? null : this.memoization.get();
        if (result == null && returnFresh) {
            result = new ExpiringFunctionResultCache(this.memoizationTimeout, this.memoizationMaxEntries);
            this.memoization = new SoftReference<ExpiringFunctionResultCache<Result<IValue>>>(result);
            return result;
        }
        return result;
    }

    protected Result<IValue> storeMemoizedResult(IValue[] argValues, Map<String, IValue> keyArgValues, Result<IValue> result) {
        if (this.hasMemoization()) {
            return this.getMemoizationCache(true).store(argValues, keyArgValues, result);
        }
        return result;
    }

    @Override
    public Result<IValue> call(Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues) throws MatchFailed {
        Result<IValue> result = this.getMemoizedResult(argValues, keyArgValues);
        if (result == null) {
            result = super.call(argTypes, argValues, keyArgValues);
            return this.storeMemoizedResult(argValues, keyArgValues, result);
        }
        return result;
    }

    protected void checkReturnTypeIsNotVoid(List<Expression> formals, IValue[] actuals, Map<Type, Type> renamings) {
        HashMap<Type, Type> bindings = new HashMap<Type, Type>();
        for (int i = 0; i < actuals.length; ++i) {
            formals.get(i).typeOf(this.declarationEnvironment, this.getEval(), false).match(NamedFunction.renameType(actuals[i].getType(), renamings, this.ctx.getCurrentAST().getLocation()), bindings);
        }
        if (!this.getReturnType().isBottom() && this.getReturnType().instantiate(bindings).isBottom()) {
            throw new MatchFailed();
        }
    }

    protected static String getResourceScheme(FunctionDeclaration declaration) {
        return NamedFunction.getScheme(RESOURCE_TAG, declaration);
    }

    protected static String getResolverScheme(FunctionDeclaration declaration) {
        return NamedFunction.getScheme(RESOLVER_TAG, declaration);
    }

    protected Tag checkMemoization(FunctionDeclaration func) {
        for (Tag tag : func.getTags().getTags()) {
            if (!Names.name(tag.getName()).equalsIgnoreCase("memo")) continue;
            return tag;
        }
        return null;
    }

    private int getMemoizationTimeout(ISet memoTags) {
        for (IValue memoTag : memoTags) {
            if (!(memoTag instanceof IConstructor) || !((IConstructor)memoTag).getName().equals("expireAfter")) continue;
            Map<String, IValue> kwParams = ((IConstructor)memoTag).asWithKeywordParameters().getParameters();
            IValue value = kwParams.get("seconds");
            if (value instanceof IInteger) {
                return ((IInteger)value).intValue();
            }
            value = kwParams.get("minutes");
            if (value instanceof IInteger) {
                return (int)TimeUnit.MINUTES.toSeconds(((IInteger)value).intValue());
            }
            value = kwParams.get("hours");
            if (!(value instanceof IInteger)) continue;
            return (int)TimeUnit.HOURS.toSeconds(((IInteger)value).intValue());
        }
        return (int)TimeUnit.HOURS.toSeconds(1L);
    }

    private int getMemoizationMaxEntries(ISet memoTags) {
        for (IValue memoTag : memoTags) {
            IValue value;
            if (!(memoTag instanceof IConstructor) || !((IConstructor)memoTag).getName().equals("maximumSize") || !((value = ((IConstructor)memoTag).get("entries")) instanceof IInteger)) continue;
            return ((IInteger)value).intValue();
        }
        return -1;
    }

    protected int computeIndexedPosition(AbstractAST node) {
        if (this.ast instanceof FunctionDeclaration) {
            FunctionDeclaration ast = (FunctionDeclaration)node;
            for (Tag tag : ast.getTags().getTags()) {
                if (!Names.name(tag.getName()).equalsIgnoreCase("index") || !tag.hasExpression()) continue;
                IInteger anno = (IInteger)tag.getExpression().interpret(this.getEval()).getValue();
                int pos = anno.intValue();
                if (pos >= 0 && pos < 10) {
                    return pos;
                }
                throw new ImplementationError("indexing only supported for argument 0 to 9");
            }
        }
        return 0;
    }

    public boolean hasMemoization() {
        return this.hasMemoization;
    }

    protected Map<String, IValue> parseTags(FunctionDeclaration declaration) {
        HashMap<String, IValue> result = new HashMap<String, IValue>();
        Tags tags = declaration.getTags();
        if (tags.hasTags()) {
            for (Tag tag : tags.getTags()) {
                String key = Names.name(tag.getName());
                result.put(key, tag.accept(new NullASTVisitor<IValue>(){

                    @Override
                    public IValue visitTagDefault(Tag.Default x) {
                        String value = ((TagString.Lexical)x.getContents()).getString();
                        value = value.substring(1, value.length() - 1);
                        return NamedFunction.this.vf.string(value);
                    }

                    @Override
                    public IValue visitTagEmpty(Tag.Empty x) {
                        return NamedFunction.this.vf.string("");
                    }

                    @Override
                    public IValue visitTagExpression(Tag.Expression x) {
                        return x.getExpression().interpret(NamedFunction.this.eval).getValue();
                    }
                }));
            }
        }
        return result;
    }

    @Override
    public IValue getTag(String key) {
        return this.tags.get(key);
    }

    @Override
    public boolean hasTag(String key) {
        return this.tags.containsKey(key);
    }

    private static String getScheme(String schemeTag, FunctionDeclaration declaration) {
        Tags tags = declaration.getTags();
        if (tags.hasTags()) {
            for (Tag tag : tags.getTags()) {
                if (!Names.name(tag.getName()).equals(schemeTag)) continue;
                String contents = ((TagString.Lexical)tag.getContents()).getString();
                if (contents.length() > 2 && contents.startsWith("{")) {
                    contents = contents.substring(1, contents.length() - 1);
                }
                return contents;
            }
        }
        return null;
    }

    protected static boolean isDefault(FunctionDeclaration func) {
        List<FunctionModifier> mods = func.getSignature().getModifiers().getModifiers();
        for (FunctionModifier m4 : mods) {
            if (!m4.isDefault()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTest() {
        return this.isTest;
    }

    @Override
    public String getHeader() {
        String sep = "";
        Object strFormals = "";
        for (Type tp : this.getFormals()) {
            strFormals = (String)strFormals + sep + tp;
            sep = ", ";
        }
        String name = this.getName();
        if (name == null) {
            name = "";
        }
        Object kwFormals = "";
        if (this.keywordParameterDefaults != null && this.staticFunctionType.hasKeywordParameters()) {
            sep = ((String)strFormals).length() > 0 ? ", " : "";
            for (String kw : this.keywordParameterDefaults.keySet()) {
                kwFormals = (String)kwFormals + sep + this.staticFunctionType.getKeywordParameterType(kw) + " " + kw + "= ...";
                sep = ", ";
            }
        }
        return this.getReturnType() + " " + name + "(" + (String)strFormals + (String)kwFormals + ")";
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public String getResourceScheme() {
        return this.resourceScheme;
    }

    @Override
    public boolean hasResourceScheme() {
        return this.resourceScheme != null;
    }

    @Override
    public boolean hasResolverScheme() {
        return this.resolverScheme != null;
    }

    @Override
    public String getResolverScheme() {
        return this.resolverScheme;
    }
}

