/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.result.CollectionResult;
import org.rascalmpl.interpreter.result.ElementResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.RelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.result.SetResult;

public class SetOrRelationResult<T extends ISet>
extends CollectionResult<T> {
    SetOrRelationResult(Type type, T value, IEvaluatorContext ctx) {
        super(type, value, ctx);
    }

    protected <V extends IValue> Result<IBool> elementOf(ElementResult<V> elementResult) {
        return ResultFactory.bool(((ISet)this.getValue()).contains((IValue)elementResult.getValue()), this.ctx);
    }

    protected <V extends IValue> Result<IBool> notElementOf(ElementResult<V> elementResult) {
        return ResultFactory.bool(!((ISet)this.getValue()).contains((IValue)elementResult.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addSet(SetResult s2) {
        return ResultFactory.makeResult(this.type.lub(s2.type), ((ISet)this.getValue()).union((ISet)s2.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> addRelation(RelationResult s2) {
        return ResultFactory.makeResult(this.type.lub(s2.type), ((ISet)this.getValue()).union((ISet)s2.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractSet(SetResult s2) {
        return ResultFactory.makeResult(s2.getStaticType(), ((ISet)s2.getValue()).subtract((ISet)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> subtractRelation(RelationResult s2) {
        return ResultFactory.makeResult(s2.getStaticType(), ((ISet)s2.getValue()).subtract((ISet)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplyRelation(RelationResult that) {
        Type tupleType = this.getTypeFactory().tupleType(that.type.getElementType(), this.type.getElementType());
        return ResultFactory.makeResult(this.getTypeFactory().relTypeFromTuple(tupleType), ((ISet)that.getValue()).product((ISet)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> multiplySet(SetResult s2) {
        Type tupleType = this.getTypeFactory().tupleType(s2.type.getElementType(), this.type.getElementType());
        return ResultFactory.makeResult(this.getTypeFactory().relTypeFromTuple(tupleType), ((ISet)s2.getValue()).product((ISet)this.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> intersectSet(SetResult s2) {
        return ResultFactory.makeResult(this.type.lub(s2.type), ((ISet)this.getValue()).intersect((ISet)s2.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue> Result<U> intersectRelation(RelationResult s2) {
        return ResultFactory.makeResult(this.type.lub(s2.type), ((ISet)this.getValue()).intersect((ISet)s2.getValue()), this.ctx);
    }

    @Override
    protected <U extends IValue, V extends IValue> Result<U> insertElement(Result<V> valueResult) {
        return this.addElement((ElementResult)valueResult);
    }

    protected <U extends IValue, V extends IValue> Result<U> addElement(ElementResult<V> that) {
        Type newType = this.getTypeFactory().setType(that.getStaticType().lub(this.getStaticType().getElementType()));
        return ResultFactory.makeResult(newType, ((ISet)this.getValue()).insert((IValue)that.getValue()), this.ctx);
    }

    protected <U extends IValue, V extends IValue> Result<U> removeElement(ElementResult<V> valueResult) {
        return ResultFactory.makeResult(this.type, ((ISet)this.getValue()).delete((IValue)valueResult.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> equalToRelation(RelationResult that) {
        return that.equalityBoolean(this);
    }

    @Override
    protected Result<IBool> nonEqualToRelation(RelationResult that) {
        return that.nonEqualityBoolean(this);
    }

    @Override
    protected Result<IBool> equalToSet(SetResult that) {
        return ResultFactory.bool(((ISet)this.getValue()).equals(that.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> nonEqualToSet(SetResult that) {
        return ResultFactory.bool(!((ISet)this.getValue()).equals(that.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanSet(SetResult that) {
        LessThanOrEqualResult loe = this.lessThanOrEqualSet(that);
        return loe.isLess();
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualSet(SetResult that) {
        boolean isSubset = ((ISet)that.getValue()).isSubsetOf((ISet)this.getValue());
        boolean equals = ((ISet)that.getValue()).equals(this.getValue());
        return new LessThanOrEqualResult(isSubset && !equals, equals, this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanSet(SetResult that) {
        return ResultFactory.bool(((ISet)this.getValue()).isSubsetOf((ISet)that.getValue()) && !((ISet)this.getValue()).equals(that.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualSet(SetResult that) {
        return ResultFactory.bool(((ISet)this.getValue()).isSubsetOf((ISet)that.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> lessThanRelation(RelationResult that) {
        return ResultFactory.bool(((ISet)that.getValue()).isSubsetOf((ISet)this.getValue()) && !((ISet)that.getValue()).equals(this.getValue()), this.ctx);
    }

    @Override
    protected LessThanOrEqualResult lessThanOrEqualRelation(RelationResult that) {
        boolean isSubset = ((ISet)that.getValue()).isSubsetOf((ISet)this.getValue());
        boolean equals = ((ISet)that.getValue()).equals(this.getValue());
        return new LessThanOrEqualResult(isSubset && !equals, equals, this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanRelation(RelationResult that) {
        return ResultFactory.bool(((ISet)this.getValue()).isSubsetOf((ISet)that.getValue()) && !((ISet)this.getValue()).equals(that.getValue()), this.ctx);
    }

    @Override
    protected Result<IBool> greaterThanOrEqualRelation(RelationResult that) {
        return ResultFactory.bool(((ISet)this.getValue()).isSubsetOf((ISet)that.getValue()), this.ctx);
    }
}

