/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.rascalmpl.ast.Case;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.PatternWithAction;
import org.rascalmpl.ast.Replacement;
import org.rascalmpl.ast.Statement;
import org.rascalmpl.ast.StringConstant;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.control_exceptions.Failure;
import org.rascalmpl.interpreter.control_exceptions.Insert;
import org.rascalmpl.interpreter.control_exceptions.InterruptException;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.IBooleanResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.SyntaxError;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.interpreter.utils.StringUtils;
import org.rascalmpl.interpreter.utils.TreeAsNode;
import org.rascalmpl.semantics.dynamic.QualifiedName;
import org.rascalmpl.semantics.dynamic.Tree;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class Cases {
    public static final List<String> IUPTR_NAMES = Arrays.asList("appl", "cycle", "amb", "char", "Tree::appl", "Tree::cycle", "Tree::char", "Tree::amb");
    private static final TypeFactory TF = TypeFactory.getInstance();

    public static List<CaseBlock> precompute(List<Case> cases, boolean allowReplacement) {
        ArrayList<CaseBlock> blocks = new ArrayList<CaseBlock>(cases.size());
        for (int i = 0; i < cases.size(); ++i) {
            Case d;
            int j;
            CaseBlock b;
            Case c = cases.get(i);
            if (!allowReplacement && c.hasPatternWithAction() && c.getPatternWithAction().isReplacing()) {
                throw new SyntaxError("=> not allowed in switch", c.getLocation());
            }
            if (Cases.isConcreteSyntaxPattern(c)) {
                b = new ConcreteBlock();
                ((ConcreteBlock)b).add(c);
                for (j = i + 1; j < cases.size() && Cases.isConcreteSyntaxPattern(d = cases.get(j)) && !Cases.isParseTreePattern(d); ++j) {
                    ((ConcreteBlock)b).add(d);
                    ++i;
                }
                blocks.add(b);
                continue;
            }
            if (Cases.isParseTreePattern(c)) {
                blocks.add(new DefaultBlock(c));
                continue;
            }
            if (Cases.isConstantTreePattern(c)) {
                b = new NodeCaseBlock();
                ((NodeCaseBlock)b).add(c);
                for (j = i + 1; j < cases.size() && Cases.isConstantTreePattern(d = cases.get(j)) && !Cases.isParseTreePattern(d); ++j) {
                    ((NodeCaseBlock)b).add(d);
                    ++i;
                }
                blocks.add(b);
                continue;
            }
            blocks.add(new DefaultBlock(c));
        }
        return blocks;
    }

    private static boolean isConcreteSyntaxPattern(Case d) {
        if (d.isDefault()) {
            return false;
        }
        Expression pattern = d.getPatternWithAction().getPattern();
        if (pattern.isVariableBecomes() || pattern.isTypedVariableBecomes()) {
            pattern = pattern.getPattern();
        }
        return pattern.getConcreteSyntaxType() != null && pattern.getConcreteSyntaxType() instanceof NonTerminalType;
    }

    private static boolean isParseTreePattern(Case d) {
        Expression func;
        if (d.isDefault()) {
            return false;
        }
        Expression pattern = d.getPatternWithAction().getPattern();
        if (pattern.isVariableBecomes() || pattern.isTypedVariableBecomes()) {
            pattern = pattern.getPattern();
        }
        return pattern.isCallOrTree() && (func = pattern.getExpression()).isQualifiedName() && IUPTR_NAMES.contains(Names.fullName(func.getQualifiedName()));
    }

    private static boolean isConstantTreePattern(Case c) {
        if (c.isDefault()) {
            return false;
        }
        Expression pattern = c.getPatternWithAction().getPattern();
        if (pattern.isVariableBecomes() || pattern.isTypedVariableBecomes()) {
            pattern = pattern.getPattern();
        }
        if (pattern.isCallOrTree()) {
            if (pattern.getExpression().isQualifiedName()) {
                return true;
            }
            if (pattern.getExpression().isLiteral()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isNonTerminalType(Type t2) {
        return t2 instanceof NonTerminalType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean matchAndEval(Result<IValue> subject, IMatchingResult mp, Statement stat, IEvaluator<Result<IValue>> eval) {
        boolean debug = false;
        Environment old = eval.getCurrentEnvt();
        eval.pushEnv();
        try {
            mp.initMatch(subject);
            while (mp.hasNext()) {
                eval.pushEnv();
                if (eval.isInterrupted()) {
                    throw new InterruptException(eval.getStackTrace(), eval.getCurrentAST().getLocation());
                }
                if (!mp.next()) continue;
                try {
                    try {
                        stat.interpret(eval);
                    }
                    catch (Insert e) {
                        if (e.getMatchPattern() == null) {
                            e.setMatchPattern(mp);
                        }
                        e.setStaticType(mp.getType(eval.getCurrentEnvt(), null));
                        throw e;
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (Failure failure) {
                    try {
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return false;
                    }
                }
            }
        }
        finally {
            if (debug) {
                System.err.println("Unwind to old env");
            }
            eval.unwind(old);
        }
    }

    private static class NodeCaseBlock
    extends CaseBlock {
        private final HashMap<String, List<DefaultBlock>> table = new HashMap();

        public NodeCaseBlock() {
            this.hasRegExp = false;
            this.allConcrete = false;
        }

        void add(Case c) {
            Expression pattern = c.getPatternWithAction().getPattern();
            Expression name = pattern.isVariableBecomes() || pattern.isTypedVariableBecomes() ? pattern.getPattern().getExpression() : pattern.getExpression();
            String key = null;
            if (name.isQualifiedName()) {
                key = ((QualifiedName.Default)name.getQualifiedName()).lastName();
            } else if (name.isLiteral()) {
                StringConstant constant = name.getLiteral().getStringLiteral().getConstant();
                key = StringUtils.unescapeBase(StringUtils.unquote(((StringConstant.Lexical)constant).getString()));
            }
            List<DefaultBlock> same = this.table.get(key);
            if (same == null) {
                same = new LinkedList<DefaultBlock>();
                this.table.put(key, same);
            }
            same.add(new DefaultBlock(c));
        }

        @Override
        public boolean matchAndEval(IEvaluator<Result<IValue>> eval, Result<IValue> subject) {
            IValue value = subject.getValue();
            Type subjectType = value.getType();
            if (subjectType.isSubtypeOf(TF.nodeType())) {
                boolean isTree;
                boolean bl = isTree = subjectType.isSubtypeOf(RascalValueFactory.Tree) && ((ITree)subject.getValue()).isAppl();
                if (isTree) {
                    TreeAsNode wrap = new TreeAsNode((ITree)subject.getValue());
                    Result<IValue> asTree = ResultFactory.makeResult(TF.nodeType(), wrap, eval);
                    if (this.tryCases(eval, asTree)) {
                        return true;
                    }
                } else if (this.tryCases(eval, subject)) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean tryCases(IEvaluator<Result<IValue>> eval, Result<IValue> subject) {
            List<DefaultBlock> alts = this.table.get(((INode)subject.getValue()).getName());
            if (alts != null) {
                for (DefaultBlock c : alts) {
                    Environment old = eval.getCurrentEnvt();
                    try {
                        eval.pushEnv();
                        if (!c.matchAndEval(eval, subject)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    catch (Failure e) {}
                    continue;
                    finally {
                        eval.unwind(old);
                    }
                }
            }
            return false;
        }
    }

    private static class DefaultBlock
    extends CaseBlock {
        private final Case theCase;
        private final PatternWithAction pattern;
        private IMatchingResult matcher;
        private final Replacement replacement;
        private final List<Expression> conditions;
        private final Expression insert;

        public DefaultBlock(Case c) {
            this.theCase = c;
            this.pattern = c.hasPatternWithAction() ? c.getPatternWithAction() : null;
            this.replacement = this.pattern != null && this.pattern.hasReplacement() ? this.pattern.getReplacement() : null;
            this.conditions = this.replacement != null && this.replacement.hasConditions() ? this.replacement.getConditions() : Collections.emptyList();
            this.insert = this.replacement != null ? this.replacement.getReplacementExpression() : null;
            this.computePredicates(c);
        }

        @Override
        public boolean matchAndEval(IEvaluator<Result<IValue>> eval, Result<IValue> subject) {
            if (this.theCase.isDefault()) {
                this.theCase.getStatement().interpret(eval);
                return true;
            }
            if (this.matcher == null) {
                this.matcher = this.pattern.getPattern().buildMatcher(eval, false);
            }
            if (this.pattern.hasStatement()) {
                return Cases.matchAndEval(subject, this.matcher, this.pattern.getStatement(), eval);
            }
            return DefaultBlock.matchEvalAndReplace(subject, this.matcher, this.conditions, this.insert, eval);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean matchEvalAndReplace(Result<IValue> subject, IMatchingResult mp, List<Expression> conditions, Expression replacementExpr, IEvaluator<Result<IValue>> eval) {
            Environment old = eval.getCurrentEnvt();
            try {
                mp.initMatch(subject);
                while (mp.hasNext()) {
                    if (eval.isInterrupted()) {
                        throw new InterruptException(eval.getStackTrace(), eval.getCurrentAST().getLocation());
                    }
                    if (!mp.next()) continue;
                    int size = conditions.size();
                    if (size == 0) {
                        throw new Insert(replacementExpr.interpret(eval), mp, mp.getType(eval.getCurrentEnvt(), null));
                    }
                    IBooleanResult[] gens = new IBooleanResult[size];
                    Environment[] olds = new Environment[size];
                    Environment old2 = eval.getCurrentEnvt();
                    int i = 0;
                    try {
                        olds[0] = eval.getCurrentEnvt();
                        eval.pushEnv();
                        gens[0] = conditions.get(0).getBacktracker(eval);
                        gens[0].init();
                        while (i >= 0 && i < size) {
                            if (eval.isInterrupted()) {
                                throw new InterruptException(eval.getStackTrace(), eval.getCurrentAST().getLocation());
                            }
                            if (gens[i].hasNext() && gens[i].next()) {
                                if (i == size - 1) {
                                    throw new Insert(replacementExpr.interpret(eval), mp, mp.getType(eval.getCurrentEnvt(), null));
                                }
                                gens[++i] = conditions.get(i).getBacktracker(eval);
                                gens[i].init();
                                olds[i] = eval.getCurrentEnvt();
                                eval.pushEnv();
                                continue;
                            }
                            eval.unwind(olds[i]);
                            eval.pushEnv();
                            --i;
                        }
                    }
                    finally {
                        eval.unwind(old2);
                    }
                }
            }
            finally {
                eval.unwind(old);
            }
            return false;
        }
    }

    public static class ConcreteBlock
    extends CaseBlock {
        private final Hashtable<IConstructor, List<DefaultBlock>> table = new Hashtable();

        public ConcreteBlock() {
            this.allConcrete = true;
            this.hasRegExp = false;
        }

        void add(Case c) {
            IConstructor key;
            List<DefaultBlock> same;
            Expression pattern = c.getPatternWithAction().getPattern();
            if (pattern.isVariableBecomes() || pattern.isTypedVariableBecomes()) {
                pattern = pattern.getPattern();
            }
            if ((same = this.table.get(key = ((Tree.Appl)pattern).getProduction())) == null) {
                same = new LinkedList<DefaultBlock>();
                this.table.put(key, same);
            }
            same.add(new DefaultBlock(c));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matchAndEval(IEvaluator<Result<IValue>> eval, Result<IValue> subject) {
            List<DefaultBlock> alts;
            IValue value = subject.getValue();
            Type subjectType = value.getType();
            if (subjectType.isSubtypeOf(RascalValueFactory.Tree) && TreeAdapter.isAppl((ITree)value) && (alts = this.table.get(TreeAdapter.getProduction((ITree)value))) != null) {
                for (CaseBlock caseBlock : alts) {
                    Environment old = eval.getCurrentEnvt();
                    try {
                        if (!caseBlock.matchAndEval(eval, subject)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    catch (Failure f) {}
                    continue;
                    finally {
                        eval.unwind(old);
                    }
                }
            }
            return false;
        }
    }

    public static abstract class CaseBlock {
        public boolean hasRegExp = false;
        public boolean allConcrete = false;

        public abstract boolean matchAndEval(IEvaluator<Result<IValue>> var1, Result<IValue> var2);

        protected void computePredicates(Case c) {
            if (c.hasPatternWithAction()) {
                Expression pattern = c.getPatternWithAction().getPattern();
                this.hasRegExp |= pattern.isLiteral() && pattern.getLiteral().isRegExp();
                Type type = pattern.getConcreteSyntaxType();
                this.allConcrete &= Cases.isNonTerminalType(type);
            }
        }
    }
}

