/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.util.List;
import org.rascalmpl.ast.DecimalIntegerLiteral;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.NullASTVisitor;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.ast.StringConstant;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.semantics.dynamic.Expression;
import org.rascalmpl.semantics.dynamic.QualifiedName;
import org.rascalmpl.values.RascalValueFactory;

public class IUPTRAstToSymbolConstructor
extends NullASTVisitor<IConstructor> {
    private IValueFactory vf;

    public IUPTRAstToSymbolConstructor(IValueFactory vf) {
        this.vf = vf;
    }

    @Override
    public IConstructor visitQualifiedNameDefault(QualifiedName.Default x) {
        throw new NonGroundSymbolException();
    }

    @Override
    public IConstructor visitExpressionMultiVariable(Expression.MultiVariable x) {
        throw new NonGroundSymbolException();
    }

    @Override
    public IConstructor visitExpressionQualifiedName(Expression.QualifiedName x) {
        throw new NonGroundSymbolException();
    }

    @Override
    public IConstructor visitExpressionTypedVariable(Expression.TypedVariable x) {
        throw new NonGroundSymbolException();
    }

    @Override
    public IConstructor visitExpressionTypedVariableBecomes(Expression.TypedVariableBecomes x) {
        throw new NonGroundSymbolException();
    }

    @Override
    public IConstructor visitExpressionAnti(Expression.Anti x) {
        throw new NonGroundSymbolException();
    }

    @Override
    public IConstructor visitExpressionCallOrTree(Expression.CallOrTree x) {
        Expression namePart = x.getExpression();
        if (!namePart.isQualifiedName()) {
            throw new ImplementationError("weird AST");
        }
        String name = ((QualifiedName.Default)namePart.getQualifiedName()).lastName();
        if (name.equals("lit")) {
            StringConstant.Lexical arg = (StringConstant.Lexical)x.getArguments().get(0).getLiteral().getStringLiteral().getConstant();
            String str = arg.getString();
            str = str.substring(1, str.length() - 1);
            return this.vf.constructor(RascalValueFactory.Symbol_Lit, this.vf.string(str));
        }
        if (name.equals("cilit")) {
            StringConstant.Lexical arg = (StringConstant.Lexical)x.getArguments().get(0).getLiteral().getStringLiteral().getConstant();
            String str = arg.getString();
            str = str.substring(1, str.length() - 1);
            return this.vf.constructor(RascalValueFactory.Symbol_Cilit, this.vf.string(str));
        }
        if (name.equals("empty")) {
            return this.vf.constructor(RascalValueFactory.Symbol_Empty);
        }
        if (name.equals("seq")) {
            IList list = this.vf.list(new IValue[0]);
            Expression.List arg = (Expression.List)x.getArguments().get(0);
            for (Expression y : arg.getElements0()) {
                list = list.append(y.accept(this));
            }
            return this.vf.constructor(RascalValueFactory.Symbol_Seq, list);
        }
        if (name.equals("opt")) {
            IConstructor arg = x.getArguments().get(0).accept(this);
            return this.vf.constructor(RascalValueFactory.Symbol_Opt, arg);
        }
        if (name.equals("alt")) {
            ISet set = this.vf.set(new IValue[0]);
            Expression.Set arg = (Expression.Set)x.getArguments().get(0);
            for (Expression y : arg.getElements0()) {
                set = set.insert(y.accept(this));
            }
            return this.vf.constructor(RascalValueFactory.Symbol_Alt, set);
        }
        if (name.equals("tuple")) {
            List<Expression> args = x.getArguments();
            IConstructor head = args.get(0).accept(this);
            IList rest = this.vf.list(new IValue[0]);
            for (Expression arg : ((Expression.List)args.get(1)).getElements0()) {
                rest = rest.append(arg.accept(this));
            }
            return this.vf.constructor(RascalValueFactory.Symbol_Tuple, head, rest);
        }
        if (name.equals("sort")) {
            StringConstant.Lexical arg = (StringConstant.Lexical)x.getArguments().get(0).getLiteral().getStringLiteral().getConstant();
            String str = arg.getString();
            str = str.substring(1, str.length() - 1);
            return this.vf.constructor(RascalValueFactory.Symbol_Sort, this.vf.string(str));
        }
        if (name.equals("layouts")) {
            StringConstant.Lexical arg = (StringConstant.Lexical)x.getArguments().get(0).getLiteral().getStringLiteral().getConstant();
            String str = arg.getString();
            str = str.substring(1, str.length() - 1);
            return this.vf.constructor(RascalValueFactory.Symbol_Layouts, this.vf.string(str));
        }
        if (name.equals("iter")) {
            IConstructor arg = x.getArguments().get(0).accept(this);
            return this.vf.constructor(RascalValueFactory.Symbol_Iter, arg);
        }
        if (name.equals("iter-star")) {
            IConstructor arg = x.getArguments().get(0).accept(this);
            return this.vf.constructor(RascalValueFactory.Symbol_IterStar, arg);
        }
        if (name.equals("iter-star-seps")) {
            IConstructor arg = x.getArguments().get(0).accept(this);
            Expression.List args = (Expression.List)x.getArguments().get(1);
            IList seps = this.vf.list(new IValue[0]);
            for (Expression elem : args.getElements0()) {
                seps = seps.append(elem.accept(this));
            }
            return this.vf.constructor(RascalValueFactory.Symbol_IterStarSeps, arg, seps);
        }
        if (name.equals("iter-seps")) {
            IConstructor arg = x.getArguments().get(0).accept(this);
            Expression.List args = (Expression.List)x.getArguments().get(1);
            IList seps = this.vf.list(new IValue[0]);
            for (Expression elem : args.getElements0()) {
                seps = seps.append(elem.accept(this));
            }
            return this.vf.constructor(RascalValueFactory.Symbol_IterSeps, arg, seps);
        }
        if (name.equals("parameterized-sort")) {
            List<Expression> args = x.getArguments();
            StringConstant.Lexical sort = (StringConstant.Lexical)x.getArguments().get(0).getLiteral().getStringLiteral().getConstant();
            IList rest = this.vf.list(new IValue[0]);
            for (Expression arg : ((Expression.List)args.get(1)).getElements0()) {
                rest = rest.append(arg.accept(this));
            }
            return this.vf.constructor(RascalValueFactory.Symbol_ParameterizedSort, this.vf.string(sort.getString()), rest);
        }
        if (name.equals("lit")) {
            StringConstant.Lexical arg = (StringConstant.Lexical)x.getArguments().get(0).getLiteral().getStringLiteral().getConstant();
            return this.vf.constructor(RascalValueFactory.Symbol_Lit, this.vf.string(arg.getString()));
        }
        if (name.equals("char-class")) {
            List<Expression> args = x.getArguments();
            IList ranges = this.vf.list(new IValue[0]);
            for (Expression arg : ((Expression.List)args.get(0)).getElements0()) {
                ranges = ranges.append(arg.accept(this));
            }
            return this.vf.constructor(RascalValueFactory.Symbol_CharClass, ranges);
        }
        if (name.equals("single")) {
            DecimalIntegerLiteral.Lexical arg1 = (DecimalIntegerLiteral.Lexical)x.getArguments().get(0).getLiteral().getIntegerLiteral().getDecimal();
            IInteger num = this.vf.integer(Integer.parseInt(arg1.getString()));
            return this.vf.constructor(RascalValueFactory.CharRange_Single, num);
        }
        if (name.equals("range")) {
            DecimalIntegerLiteral.Lexical arg1 = (DecimalIntegerLiteral.Lexical)x.getArguments().get(0).getLiteral().getIntegerLiteral().getDecimal();
            IInteger num1 = this.vf.integer(Integer.parseInt(arg1.getString()));
            DecimalIntegerLiteral.Lexical arg2 = (DecimalIntegerLiteral.Lexical)x.getArguments().get(1).getLiteral().getIntegerLiteral().getDecimal();
            IInteger num2 = this.vf.integer(Integer.parseInt(arg2.getString()));
            return this.vf.constructor(RascalValueFactory.CharRange_Range, num1, num2);
        }
        throw new ImplementationError("Non-IUPTR AST expression: " + name + ", " + x);
    }

    public static class NonGroundSymbolException
    extends RuntimeException {
        private static final long serialVersionUID = 2430739406856140650L;
    }
}

