/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import io.usethesource.vallang.ISourceLocation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.rascalmpl.interpreter.utils.JavaCompiler;

public final class JavaFileObjectImpl
extends SimpleJavaFileObject {
    private ByteArrayOutputStream byteCode;
    private final CharSequence source;
    private final ISourceLocation sloc;

    JavaFileObjectImpl(String baseName, CharSequence source) throws URISyntaxException {
        this(null, baseName, source);
    }

    JavaFileObjectImpl(ISourceLocation sloc, String baseName, CharSequence source) throws URISyntaxException {
        this(sloc, baseName, source, JavaFileObject.Kind.SOURCE);
    }

    public ISourceLocation getSloc() {
        return this.sloc;
    }

    JavaFileObjectImpl(ISourceLocation sloc, String baseName, CharSequence source, JavaFileObject.Kind kind) throws URISyntaxException {
        super(JavaCompiler.toURI(baseName + (kind == JavaFileObject.Kind.SOURCE ? JavaFileObject.Kind.SOURCE.extension : "")), kind);
        this.source = source;
        this.sloc = sloc;
    }

    JavaFileObjectImpl(String name, JavaFileObject.Kind kind) throws URISyntaxException {
        this(null, name, null, kind);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws UnsupportedOperationException {
        if (this.source == null) {
            throw new UnsupportedOperationException("getCharContent()");
        }
        return this.source;
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.getByteCode());
    }

    @Override
    public OutputStream openOutputStream() {
        this.byteCode = new ByteArrayOutputStream();
        return this.byteCode;
    }

    byte[] getByteCode() {
        return this.byteCode.toByteArray();
    }
}

