/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public final class Timing {
    private long start;

    public void start() {
        this.start = Timing.getCpuTime();
    }

    public long duration() {
        long now = Timing.getCpuTime();
        long diff = now - this.start;
        this.start = now;
        return diff;
    }

    public static long getCpuTime() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        return bean.isCurrentThreadCpuTimeSupported() ? bean.getCurrentThreadCpuTime() : 0L;
    }

    public static long getUserTime() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        return bean.isCurrentThreadCpuTimeSupported() ? bean.getCurrentThreadUserTime() : 0L;
    }

    public static long getSystemTime() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        return bean.isCurrentThreadCpuTimeSupported() ? bean.getCurrentThreadCpuTime() - bean.getCurrentThreadUserTime() : 0L;
    }
}

