/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.lang.aut;

import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;

public class IO {
    private final IValueFactory values;

    public IO(IValueFactory values) {
        this.values = values;
    }

    public IValue readAUT(IString nameAUTFile) {
        String fileName = nameAUTFile.getValue();
        ISetWriter rw = this.values.setWriter();
        BufferedReader bufRead = null;
        try {
            FileReader input = new FileReader(fileName);
            bufRead = new BufferedReader(input);
            String line = bufRead.readLine();
            line = bufRead.readLine();
            while (line != null) {
                String[] fields = line.split("\\\"");
                String[] field0 = fields[0].split("[\\(\\s,]");
                String[] field2 = fields[2].split("[\\)\\s,]");
                rw.insert(this.values.tuple(this.values.integer(field0[1]), this.values.string(fields[1]), this.values.integer(field2[1])));
                line = bufRead.readLine();
            }
        }
        catch (IOException ioex) {
            throw RuntimeExceptionFactory.io(ioex);
        }
        finally {
            if (bufRead != null) {
                try {
                    bufRead.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rw.done();
    }

    private int numberOfStates(ISet st) {
        st.size();
        int r = 0;
        for (IValue v : st) {
            ITuple t2 = (ITuple)v;
            IInteger from = (IInteger)t2.get(0);
            IInteger to = (IInteger)t2.get(2);
            if (from.intValue() > r) {
                r = from.intValue();
            }
            if (to.intValue() <= r) continue;
            r = to.intValue();
        }
        return r + 1;
    }

    private void printTransitions(PrintStream fos, ISet st) {
        fos.println("des(0," + st.size() + "," + this.numberOfStates(st) + ")");
        for (IValue v : st) {
            ITuple t2 = (ITuple)v;
            IInteger from = (IInteger)t2.get(0);
            IString act = (IString)t2.get(1);
            IInteger to = (IInteger)t2.get(2);
            fos.print('(');
            fos.print(from.intValue());
            fos.print(',');
            fos.print("\"" + act.getValue() + "\"");
            fos.print(',');
            fos.print(to.intValue());
            fos.print(')');
            fos.println();
        }
    }

    public void writeAUT(IString nameAUTFile, ISet value) {
        String fileName = nameAUTFile.getValue();
        try (PrintStream fos = null;){
            File file = new File(fileName);
            fos = new PrintStream(file);
            this.printTransitions(fos, value);
        }
    }
}

