/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.lang.html;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.Range;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.uri.URIResolverRegistry;

public class IO {
    private static final String ORIGIN_FIELD = "rascal-src";
    private final IValueFactory factory;
    private final TypeStore store;
    private final Type HTMLElement;
    private final Type textConstructor;
    private final Type dataConstructor;
    private final Type htmlConstructor;
    private final PrintWriter err;

    public IO(IValueFactory factory, TypeStore store, PrintWriter out, PrintWriter err) {
        this.factory = factory;
        this.store = store;
        this.HTMLElement = store.lookupAbstractDataType("HTMLElement");
        this.textConstructor = store.lookupConstructor(this.HTMLElement, "text").iterator().next();
        this.dataConstructor = store.lookupConstructor(this.HTMLElement, "data").iterator().next();
        this.htmlConstructor = store.lookupConstructor(this.HTMLElement, "html").iterator().next();
        this.err = err;
    }

    public IValue readHTMLString(IString string, ISourceLocation base, IBool trackOrigins, IBool includeEndTags, ISourceLocation src) {
        if (string.length() == 0) {
            throw RuntimeExceptionFactory.io("empty HTML document");
        }
        Parser htmlParser = Parser.htmlParser().settings(new ParseSettings(false, false)).setTrackPosition(trackOrigins.getValue());
        Document doc = Jsoup.parse(string.getValue(), base.getURI().toString(), htmlParser);
        return this.toConstructorTree(doc, trackOrigins.getValue() ? src : null, includeEndTags.getValue());
    }

    public IValue readHTMLFile(ISourceLocation file, ISourceLocation base, IBool trackOrigins, IBool includeEndTags) {
        IValue iValue;
        block9: {
            InputStream reader = URIResolverRegistry.getInstance().getInputStream(file);
            try {
                Parser htmlParser = Parser.htmlParser().settings(new ParseSettings(false, false)).setTrackPosition(trackOrigins.getValue());
                Document doc = Jsoup.parse(reader, "UTF-8", base.getURI().toString(), htmlParser);
                iValue = this.toConstructorTree(doc, trackOrigins.getValue() ? file : null, includeEndTags.getValue());
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException e) {
                    throw RuntimeExceptionFactory.malformedURI(file.getURI().toASCIIString());
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io(e);
                }
            }
            reader.close();
        }
        return iValue;
    }

    private IValue toConstructorTree(Document doc, ISourceLocation file, boolean includeEndTags) {
        IConstructor result = this.factory.constructor(this.htmlConstructor, this.factory.list(this.toConstructorTree(doc.head(), file, includeEndTags), this.toConstructorTree(doc.body(), file, includeEndTags)));
        if (file != null) {
            return result.asWithKeywordParameters().setParameter(ORIGIN_FIELD, file);
        }
        return result;
    }

    private IValue toConstructorTree(Node node, ISourceLocation file, boolean includeEndTags) {
        IConstructor result;
        Type cons;
        if (node instanceof TextNode) {
            return this.toTextConstructor((TextNode)node, file);
        }
        if (node instanceof DataNode) {
            return this.toDataConstructor((DataNode)node, file);
        }
        assert (node instanceof Element) : node.toString();
        Element elem = (Element)node;
        Set<Type> alternatives = this.store.lookupConstructor(this.HTMLElement, elem.tagName());
        TypeFactory tf = TypeFactory.getInstance();
        Type type = cons = alternatives.size() > 0 ? alternatives.iterator().next() : tf.constructorFromTuple(this.store, this.HTMLElement, elem.tagName(), tf.tupleType(tf.listType(this.HTMLElement)));
        if (alternatives.size() == 0) {
            this.err.println("No HTML constructor declared for " + elem.tagName());
        }
        HashMap<String, IValue> kws = new HashMap<String, IValue>();
        for (Object a : elem.attributes()) {
            kws.put(((Attribute)a).getKey(), this.factory.string(((Attribute)a).getValue()));
        }
        IListWriter w = this.factory.listWriter();
        for (Node n : elem.childNodes()) {
            if (n instanceof Comment) continue;
            w.append(this.toConstructorTree(n, file, includeEndTags));
        }
        IConstructor iConstructor = result = cons.getArity() > 0 ? this.factory.constructor(cons, new IValue[]{w.done()}, kws) : this.factory.constructor(cons, new IValue[0], kws);
        if (file != null) {
            ISourceLocation src = this.nodeToLoc(elem.sourceRange(), elem.endSourceRange(), file, includeEndTags);
            return result.asWithKeywordParameters().setParameter(ORIGIN_FIELD, src);
        }
        return result;
    }

    private ISourceLocation nodeToLoc(Range startRange, Range endRange, ISourceLocation file, boolean includeEndTags) {
        if (!startRange.isTracked()) {
            return file;
        }
        return includeEndTags && endRange.isTracked() ? this.factory.sourceLocation(file, startRange.start().pos(), endRange.end().pos() - startRange.start().pos(), startRange.start().lineNumber(), endRange.end().lineNumber(), startRange.start().columnNumber() - 1, endRange.end().columnNumber() - 1) : this.factory.sourceLocation(file, startRange.start().pos(), startRange.end().pos() - startRange.start().pos(), startRange.start().lineNumber(), startRange.end().lineNumber(), startRange.start().columnNumber() - 1, startRange.end().columnNumber() - 1);
    }

    private IValue toDataConstructor(DataNode node, ISourceLocation file) {
        IConstructor cons = this.factory.constructor(this.dataConstructor, this.factory.string(node.getWholeData()));
        return file != null ? cons.asWithKeywordParameters().setParameter(ORIGIN_FIELD, this.nodeToLoc(node.sourceRange(), node.sourceRange(), file, false)) : cons;
    }

    private IValue toTextConstructor(TextNode elem, ISourceLocation file) {
        IConstructor cons = this.factory.constructor(this.textConstructor, this.factory.string(elem.getWholeText()));
        return file != null ? cons.asWithKeywordParameters().setParameter(ORIGIN_FIELD, this.nodeToLoc(elem.sourceRange(), elem.sourceRange(), file, false)) : cons;
    }

    public IString writeHTMLString(IConstructor cons, IString charset, IConstructor escapeMode, IBool outline, IBool prettyPrint, IInteger indentAmount, IInteger maxPaddingWidth, IConstructor syntax, IBool dropOrigins) {
        try {
            Document doc = this.createHTMLDocument(cons, dropOrigins.getValue());
            doc = doc.outputSettings(this.createOutputSettings(charset.getValue(), escapeMode.getName(), outline.getValue(), prettyPrint.getValue(), indentAmount.intValue(), maxPaddingWidth.intValue(), syntax.getName()));
            return this.factory.string(doc.outerHtml());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e);
        }
    }

    public void writeHTMLFile(ISourceLocation file, IConstructor cons, IString charset, IConstructor escapeMode, IBool outline, IBool prettyPrint, IInteger indentAmount, IInteger maxPaddingWidth, IConstructor syntax, IBool dropOrigins) {
        try (Writer out = URIResolverRegistry.getInstance().getCharacterWriter(file, charset.getValue(), false);){
            Document doc = this.createHTMLDocument(cons, dropOrigins.getValue());
            doc = doc.outputSettings(this.createOutputSettings(charset.getValue(), escapeMode.getName(), outline.getValue(), prettyPrint.getValue(), indentAmount.intValue(), maxPaddingWidth.intValue(), syntax.getName()));
            out.write(doc.outerHtml());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e);
        }
    }

    private Document.OutputSettings createOutputSettings(String charset, String escapeMode, boolean outline, boolean prettyPrint, int indentAmount, int maxPaddingWidth, String syntax) {
        return new Document.OutputSettings().charset(charset).escapeMode(Entities.EscapeMode.valueOf(escapeMode.replaceAll("Mode", ""))).outline(outline).prettyPrint(prettyPrint).indentAmount(indentAmount).maxPaddingWidth(maxPaddingWidth).syntax(Document.OutputSettings.Syntax.valueOf(syntax.replaceAll("Syntax", "")));
    }

    private Document createHTMLDocument(IConstructor cons, boolean dropOrigins) throws IOException {
        Document doc = new Document("http://localhost");
        Node node = this.normalise(cons, this.createElement(cons, dropOrigins));
        doc.appendChild(node);
        return doc;
    }

    private Node normalise(IConstructor cons, Node elem) {
        switch (cons.getName()) {
            case "html": {
                return elem;
            }
            case "head": {
                return new Element("html").appendChild(elem);
            }
            case "body": {
                return new Element("html").appendChild(elem);
            }
        }
        return new Element("html").appendChild(new Element("body").appendChild(elem));
    }

    private Node createElement(IConstructor cons, boolean dropOrigins) {
        if (cons.getConstructorType().getArity() == 0) {
            return this.emptyElementWithAttributes(cons, dropOrigins);
        }
        if (cons.getName().equals("text")) {
            return new TextNode(((IString)cons.get(0)).getValue());
        }
        if (cons.getName().equals("data")) {
            return new DataNode(((IString)cons.get(0)).getValue());
        }
        Element elem = this.emptyElementWithAttributes(cons, dropOrigins);
        for (IValue child : (IList)cons.get(0)) {
            elem.appendChild(this.createElement((IConstructor)child, dropOrigins));
        }
        return elem;
    }

    private Element emptyElementWithAttributes(IConstructor cons, boolean dropOrigins) {
        Element elem = new Element(cons.getName());
        Map<String, IValue> parameters = cons.asWithKeywordParameters().getParameters();
        for (Map.Entry<String, IValue> e : parameters.entrySet()) {
            IValue v;
            if (dropOrigins && e.getKey().equals(ORIGIN_FIELD)) continue;
            elem = elem.attr(e.getKey(), (v = e.getValue()).getType().isString() ? ((IString)v).getValue() : v.toString());
        }
        return elem;
    }
}

