/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.jline.utils.OSUtils;
import org.rascalmpl.interpreter.utils.RascalManifest;
import org.rascalmpl.library.Messages;
import org.rascalmpl.uri.StandardLibraryURIResolver;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.file.MavenRepositoryURIResolver;
import org.rascalmpl.uri.jar.JarURIResolver;
import org.rascalmpl.util.maven.Artifact;
import org.rascalmpl.util.maven.ArtifactCoordinate;
import org.rascalmpl.util.maven.MavenMessages;
import org.rascalmpl.util.maven.MavenParser;
import org.rascalmpl.util.maven.ModelResolutionError;
import org.rascalmpl.util.maven.Scope;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;

public class PathConfig {
    private static final IValueFactory vf = ValueFactoryFactory.getValueFactory();
    private static final TypeFactory tf = TypeFactory.getInstance();
    private static final TypeStore store = new TypeStore(new TypeStore[0]);
    public static final Type PathConfigType = tf.abstractDataType(store, "PathConfig", new Type[0]);
    public static final Map<String, Type> PathConfigFields = Map.of("projectRoot", tf.sourceLocationType(), "srcs", tf.listType(tf.sourceLocationType()), "ignores", tf.listType(tf.sourceLocationType()), "bin", tf.sourceLocationType(), "resources", tf.listType(tf.sourceLocationType()), "libs", tf.listType(tf.sourceLocationType()), "messages", tf.listType(Messages.Message), "generatedSources", tf.sourceLocationType());
    private static final Type pathConfigConstructor = tf.constructor(store, PathConfigType, "pathConfig", new Type[0]);
    private final ISourceLocation projectRoot;
    private final List<ISourceLocation> srcs;
    private final List<ISourceLocation> libs;
    private final ISourceLocation bin;
    private final List<ISourceLocation> ignores;
    private final List<ISourceLocation> resources;
    private final List<IConstructor> messages;
    private static final ISourceLocation defaultProjectRoot;
    private static final List<ISourceLocation> defaultIgnores;
    private static final List<ISourceLocation> defaultResources;
    private static final List<IConstructor> defaultMessages;
    private static final ISourceLocation defaultBin;
    private static final List<ISourceLocation> defaultLibs;

    public PathConfig() {
        this(defaultProjectRoot);
    }

    public PathConfig(ISourceLocation projectRoot) {
        this.projectRoot = projectRoot;
        this.srcs = Collections.emptyList();
        this.ignores = defaultIgnores;
        this.bin = defaultBin;
        this.libs = Collections.emptyList();
        this.resources = defaultResources;
        this.messages = defaultMessages;
    }

    public PathConfig(IConstructor pcfg) throws IOException {
        this(PathConfig.projectRoot(pcfg), PathConfig.srcs(pcfg), PathConfig.libs(pcfg), PathConfig.bin(pcfg), PathConfig.ignores(pcfg), PathConfig.resources(pcfg), PathConfig.messages(pcfg));
    }

    private PathConfig(ISourceLocation projectRoot, List<ISourceLocation> srcs, List<ISourceLocation> libs, ISourceLocation bin, List<ISourceLocation> ignores, List<ISourceLocation> resources, List<IConstructor> messages) {
        this.projectRoot = projectRoot;
        this.srcs = srcs;
        this.ignores = ignores;
        this.bin = bin;
        this.libs = ignores;
        this.resources = resources;
        this.messages = messages;
    }

    private PathConfig(ISourceLocation projectRoot, IList srcs, IList libs, ISourceLocation bin, IList ignores, IList resources, IList messages) {
        this.projectRoot = projectRoot;
        this.srcs = srcs.stream().map(ISourceLocation.class::cast).collect(Collectors.toList());
        this.ignores = ignores.stream().map(ISourceLocation.class::cast).collect(Collectors.toList());
        this.bin = bin;
        this.libs = libs.stream().map(ISourceLocation.class::cast).collect(Collectors.toList());
        this.resources = resources.stream().map(ISourceLocation.class::cast).collect(Collectors.toList());
        this.messages = messages.stream().map(IConstructor.class::cast).collect(Collectors.toList());
    }

    public int hashCode() {
        return Objects.hash(this.projectRoot, this.srcs, this.libs, this.bin, this.ignores, this.resources, this.messages);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathConfig)) {
            return false;
        }
        PathConfig other = (PathConfig)obj;
        return Objects.equals(this.projectRoot, other.projectRoot) && Objects.equals(this.srcs, other.srcs) && Objects.equals(this.ignores, other.ignores) && Objects.equals(this.bin, other.bin) && Objects.equals(this.libs, other.libs) && Objects.equals(this.resources, other.resources) && Objects.equals(this.messages, other.messages);
    }

    private static IList messages(IConstructor pcfg) {
        return PathConfig.getListValueFromConstructor(pcfg, defaultMessages, "messages");
    }

    private static IList resources(IConstructor pcfg) {
        IList val = (IList)pcfg.asWithKeywordParameters().getParameter("resources");
        return val == null ? defaultResources.stream().collect(vf.listWriter()) : val;
    }

    private static IList ignores(IConstructor pcfg) {
        return PathConfig.getListValueFromConstructor(pcfg, defaultIgnores, "ignores");
    }

    private static IList getListValueFromConstructor(IConstructor pcfg, List<? extends IValue> def, String label) {
        IList val = (IList)pcfg.asWithKeywordParameters().getParameter(label);
        return val == null ? def.stream().collect(vf.listWriter()) : val;
    }

    private static ISourceLocation bin(IConstructor pcfg) {
        ISourceLocation val = (ISourceLocation)pcfg.asWithKeywordParameters().getParameter("bin");
        return val == null ? defaultBin : val;
    }

    private static IList libs(IConstructor pcfg) {
        return PathConfig.getListValueFromConstructor(pcfg, defaultLibs, "libs");
    }

    private static IList srcs(IConstructor pcfg) {
        return PathConfig.getListValueFromConstructor(pcfg, Collections.emptyList(), "srcs");
    }

    private static ISourceLocation projectRoot(IConstructor pcfg) {
        ISourceLocation val = (ISourceLocation)pcfg.asWithKeywordParameters().getParameter("projectRoot");
        return val == null ? defaultProjectRoot : val;
    }

    String makeFileName(String qualifiedModuleName) {
        return this.makeFileName(qualifiedModuleName, "rsc");
    }

    public static ISourceLocation getDefaultBin() {
        return defaultBin;
    }

    public static IList getDefaultResources() {
        return defaultResources.stream().collect(vf.listWriter());
    }

    public static IList getDefaultIgnoresList() {
        return PathConfig.convertLocs(defaultIgnores);
    }

    private static IList convertLocs(List<ISourceLocation> locs) {
        IListWriter w = vf.listWriter();
        w.appendAll(locs);
        return (IList)w.done();
    }

    public static List<ISourceLocation> getDefaultIgnores() {
        return Collections.unmodifiableList(defaultIgnores);
    }

    public IValueFactory getValueFactory() {
        return vf;
    }

    public IList getSrcs() {
        return this.srcs.stream().collect(vf.listWriter());
    }

    public IList getResources() {
        return this.resources.stream().collect(vf.listWriter());
    }

    public IList getMessages() {
        return this.messages.stream().collect(vf.listWriter());
    }

    public PathConfig addSourceLoc(ISourceLocation dir) throws IOException {
        ArrayList<ISourceLocation> extendedsrcs = new ArrayList<ISourceLocation>(this.srcs);
        extendedsrcs.add(dir);
        return new PathConfig(this.projectRoot, extendedsrcs, this.libs, this.bin, this.ignores, this.resources, this.messages);
    }

    public PathConfig addResource(ISourceLocation loc) {
        ArrayList<ISourceLocation> extendedResources = new ArrayList<ISourceLocation>(this.resources);
        extendedResources.add(loc);
        return new PathConfig(this.projectRoot, this.srcs, this.libs, this.bin, this.ignores, extendedResources, this.messages);
    }

    public PathConfig setResources(List<ISourceLocation> resources) throws IOException {
        return new PathConfig(this.projectRoot, this.srcs, this.libs, this.bin, this.ignores, resources, this.messages);
    }

    public IList getIgnores() {
        return this.ignores.stream().collect(vf.listWriter());
    }

    public PathConfig addIgnoreLoc(ISourceLocation dir) throws IOException {
        ArrayList<ISourceLocation> extendedignores = new ArrayList<ISourceLocation>(this.ignores);
        extendedignores.add(dir);
        return new PathConfig(this.projectRoot, this.srcs, this.libs, this.bin, extendedignores, this.resources, this.messages);
    }

    public IList getLibs() {
        return this.libs.stream().collect(vf.listWriter());
    }

    public IList getLibsAndTarget() {
        return this.getLibs().append(this.getBin());
    }

    public PathConfig addLibLoc(ISourceLocation dir) throws IOException {
        ArrayList<ISourceLocation> extendedlibs = new ArrayList<ISourceLocation>(this.libs);
        extendedlibs.add(dir);
        return new PathConfig(this.projectRoot, this.srcs, extendedlibs, this.bin, this.ignores, this.resources, this.messages);
    }

    public static PathConfig fromSourceProjectMemberRascalManifest(ISourceLocation projectMember, RascalConfigMode mode) {
        if (!URIResolverRegistry.getInstance().isDirectory(projectMember)) {
            projectMember = URIUtil.getParentLocation(projectMember);
        }
        return PathConfig.fromSourceProjectRascalManifest(PathConfig.inferProjectRoot(projectMember), mode, true);
    }

    public static ISourceLocation resolveProjectOnClasspath(String projectName) throws IOException {
        RascalManifest mf = new RascalManifest();
        Enumeration<URL> mfs = PathConfig.class.getClassLoader().getResources("META-INF/RASCAL.MF");
        for (URL url : Collections.list(mfs)) {
            try {
                ISourceLocation loc;
                String libName = mf.getProjectName(url.openStream());
                if (libName == null || !libName.equals(projectName)) continue;
                if (url.getProtocol().equals("jar") && url.getPath().startsWith("file:/")) {
                    loc = vf.sourceLocation("file", null, URIUtil.fromURL(new URL(url.getPath())).getPath());
                    loc = URIUtil.changePath(loc, loc.getPath().replace("!/META-INF/RASCAL.MF", ""));
                } else {
                    loc = vf.sourceLocation(URIUtil.fromURL(url));
                    loc = URIUtil.getParentLocation(URIUtil.getParentLocation(loc));
                }
                return loc;
            }
            catch (IOException | URISyntaxException e) {
                throw new FileNotFoundException(e.getMessage());
            }
        }
        throw new FileNotFoundException(projectName + " jar could not be located in the current runtime classpath");
    }

    public static ISourceLocation resolveCurrentRascalRuntimeJar() throws IOException {
        return PathConfig.resolveProjectOnClasspath("rascal");
    }

    public static ISourceLocation inferProjectRoot(Class<?> clazz) throws IOException {
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (url.getProtocol().equals("file")) {
            try {
                return PathConfig.inferProjectRoot(vf.sourceLocation(URIUtil.fromURL(url)));
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        throw new FileNotFoundException();
    }

    public static ISourceLocation inferProjectRoot(ISourceLocation member) {
        ISourceLocation current = member;
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        while (current != null && reg.exists(current) && reg.isDirectory(current)) {
            if (reg.exists(URIUtil.getChildLocation(current, "META-INF/RASCAL.MF"))) {
                return current;
            }
            if (URIUtil.getParentLocation(current).equals(current)) {
                return reg.isDirectory(member) ? member : URIUtil.getParentLocation(member);
            }
            current = URIUtil.getParentLocation(current);
        }
        return current;
    }

    public static PathConfig parse(String pathConfigString) throws IOException {
        try {
            IConstructor cons = (IConstructor)new StandardTextReader().read(vf, store, PathConfigType, new StringReader(pathConfigString));
            IWithKeywordParameters<? extends IConstructor> kwp = cons.asWithKeywordParameters();
            ISourceLocation projectRoot = (ISourceLocation)kwp.getParameter("projectRoot");
            IList srcs = (IList)kwp.getParameter("srcs");
            IList libs = (IList)kwp.getParameter("libs");
            IList ignores = (IList)kwp.getParameter("ignores");
            IList resources = (IList)kwp.getParameter("resources");
            IList messages = (IList)kwp.getParameter("messages");
            ISourceLocation bin = (ISourceLocation)kwp.getParameter("bin");
            return new PathConfig(projectRoot != null ? projectRoot : defaultProjectRoot, srcs != null ? srcs : vf.list(new IValue[0]), libs != null ? libs : vf.list(new IValue[0]), bin != null ? bin : defaultBin, ignores != null ? ignores : vf.list(new IValue[0]), resources != null ? resources : vf.list(new IValue[0]), messages != null ? messages : vf.list(new IValue[0]));
        }
        catch (FactTypeUseException e) {
            throw new IOException(e);
        }
    }

    private static void buildRascalSelfApplicationConfig(ISourceLocation workspaceRascal, RascalConfigMode mode, List<Artifact> mavenClassPath, IListWriter srcs, IListWriter libs, IListWriter messages) throws IOException {
        if (mode == RascalConfigMode.INTERPRETER) {
            srcs.append(URIUtil.rootLocation("std"));
            messages.append(Messages.info("Bootstrap |std:///| = " + StandardLibraryURIResolver.getDebugBootstrapLocation(), workspaceRascal));
            ISourceLocation runtime = PathConfig.resolveCurrentRascalRuntimeJar();
            libs.append(runtime);
            messages.append(Messages.info("Bootstrap runtime   = " + runtime, workspaceRascal));
        } else {
            srcs.append(URIUtil.getChildLocation(workspaceRascal, "src/org/rascalmpl/library"));
        }
        srcs.append(URIUtil.getChildLocation(workspaceRascal, "src/org/rascalmpl/compiler"));
        srcs.append(URIUtil.getChildLocation(workspaceRascal, "src/org/rascalmpl/tutor"));
        srcs.append(URIUtil.getChildLocation(workspaceRascal, "test/org/rascalmpl/test/data"));
        srcs.append(URIUtil.getChildLocation(workspaceRascal, "test/org/rascalmpl/benchmark"));
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        ISourceLocation typepal = URIUtil.correctLocation("project", "typepal", "src");
        if (reg.exists(typepal)) {
            typepal = reg.logicalToPhysical(typepal);
        } else {
            try {
                typepal = PathConfig.resolveProjectOnClasspath("typepal");
                typepal = MavenRepositoryURIResolver.mavenize(typepal);
                typepal = JarURIResolver.jarify(typepal);
            }
            catch (FileNotFoundException e) {
                typepal = PathConfig.getPomXmlTypePalDependency(mavenClassPath);
            }
        }
        if (typepal != null) {
            srcs.append(typepal);
        } else {
            messages.append(Messages.error("Could not find typepal in local project, or on the classpath, or amongst the dependencies. Loading the compiler will fail.", workspaceRascal));
        }
    }

    private static void buildRascalLSPConfig(ISourceLocation manifestRoot, RascalConfigMode mode, List<Artifact> mavenClasspath, IListWriter srcs, IListWriter libs, IListWriter messages) throws IOException {
        ISourceLocation insideRascalJar = JarURIResolver.jarify(PathConfig.resolveCurrentRascalRuntimeJar());
        ISourceLocation rascalCompiler = URIUtil.getChildLocation(insideRascalJar, "org/rascalmpl/compiler");
        ISourceLocation typepal = URIUtil.getChildLocation(insideRascalJar, "org/rascalmpl/typepal");
        if (mode == RascalConfigMode.INTERPRETER) {
            srcs.append(URIUtil.rootLocation("std"));
            srcs.append(rascalCompiler);
            srcs.append(typepal);
        } else {
            libs.append(JarURIResolver.jarify(PathConfig.resolveCurrentRascalRuntimeJar()));
            srcs.append(rascalCompiler);
            srcs.append(typepal);
        }
        libs.append(PathConfig.resolveCurrentRascalRuntimeJar());
        PathConfig.translateSources(manifestRoot, srcs, messages);
        for (Artifact art : mavenClasspath) {
            String artId = art.getCoordinate().getArtifactId();
            if (artId.equals("rascal") || artId.equals("typepal")) continue;
            PathConfig.addArtifactToPathConfig(art, manifestRoot, mode, srcs, libs, messages);
        }
    }

    private static void translateSources(ISourceLocation manifestRoot, IListWriter srcs, IListWriter messages) {
        RascalManifest manifest = new RascalManifest();
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        for (String srcName : manifest.getSourceRoots(manifestRoot)) {
            ISourceLocation srcFolder = URIUtil.getChildLocation(manifestRoot, srcName);
            if (!reg.exists(srcFolder) || !reg.isDirectory(srcFolder)) {
                messages.append(Messages.error("Source folder " + srcFolder + " does not exist.", PathConfig.getRascalMfLocation(manifestRoot)));
            }
            srcs.append(srcFolder);
        }
    }

    private static void buildNormalProjectConfig(ISourceLocation manifestRoot, RascalConfigMode mode, List<Artifact> mavenClasspath, boolean isRoot, IListWriter srcs, IListWriter libs, IListWriter messages) throws IOException, URISyntaxException {
        if (isRoot) {
            if (mode == RascalConfigMode.INTERPRETER) {
                srcs.append(URIUtil.rootLocation("std"));
                libs.append(PathConfig.resolveCurrentRascalRuntimeJar());
            } else {
                assert (mode == RascalConfigMode.COMPILER) : "should be compiler";
                libs.append(JarURIResolver.jarify(PathConfig.resolveCurrentRascalRuntimeJar()));
            }
        }
        for (Artifact art : mavenClasspath) {
            PathConfig.addArtifactToPathConfig(art, manifestRoot, mode, srcs, libs, messages);
        }
        if (isRoot || mode == RascalConfigMode.INTERPRETER) {
            PathConfig.translateSources(manifestRoot, srcs, messages);
        } else if (manifestRoot.getScheme().equals("project")) {
            libs.append(URIUtil.correctLocation("target", manifestRoot.getAuthority(), ""));
        } else {
            libs.append(URIUtil.getChildLocation(manifestRoot, "target/classes"));
        }
        try {
            ISourceLocation lsp = PathConfig.resolveProjectOnClasspath("rascal-lsp");
            if (mode == RascalConfigMode.INTERPRETER) {
                srcs.append(URIUtil.getChildLocation(JarURIResolver.jarify(lsp), "library"));
            }
            PathConfig.addLibraryToLibPath(libs, mode, lsp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addArtifactToPathConfig(Artifact art, ISourceLocation manifestRoot, RascalConfigMode mode, IListWriter srcs, IListWriter libs, IListWriter messages) throws IOException {
        RascalManifest manifest = new RascalManifest();
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        try {
            Path resolvedLocation = art.getResolved();
            if (resolvedLocation == null) {
                ISourceLocation projectLoc = URIUtil.correctLocation("project", art.getCoordinate().getArtifactId(), "");
                if (reg.exists(projectLoc)) {
                    if (mode == RascalConfigMode.INTERPRETER) {
                        messages.append(MavenMessages.info("Redirected: " + art.getCoordinate() + " to: " + projectLoc, art));
                    }
                    PathConfig.addProjectAndItsDependencies(mode, srcs, libs, messages, projectLoc);
                } else {
                    messages.append(MavenMessages.error("Declared dependency does not exist: " + art.getCoordinate(), art));
                }
                return;
            }
            ISourceLocation dep = MavenRepositoryURIResolver.mavenize(URIUtil.createFileLocation(resolvedLocation));
            String libProjectName = manifest.getManifestProjectName(manifest.manifest(dep));
            if (libProjectName == null || libProjectName.isEmpty()) {
                libs.append(dep);
                return;
            }
            if (libProjectName.equals("rascal")) {
                return;
            }
            if (libProjectName.equals("rascal-lsp")) {
                PathConfig.checkLSPVersionsMatch(manifestRoot, messages, dep, art);
                return;
            }
            ISourceLocation projectLoc = URIUtil.correctLocation("project", libProjectName, "");
            if (reg.exists(projectLoc)) {
                if (mode == RascalConfigMode.INTERPRETER) {
                    messages.append(MavenMessages.info("Redirected: " + art.getCoordinate() + " to: " + projectLoc, art));
                }
                libs.append(URIUtil.correctLocation("target", libProjectName, ""));
                PathConfig.addProjectAndItsDependencies(mode, srcs, libs, messages, projectLoc);
            } else {
                PathConfig.addLibraryToLibPath(libs, mode, dep);
                if (mode == RascalConfigMode.INTERPRETER) {
                    PathConfig.addLibraryToSourcePath(reg, srcs, messages, dep);
                }
            }
        }
        catch (URISyntaxException e) {
            messages.append(MavenMessages.error("Could not convert " + art.getCoordinate() + " to a loc: " + e, art));
        }
    }

    private static void addProjectAndItsDependencies(RascalConfigMode mode, IListWriter srcs, IListWriter libs, IListWriter messages, ISourceLocation projectLoc) throws IOException, URISyntaxException {
        projectLoc = PathConfig.safeResolve(projectLoc);
        List<Artifact> childMavenClasspath = PathConfig.getPomXmlCompilerClasspath(projectLoc, messages);
        PathConfig.buildNormalProjectConfig(projectLoc, mode, childMavenClasspath, false, srcs, libs, messages);
    }

    private static void checkLSPVersionsMatch(ISourceLocation manifestRoot, IListWriter messages, ISourceLocation jarLocation, Artifact artifact) throws IOException {
        try {
            ISourceLocation loadedRascalLsp = PathConfig.resolveProjectOnClasspath("rascal-lsp");
            URIResolverRegistry reg = URIResolverRegistry.getInstance();
            try (InputStream in = reg.getInputStream(loadedRascalLsp);
                 InputStream in2 = reg.getInputStream(jarLocation);){
                String version = new Manifest(in).getMainAttributes().getValue("Specification-Version");
                String otherVersion = new Manifest(in2).getMainAttributes().getValue("Specification-Version");
                if (version != null && !version.equals(otherVersion)) {
                    messages.append(MavenMessages.warning("Pom.xml dependency on rascal-lsp has version " + otherVersion + " while the effective version in the VScode extension is " + version + ". This can have funny effects in the IDE while debugging or code browsing, for that reason we've replaced it with the effective one, please update your pom.xml.", artifact));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static PathConfig fromSourceProjectRascalManifest(ISourceLocation manifestRoot, RascalConfigMode mode, boolean isRoot) {
        manifestRoot = PathConfig.safeResolve(manifestRoot);
        RascalManifest manifest = new RascalManifest();
        IRascalValueFactory vf = IRascalValueFactory.getInstance();
        String projectName = manifest.getProjectName(manifestRoot);
        IListWriter libsWriter = (IListWriter)vf.listWriter().unique();
        IListWriter srcsWriter = (IListWriter)vf.listWriter().unique();
        IListWriter resourcesWriter = (IListWriter)vf.listWriter().unique();
        IListWriter messages = vf.listWriter();
        if (isRoot && mode == RascalConfigMode.INTERPRETER) {
            messages.append(Messages.info("Rascal version is " + RascalManifest.getRascalVersionNumber(), PathConfig.getPomXmlLocation(manifestRoot)));
        }
        ISourceLocation target = manifestRoot.getScheme().equals("project") ? URIUtil.correctLocation("target", projectName, "") : URIUtil.getChildLocation(manifestRoot, "target/classes");
        try {
            List<Artifact> mavenClasspath = PathConfig.getPomXmlCompilerClasspath(manifestRoot, messages);
            if (projectName.equals("rascal")) {
                messages.append(Messages.info("Detected Rascal project self-application", PathConfig.getPomXmlLocation(manifestRoot)));
                PathConfig.buildRascalSelfApplicationConfig(manifestRoot, mode, mavenClasspath, srcsWriter, libsWriter, messages);
            } else if (projectName.equals("rascal-lsp")) {
                PathConfig.buildRascalLSPConfig(manifestRoot, mode, mavenClasspath, srcsWriter, libsWriter, messages);
            } else {
                PathConfig.buildNormalProjectConfig(manifestRoot, mode, mavenClasspath, isRoot, srcsWriter, libsWriter, messages);
            }
        }
        catch (IOException | URISyntaxException e) {
            messages.append(Messages.warning(e.getMessage(), PathConfig.getPomXmlLocation(manifestRoot)));
        }
        if (!projectName.isEmpty()) {
            PathConfig.validateProjectName(manifestRoot, projectName, messages);
        }
        return new PathConfig(manifestRoot, (IList)srcsWriter.done(), (IList)libsWriter.done(), target, vf.list(new IValue[0]), (IList)resourcesWriter.done(), (IList)messages.done());
    }

    private static ISourceLocation upgradeToProjectScheme(ISourceLocation loc, String projectName) {
        ISourceLocation projectResolved;
        if (loc.getScheme().equals("project") || projectName == null || projectName.isBlank()) {
            return loc;
        }
        ISourceLocation projectScheme = URIUtil.correctLocation("project", projectName, "");
        ISourceLocation originalResolved = PathConfig.safeResolve(loc);
        if (PathConfig.semanticallySame(originalResolved, projectResolved = PathConfig.safeResolve(projectScheme))) {
            return projectScheme;
        }
        return loc;
    }

    private static boolean semanticallySame(ISourceLocation a, ISourceLocation b) {
        if (!a.getScheme().equals("file")) {
            return a.equals(b);
        }
        if (!b.getScheme().equals("file")) {
            return false;
        }
        Object aPath = a.getPath();
        Object bPath = b.getPath();
        if (((String)aPath).endsWith("/")) {
            if (!((String)bPath).endsWith("/")) {
                bPath = (String)bPath + "/";
            }
        } else if (((String)bPath).endsWith("/")) {
            aPath = (String)aPath + "/";
        }
        if (OSUtils.IS_WINDOWS || OSUtils.IS_OSX) {
            return ((String)aPath).equalsIgnoreCase((String)bPath);
        }
        return ((String)aPath).equals(bPath);
    }

    private static ISourceLocation safeResolve(ISourceLocation loc) {
        try {
            ISourceLocation result = URIResolverRegistry.getInstance().logicalToPhysical(loc);
            if (result != null) {
                return result;
            }
            return loc;
        }
        catch (IOException ignored) {
            return loc;
        }
    }

    private static void validateProjectName(ISourceLocation manifestRoot, String projectName, IListWriter messages) {
        try {
            RascalManifest manifest = new RascalManifest();
            URIResolverRegistry reg = URIResolverRegistry.getInstance();
            ISourceLocation projectLoc = URIUtil.correctLocation("project", projectName, "");
            manifestRoot = reg.logicalToPhysical(manifestRoot);
            if (!projectLoc.equals(manifestRoot) && !projectName.equals(URIUtil.getLocationName(manifestRoot))) {
                messages.append(Messages.error("Project-Name in RASCAL.MF (" + projectName + ") should be equal to folder name (" + URIUtil.getLocationName(manifestRoot) + ")", PathConfig.getRascalMfLocation(manifestRoot)));
            }
            try (InputStream mfi = manifest.manifest(manifestRoot);){
                String reqlibs = new Manifest(mfi).getMainAttributes().getValue("Require-Libraries");
                if (reqlibs != null && !reqlibs.isEmpty()) {
                    messages.append(Messages.info("Require-Libraries in RASCAL.MF are not used anymore. Please use Maven dependencies in pom.xml.", PathConfig.getRascalMfLocation(manifestRoot)));
                }
            }
        }
        catch (IOException e) {
            messages.append(Messages.error(e.getMessage(), PathConfig.getRascalMfLocation(manifestRoot)));
        }
    }

    private static void addLibraryToSourcePath(URIResolverRegistry reg, IListWriter srcsWriter, IListWriter messages, ISourceLocation jar) {
        ISourceLocation unpacked = JarURIResolver.jarify(jar);
        if (!reg.exists(URIUtil.getChildLocation(unpacked, "META-INF/RASCAL.MF"))) {
            return;
        }
        RascalManifest manifest = new RascalManifest();
        boolean foundSrc = false;
        for (String src : manifest.getSourceRoots(jar)) {
            ISourceLocation srcLib = URIUtil.getChildLocation(unpacked, src);
            if (!reg.exists(srcLib)) continue;
            srcsWriter.append(srcLib);
            foundSrc = true;
        }
        if (!foundSrc) {
            srcsWriter.append(jar);
        }
    }

    private static void addLibraryToLibPath(IListWriter libsWriter, RascalConfigMode mode, ISourceLocation jar) {
        libsWriter.append(jar);
        if (mode == RascalConfigMode.COMPILER) {
            ISourceLocation jarifiedDep = JarURIResolver.jarify(jar);
            if (jarifiedDep != jar) {
                libsWriter.append(jarifiedDep);
            }
        } else assert (mode == RascalConfigMode.INTERPRETER) : "there should be only 2 modes";
    }

    private static ISourceLocation getRascalMfLocation(ISourceLocation project) {
        return URIUtil.getChildLocation(project, "META-INF/RASCAL.MF");
    }

    private static ISourceLocation getPomXmlLocation(ISourceLocation project) {
        try {
            ISourceLocation pomxml = URIUtil.getChildLocation(project, "pom.xml");
            return URIResolverRegistry.getInstance().logicalToPhysical(pomxml);
        }
        catch (IOException e) {
            assert (false) : e.getMessage();
            return URIUtil.correctLocation("unknown", "", "pom.xml");
        }
    }

    private static List<Artifact> getPomXmlCompilerClasspath(ISourceLocation manifestRoot, IListWriter messages) {
        try {
            ISourceLocation resolved;
            URIResolverRegistry reg = URIResolverRegistry.getInstance();
            if (!manifestRoot.getScheme().equals("file") && (resolved = reg.logicalToPhysical(manifestRoot)) != null) {
                if (!resolved.getScheme().equals("file")) {
                    return Collections.emptyList();
                }
                manifestRoot = resolved;
            }
            if (!manifestRoot.getPath().endsWith("pom.xml")) {
                manifestRoot = URIUtil.getChildLocation(manifestRoot, "pom.xml");
            }
            MavenParser mavenParser = new MavenParser(Path.of(manifestRoot.getURI()));
            Artifact rootProject = mavenParser.parseProject();
            messages.appendAll(rootProject.getMessages());
            List<Artifact> result = rootProject.resolveDependencies(Scope.COMPILE, mavenParser);
            for (Artifact a : result) {
                messages.appendAll(a.getMessages());
            }
            return result;
        }
        catch (IOException | RuntimeException | ModelResolutionError e) {
            return Collections.emptyList();
        }
    }

    private static boolean isTypePalArtifact(ArtifactCoordinate artifact) {
        return "org.rascalmpl".equals(artifact.getGroupId()) && "typepal".equals(artifact.getArtifactId());
    }

    private static ISourceLocation getPomXmlTypePalDependency(List<Artifact> pomDependencies) {
        for (Artifact artifact : pomDependencies) {
            ArtifactCoordinate coordinate = artifact.getCoordinate();
            if (!PathConfig.isTypePalArtifact(coordinate)) continue;
            return MavenRepositoryURIResolver.make(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getVersion(), "");
        }
        return null;
    }

    public ISourceLocation getProjectRoot() {
        return this.projectRoot;
    }

    public ISourceLocation getBin() {
        return this.bin;
    }

    @Deprecated
    String makeFileName(String qualifiedModuleName, String extension) {
        return qualifiedModuleName.replaceAll("::", "/") + "." + extension;
    }

    @Deprecated
    public String getModuleName(ISourceLocation moduleLoc) throws IOException {
        String modulePath = moduleLoc.getPath();
        if (!modulePath.endsWith(".rsc")) {
            throw new IOException("Not a Rascal source file: " + moduleLoc);
        }
        if (moduleLoc.getScheme().equals("std") || moduleLoc.getScheme().equals("mvn")) {
            return this.pathToModulename(modulePath, "/");
        }
        for (ISourceLocation dir : this.srcs) {
            if (!modulePath.startsWith(dir.getPath()) || moduleLoc.getScheme() != dir.getScheme()) continue;
            return this.pathToModulename(modulePath, dir.getPath());
        }
        for (ISourceLocation dir : this.libs) {
            if (!modulePath.startsWith(dir.getPath()) || moduleLoc.getScheme() != dir.getScheme()) continue;
            return this.pathToModulename(modulePath, dir.getPath());
        }
        throw new IOException("No module name found for " + moduleLoc + "\n" + this);
    }

    @Deprecated
    private String pathToModulename(String modulePath, String folder) {
        String moduleName = modulePath.replaceFirst(folder, "").replace(".rsc", "");
        if (moduleName.startsWith("/")) {
            moduleName = moduleName.substring(1, moduleName.length());
        }
        return moduleName.replace("/", "::");
    }

    @Deprecated
    private String moduleToDir(String module) {
        return module.replaceAll("::", "/");
    }

    @Deprecated
    private ISourceLocation getFullURI(String path, ISourceLocation dir) throws URISyntaxException {
        return URIUtil.getChildLocation(dir, path);
    }

    @Deprecated
    public List<String> listModuleEntries(String moduleRoot) {
        assert (!moduleRoot.endsWith("::"));
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        try {
            String modulePath = this.moduleToDir(moduleRoot);
            ArrayList<String> result = new ArrayList<String>();
            for (ISourceLocation dir : this.srcs) {
                ISourceLocation full = this.getFullURI(modulePath, dir);
                if (!reg.exists(full)) continue;
                try {
                    String[] entries = reg.listEntries(full);
                    if (entries == null) continue;
                    for (String module : entries) {
                        if (module.endsWith(".rsc")) {
                            result.add(module.substring(0, module.length() - ".rsc".length()));
                            continue;
                        }
                        if (module.indexOf(46) != -1 || !reg.isDirectory(this.getFullURI(module, full))) continue;
                        result.add(module + "::");
                    }
                }
                catch (IOException iOException) {
                }
            }
            if (result.size() > 0) {
                return result;
            }
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public IConstructor asConstructor() {
        HashMap<String, IValue> config = new HashMap<String, IValue>();
        config.put("projectRoot", this.getProjectRoot());
        config.put("srcs", this.getSrcs());
        config.put("ignores", this.getIgnores());
        config.put("bin", this.getBin());
        config.put("libs", this.getLibs());
        config.put("resources", this.getResources());
        config.put("messages", this.getMessages());
        return vf.constructor(pathConfigConstructor, new IValue[0], config);
    }

    public void reportConfigurationInfo() {
        ISourceLocation pom = URIUtil.getChildLocation(this.projectRoot, "pom.xml");
        String sep = "\n  - ";
        this.messages.add(Messages.info("Project root is " + this.projectRoot, pom));
        this.messages.add(Messages.info("Bin folder   is " + this.bin, pom));
        if (!this.srcs.isEmpty()) {
            this.messages.add(Messages.info("Source module path is:" + sep + this.srcs.stream().map(Object::toString).collect(Collectors.joining(sep)), pom));
        } else {
            this.messages.add(Messages.info("Source path is empty", pom));
        }
        if (!this.ignores.isEmpty()) {
            this.messages.add(Messages.info("Ignored source files or folders are:" + sep + this.ignores.stream().map(Object::toString).collect(Collectors.joining(sep)), pom));
        }
        if (!this.libs.isEmpty()) {
            this.messages.add(Messages.info("Library module (and classes) path is:" + sep + this.libs.stream().map(Object::toString).collect(Collectors.joining(sep)), pom));
        } else {
            this.messages.add(Messages.info("Library path is empty", pom));
        }
        if (!this.resources.isEmpty()) {
            this.messages.add(Messages.info("Additional resources files or folders are:" + sep + this.resources.stream().map(Object::toString).collect(Collectors.joining(sep)), pom));
        }
    }

    public String toString() {
        StringWriter w = new StringWriter();
        w.append("Path configuration items:").append("\n").append("projectRoot:").append(this.getProjectRoot().toString()).append("\n").append("srcs:       ").append(this.getSrcs().toString()).append("\n").append("ignores:    ").append(this.getIgnores().toString()).append("\n").append("libs:       ").append(this.getLibs().toString()).append("\n").append("bin:        ").append(this.getBin().toString()).append("\n").append("resources:  ").append(this.getResources().toString()).append("\n").append("messages:   ").append(this.getMessages().toString()).append("\n");
        return w.toString();
    }

    static {
        store.extendStore(Messages.ts);
        PathConfigFields.forEach((n, t2) -> store.declareKeywordParameter(pathConfigConstructor, (String)n, (Type)t2));
        defaultProjectRoot = URIUtil.unknownLocation();
        defaultIgnores = Collections.emptyList();
        defaultResources = Collections.emptyList();
        defaultMessages = Collections.emptyList();
        defaultBin = URIUtil.unknownLocation();
        defaultLibs = Collections.emptyList();
    }

    public static enum RascalConfigMode {
        INTERPRETER,
        COMPILER;

    }
}

