/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Optional;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.ITestResultListener;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.staticErrors.StaticError;
import org.rascalmpl.parser.gtd.exception.ParseError;

public class RunTests {
    private static final TypeFactory TF = TypeFactory.getInstance();
    private static final TypeStore store = new TypeStore(new TypeStore[0]);
    private static final Type TestResult = TF.abstractDataType(store, "TestResult", new Type[0]);
    private static final Type Exception = TF.abstractDataType(store, "Exception", new Type[0]);
    private static final Type testResult = TF.constructor(store, TestResult, "testResult", TF.stringType(), "name", TF.boolType(), "success", TF.sourceLocationType(), "src");

    public RunTests(IValueFactory vf) {
    }

    public IList runTests(IString moduleName, IEvaluatorContext ctx) {
        return RunTests.runTests(moduleName.getValue(), (Evaluator)ctx.getEvaluator());
    }

    public static IList runTests(String module, Evaluator eval) {
        final IValueFactory vf = eval.getValueFactory();
        ModuleEnvironment root = new ModuleEnvironment("***testroot***", eval.getHeap());
        Environment old = eval.getCurrentEnvt();
        final IListWriter results = vf.listWriter();
        try {
            eval.setCurrentEnvt(root);
            ModuleEnvironment testModuleEnv = eval.getHeap().getModule(module);
            if (testModuleEnv != null) {
                eval.getHeap().removeModule(testModuleEnv);
            }
            eval.doImport(eval.getMonitor(), module);
            eval.setTestResultListener(new ITestResultListener(){

                @Override
                public void start(String context, int count) {
                }

                @Override
                public void report(boolean successful, String test, ISourceLocation loc, String message, Throwable exception) {
                    IConstructor tr = vf.constructor(testResult, vf.string(test), vf.bool(successful), loc);
                    if (!successful) {
                        tr = tr.asWithKeywordParameters().setParameter("message", vf.string(message));
                        if (exception != null) {
                            if (exception instanceof Throw) {
                                tr = tr.asWithKeywordParameters().setParameter("exceptions", vf.list(((Throw)exception).getException()));
                            } else {
                                Type ext = TF.constructor(store, Exception, exception.getClass().getSimpleName(), new Type[0]);
                                IConstructor ex = vf.constructor(ext);
                                if (exception.getMessage() != null && !exception.getMessage().isEmpty()) {
                                    ex = ex.asWithKeywordParameters().setParameter("message", vf.string(exception.getMessage()));
                                }
                                tr = tr.asWithKeywordParameters().setParameter("exceptions", vf.list(ex));
                            }
                        }
                    }
                    results.append(tr);
                }

                @Override
                public void ignored(String test, ISourceLocation loc) {
                }

                @Override
                public void done() {
                }
            });
            eval.runTests(eval.getMonitor(), Optional.empty());
            IList iList = (IList)results.done();
            return iList;
        }
        catch (ParseError e) {
            throw e;
        }
        catch (StaticError e) {
            throw e;
        }
        catch (Throwable e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)vf.string(module), e.getMessage());
        }
        finally {
            eval.setCurrentEnvt(old);
            eval.setTestResultListener(null);
        }
    }
}

