/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.type.Type;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.IdentityHashMap;
import java.util.Map;
import org.rascalmpl.parser.gtd.IGTD;
import org.rascalmpl.parser.gtd.debug.IDebugListener;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.parser.gtd.exception.UndeclaredNonTerminalException;
import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.recovery.IRecoverer;
import org.rascalmpl.parser.gtd.result.AbstractContainerNode;
import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.ExpandableContainerNode;
import org.rascalmpl.parser.gtd.result.RecoveredNode;
import org.rascalmpl.parser.gtd.result.SortContainerNode;
import org.rascalmpl.parser.gtd.result.action.IActionExecutor;
import org.rascalmpl.parser.gtd.result.action.VoidActionExecutor;
import org.rascalmpl.parser.gtd.result.out.FilteringTracker;
import org.rascalmpl.parser.gtd.result.out.INodeConstructorFactory;
import org.rascalmpl.parser.gtd.result.out.INodeFlattener;
import org.rascalmpl.parser.gtd.result.struct.Link;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.EpsilonStackNode;
import org.rascalmpl.parser.gtd.stack.NonTerminalStackNode;
import org.rascalmpl.parser.gtd.stack.SkippingStackNode;
import org.rascalmpl.parser.gtd.stack.edge.EdgesSet;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;
import org.rascalmpl.parser.gtd.util.ArrayList;
import org.rascalmpl.parser.gtd.util.DoubleArrayList;
import org.rascalmpl.parser.gtd.util.DoubleStack;
import org.rascalmpl.parser.gtd.util.HashMap;
import org.rascalmpl.parser.gtd.util.IntegerKeyedDoubleValueHashMap;
import org.rascalmpl.parser.gtd.util.IntegerList;
import org.rascalmpl.parser.gtd.util.IntegerObjectList;
import org.rascalmpl.parser.gtd.util.Stack;
import org.rascalmpl.parser.uptr.debug.NopDebugListener;
import org.rascalmpl.parser.util.ParseStateVisualizer;
import org.rascalmpl.util.visualize.dot.NodeId;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public abstract class SGTDBF<P, T, S>
implements IGTD<P, T, S> {
    private static final int DEFAULT_TODOLIST_CAPACITY = 16;
    private URI inputURI;
    private int[] input;
    private int location = 0;
    protected int lookAheadChar;
    private final PositionStore positionStore;
    private DoubleStack<AbstractStackNode<P>, AbstractNode>[] todoLists;
    private int queueIndex;
    private int recoveryNodesInQueue;
    private int totalNodesInQueue;
    private final Stack<AbstractStackNode<P>> stacksToExpand;
    private final DoubleStack<AbstractStackNode<P>, AbstractContainerNode<P>> stacksWithNonTerminalsToReduce;
    private DoubleStack<AbstractStackNode<P>, AbstractNode> stacksWithTerminalsToReduce;
    private final HashMap<String, EdgesSet<P>> cachedEdgesForExpect;
    private final IntegerKeyedDoubleValueHashMap<AbstractStackNode<P>, DoubleArrayList<AbstractStackNode<P>, AbstractNode>> sharedNextNodes;
    private final HashMap<String, AbstractStackNode<P>[]> expectCache;
    private final IntegerObjectList<AbstractStackNode<P>> sharedLastExpects;
    private boolean invoked;
    private final Stack<AbstractStackNode<P>> unexpandableNodes;
    private final Stack<AbstractStackNode<P>> unmatchableLeafNodes;
    private final DoubleStack<DoubleArrayList<AbstractStackNode<P>, AbstractNode>, AbstractStackNode<P>> unmatchableMidProductionNodes;
    private final DoubleStack<AbstractStackNode<P>, AbstractNode> filteredNodes;
    private boolean parseErrorEncountered;
    private boolean parseErrorRecovered;
    private IRecoverer<P> recoverer;
    private Map<IConstructor, IConstructor> processedTrees = new IdentityHashMap<IConstructor, IConstructor>();
    private IDebugListener<P> debugListener;
    private ParseStateVisualizer visualizer;
    private long timestamp;
    private boolean printTimes = false;
    private final IntegerList firstTimeRegistration = new IntegerList();
    private final IntegerList firstTimeReductions = new IntegerList();

    public SGTDBF() {
        this.positionStore = new PositionStore();
        this.stacksToExpand = new Stack();
        this.stacksWithNonTerminalsToReduce = new DoubleStack();
        this.cachedEdgesForExpect = new HashMap();
        this.sharedNextNodes = new IntegerKeyedDoubleValueHashMap();
        this.expectCache = new HashMap();
        this.sharedLastExpects = new IntegerObjectList();
        this.unexpandableNodes = new Stack();
        this.unmatchableLeafNodes = new Stack();
        this.unmatchableMidProductionNodes = new DoubleStack();
        this.filteredNodes = new DoubleStack();
    }

    protected int getFreeStackNodeId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractStackNode<P>[] getExpects(String nonTerminal) {
        AbstractStackNode<P>[] expects = this.expectCache.get(nonTerminal);
        if (expects == null) {
            try {
                Method method = this.getClass().getMethod(nonTerminal, new Class[0]);
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                expects = (AbstractStackNode[])method.invoke((Object)this, new Object[0]);
            }
            catch (NoSuchMethodException nsmex) {
                throw new UndeclaredNonTerminalException(nonTerminal, this.getClass());
            }
            catch (IllegalAccessException iaex) {
                throw new RuntimeException(iaex);
            }
            catch (InvocationTargetException itex) {
                throw new RuntimeException(itex.getTargetException());
            }
            this.expectCache.putUnsafe(nonTerminal, expects);
        }
        return expects;
    }

    protected AbstractStackNode<P>[] invokeExpects(AbstractStackNode<P> nonTerminal) {
        return this.getExpects(nonTerminal.getName());
    }

    private AbstractStackNode<P> updateNextNode(AbstractStackNode<P> next, AbstractStackNode<P> node, AbstractNode result) {
        IntegerKeyedDoubleValueHashMap.Entry<AbstractStackNode<P>, DoubleArrayList<AbstractStackNode<P>, AbstractNode>> alternativeEntry = this.sharedNextNodes.get(next.getId());
        if (alternativeEntry != null) {
            DoubleArrayList predecessors = (DoubleArrayList)alternativeEntry.value2;
            if (predecessors != null) {
                predecessors.add(node, result);
                return null;
            }
            AbstractStackNode alternative = (AbstractStackNode)alternativeEntry.value1;
            if (alternative.getStartLocation() == this.location) {
                if (alternative.isMatchable()) {
                    if (alternative.isEmptyLeafNode()) {
                        if (node.getStartLocation() != this.location) {
                            this.propagateEdgesAndPrefixes(node, result, alternative, alternative.getResult());
                        } else {
                            this.propagateEdgesAndPrefixesForNullable(node, result, alternative, alternative.getResult(), node.getEdges().size());
                        }
                        return alternative;
                    }
                } else {
                    EdgesSet alternativeEdgesSet = alternative.getIncomingEdges();
                    int resultStoreId = this.getResultStoreId(alternative.getId());
                    if (alternativeEdgesSet != null && alternativeEdgesSet.getLastVisitedLevel(resultStoreId) == this.location) {
                        if (node.getStartLocation() != this.location) {
                            this.propagateEdgesAndPrefixes(node, result, alternative, alternativeEdgesSet.getLastResult(resultStoreId));
                        } else {
                            this.propagateEdgesAndPrefixesForNullable(node, result, alternative, alternativeEdgesSet.getLastResult(resultStoreId), node.getEdges().size());
                        }
                        return alternative;
                    }
                }
            }
            alternative.updateNode(node, result);
            this.debugListener.progressed(node, result, alternative);
            return alternative;
        }
        if (next.isMatchable()) {
            if (this.location + next.getLength() > this.input.length) {
                return null;
            }
            AbstractNode nextResult = next.match(this.input, this.location);
            if (nextResult == null) {
                DoubleArrayList<AbstractStackNode<P>, AbstractNode> predecessors = new DoubleArrayList<AbstractStackNode<P>, AbstractNode>();
                predecessors.add(node, result);
                this.unmatchableMidProductionNodes.push(predecessors, next);
                this.sharedNextNodes.putUnsafe(next.getId(), next, predecessors);
                this.debugListener.failedToMatch(next);
                return null;
            }
            this.debugListener.matched(next, nextResult);
            next = next.getCleanCopyWithResult(this.location, nextResult);
        } else {
            next = next.getCleanCopy(this.location);
        }
        if (!node.isMatchable() || result.isEmpty()) {
            next.updateNode(node, result);
        } else {
            next.updateNodeAfterNonEmptyMatchable(node, result);
        }
        this.debugListener.progressed(node, result, next);
        this.sharedNextNodes.putUnsafe(next.getId(), next, null);
        this.stacksToExpand.push(next);
        return next;
    }

    private boolean updateAlternativeNextNode(AbstractStackNode<P> next, AbstractStackNode<P> node, AbstractNode result, IntegerObjectList<EdgesSet<P>> edgesMap, ArrayList<Link>[] prefixesMap) {
        int id = next.getId();
        IntegerKeyedDoubleValueHashMap.Entry<AbstractStackNode<P>, DoubleArrayList<AbstractStackNode<P>, AbstractNode>> alternativeEntry = this.sharedNextNodes.get(id);
        if (alternativeEntry != null) {
            DoubleArrayList predecessors = (DoubleArrayList)alternativeEntry.value2;
            if (predecessors != null) {
                predecessors.add(node, result);
                return false;
            }
            AbstractStackNode alternative = (AbstractStackNode)alternativeEntry.value1;
            if (result.isEmpty()) {
                if (alternative.isMatchable()) {
                    if (alternative.isEmptyLeafNode()) {
                        this.propagateAlternativeEdgesAndPrefixes(node, result, alternative, alternative.getResult(), node.getEdges().size(), edgesMap, prefixesMap);
                        return true;
                    }
                } else {
                    EdgesSet alternativeEdgesSet = alternative.getIncomingEdges();
                    int resultStoreId = this.getResultStoreId(alternative.getId());
                    if (alternativeEdgesSet != null && alternativeEdgesSet.getLastVisitedLevel(resultStoreId) == this.location) {
                        AbstractContainerNode nextResult = alternativeEdgesSet.getLastResult(resultStoreId);
                        this.propagateAlternativeEdgesAndPrefixes(node, result, alternative, nextResult, node.getEdges().size(), edgesMap, prefixesMap);
                        return true;
                    }
                }
            }
            alternative.updatePrefixSharedNode(edgesMap, prefixesMap);
            this.debugListener.progressed(node, result, alternative);
            return true;
        }
        if (next.isMatchable()) {
            if (this.location + next.getLength() > this.input.length) {
                return false;
            }
            AbstractNode nextResult = next.match(this.input, this.location);
            if (nextResult == null) {
                DoubleArrayList<AbstractStackNode<P>, AbstractNode> predecessors = new DoubleArrayList<AbstractStackNode<P>, AbstractNode>();
                predecessors.add(node, result);
                this.unmatchableMidProductionNodes.push(predecessors, next);
                this.sharedNextNodes.putUnsafe(id, next, predecessors);
                this.debugListener.failedToMatch(next);
                return false;
            }
            this.debugListener.matched(next, nextResult);
            next = next.getCleanCopyWithResult(this.location, nextResult);
        } else {
            next = next.getCleanCopy(this.location);
        }
        next.updatePrefixSharedNode(edgesMap, prefixesMap);
        this.debugListener.progressed(node, result, next);
        this.sharedNextNodes.putUnsafe(id, next, null);
        this.stacksToExpand.push(next);
        return true;
    }

    private void propagateReductions(AbstractStackNode<P> node, AbstractNode nodeResultStore, AbstractStackNode<P> next, AbstractNode nextResultStore, int potentialNewEdges) {
        IntegerList propagatedReductions = next.getPropagatedReductions();
        IntegerObjectList<EdgesSet<P>> edgesMap = node.getEdges();
        ArrayList<Link>[] prefixes = node.getPrefixesMap();
        P production = next.getParentProduction();
        String name = edgesMap.getValue(0).get(0).getName();
        boolean hasNestingRestrictions = this.hasNestingRestrictions(name);
        IntegerList filteredParents = null;
        if (hasNestingRestrictions) {
            filteredParents = this.getFilteredParents(next.getId());
        }
        int fromIndex = edgesMap.size() - potentialNewEdges;
        for (int i = edgesMap.size() - 1; i >= fromIndex; --i) {
            int startLocation = edgesMap.getKey(i);
            propagatedReductions.add(startLocation);
            ArrayList<Link> edgePrefixes = new ArrayList<Link>();
            Link prefix = prefixes != null ? new Link(prefixes[i], nodeResultStore) : new Link(null, nodeResultStore);
            edgePrefixes.add(prefix);
            Link resultLink = new Link(edgePrefixes, nextResultStore);
            EdgesSet<P> edgeSet = edgesMap.getValue(i);
            this.debugListener.reducing(node, resultLink, edgeSet);
            if (!hasNestingRestrictions) {
                this.handleEdgeList(edgeSet, name, production, resultLink, startLocation);
                continue;
            }
            this.handleEdgeListWithRestrictions(edgeSet, name, production, resultLink, startLocation, filteredParents);
        }
    }

    private void propagatePrefixes(AbstractStackNode<P> next, AbstractNode nextResult, int nrOfAddedEdges) {
        AbstractStackNode<P>[][] alternateProds;
        int nextDot = next.getDot() + 1;
        AbstractStackNode<P>[] prod = next.getProduction();
        AbstractStackNode<P> nextNext = prod[nextDot];
        IntegerKeyedDoubleValueHashMap.Entry<AbstractStackNode<P>, DoubleArrayList<AbstractStackNode<P>, AbstractNode>> nextNextAlternativeEntry = this.sharedNextNodes.get(nextNext.getId());
        AbstractStackNode nextNextAlternative = null;
        if (nextNextAlternativeEntry != null) {
            DoubleArrayList predecessors = (DoubleArrayList)nextNextAlternativeEntry.value2;
            if (predecessors == null) {
                nextNextAlternative = (AbstractStackNode)nextNextAlternativeEntry.value1;
                if (nextNextAlternative.isMatchable()) {
                    if (nextNextAlternative.isEmptyLeafNode()) {
                        this.propagateEdgesAndPrefixesForNullable(next, nextResult, nextNextAlternative, nextNextAlternative.getResult(), nrOfAddedEdges);
                    } else {
                        nextNextAlternative.updateNode(next, nextResult);
                        this.debugListener.propagated(next, nextResult, nextNextAlternative);
                    }
                } else {
                    EdgesSet nextNextAlternativeEdgesSet = nextNextAlternative.getIncomingEdges();
                    int resultStoreId = this.getResultStoreId(nextNextAlternative.getId());
                    if (nextNextAlternativeEdgesSet != null && nextNextAlternativeEdgesSet.getLastVisitedLevel(resultStoreId) == this.location) {
                        this.propagateEdgesAndPrefixesForNullable(next, nextResult, nextNextAlternative, nextNextAlternativeEdgesSet.getLastResult(resultStoreId), nrOfAddedEdges);
                    } else {
                        nextNextAlternative.updateNode(next, nextResult);
                        this.debugListener.propagated(next, nextResult, nextNextAlternative);
                    }
                }
            } else {
                predecessors.add(next, nextResult);
            }
        }
        if ((alternateProds = next.getAlternateProductions()) != null) {
            if (nextNextAlternative == null) {
                if (!nextNext.isMatchable()) {
                    return;
                }
                nextNextAlternative = nextNext.getCleanCopy(this.location);
                nextNextAlternative.updateNode(next, nextResult);
                this.debugListener.propagated(next, nextResult, nextNextAlternative);
            }
            IntegerObjectList nextNextEdgesMap = nextNextAlternative.getEdges();
            ArrayList<Link>[] nextNextPrefixesMap = nextNextAlternative.getPrefixesMap();
            for (int i = alternateProds.length - 1; i >= 0; --i) {
                prod = alternateProds[i];
                if (nextDot == prod.length) continue;
                AbstractStackNode<P> alternativeNextNext = prod[nextDot];
                IntegerKeyedDoubleValueHashMap.Entry<AbstractStackNode<P>, DoubleArrayList<AbstractStackNode<P>, AbstractNode>> nextNextAltAlternativeEntry = this.sharedNextNodes.get(alternativeNextNext.getId());
                AbstractStackNode nextNextAltAlternative = null;
                if (nextNextAltAlternativeEntry == null) continue;
                DoubleArrayList predecessors = (DoubleArrayList)nextNextAltAlternativeEntry.value2;
                if (predecessors == null) {
                    nextNextAltAlternative = (AbstractStackNode)nextNextAltAlternativeEntry.value1;
                    if (nextNextAltAlternative.isMatchable()) {
                        if (nextNextAltAlternative.isEmptyLeafNode()) {
                            this.propagateAlternativeEdgesAndPrefixes(next, nextResult, nextNextAltAlternative, nextNextAltAlternative.getResult(), nrOfAddedEdges, nextNextEdgesMap, nextNextPrefixesMap);
                            continue;
                        }
                        nextNextAltAlternative.updatePrefixSharedNode(nextNextEdgesMap, nextNextPrefixesMap);
                        this.debugListener.propagated(next, nextResult, nextNextAltAlternative);
                        continue;
                    }
                    EdgesSet nextAlternativeEdgesSet = nextNextAltAlternative.getIncomingEdges();
                    int resultStoreId = this.getResultStoreId(nextNextAltAlternative.getId());
                    if (nextAlternativeEdgesSet != null && nextAlternativeEdgesSet.getLastVisitedLevel(resultStoreId) == this.location) {
                        this.propagateAlternativeEdgesAndPrefixes(next, nextResult, nextNextAltAlternative, nextAlternativeEdgesSet.getLastResult(resultStoreId), nrOfAddedEdges, nextNextEdgesMap, nextNextPrefixesMap);
                        continue;
                    }
                    nextNextAltAlternative.updatePrefixSharedNode(nextNextEdgesMap, nextNextPrefixesMap);
                    this.debugListener.propagated(next, nextResult, nextNextAltAlternative);
                    continue;
                }
                predecessors.add(next, nextResult);
            }
        }
    }

    private void propagateEdgesAndPrefixes(AbstractStackNode<P> node, AbstractNode nodeResult, AbstractStackNode<P> next, AbstractNode nextResult) {
        int nrOfAddedEdges = next.updateOvertakenNode(node, nodeResult);
        this.debugListener.propagated(node, nodeResult, next);
        if (nrOfAddedEdges == 0) {
            return;
        }
        if (next.isEndNode()) {
            this.propagateReductions(node, nodeResult, next, nextResult, nrOfAddedEdges);
        }
        if (next.hasNext()) {
            this.propagatePrefixes(next, nextResult, nrOfAddedEdges);
        }
    }

    private void propagateEdgesAndPrefixesForNullable(AbstractStackNode<P> node, AbstractNode nodeResult, AbstractStackNode<P> next, AbstractNode nextResult, int potentialNewEdges) {
        int nrOfAddedEdges = next.updateOvertakenNullableNode(node, nodeResult, potentialNewEdges);
        this.debugListener.propagated(node, nodeResult, next);
        if (nrOfAddedEdges == 0) {
            return;
        }
        if (next.isEndNode()) {
            this.propagateReductions(node, nodeResult, next, nextResult, nrOfAddedEdges);
        }
        if (next.hasNext()) {
            this.propagatePrefixes(next, nextResult, nrOfAddedEdges);
        }
    }

    private void propagateAlternativeEdgesAndPrefixes(AbstractStackNode<P> node, AbstractNode nodeResult, AbstractStackNode<P> next, AbstractNode nextResult, int potentialNewEdges, IntegerObjectList<EdgesSet<P>> edgesMap, ArrayList<Link>[] prefixesMap) {
        next.updatePrefixSharedNode(edgesMap, prefixesMap);
        this.debugListener.propagated(node, nodeResult, next);
        if (potentialNewEdges == 0) {
            return;
        }
        if (next.isEndNode()) {
            this.propagateReductions(node, nodeResult, next, nextResult, potentialNewEdges);
        }
        if (next.hasNext()) {
            this.propagatePrefixes(next, nextResult, potentialNewEdges);
        }
    }

    private void updateEdges(AbstractStackNode<P> node, AbstractNode result) {
        IntegerObjectList<EdgesSet<P>> edgesMap = node.getEdges();
        ArrayList<Link>[] prefixesMap = node.getPrefixesMap();
        P production = node.getParentProduction();
        String name = edgesMap.getValue(0).get(0).getName();
        boolean hasNestingRestrictions = this.hasNestingRestrictions(name);
        IntegerList filteredParents = null;
        if (hasNestingRestrictions) {
            filteredParents = this.getFilteredParents(node.getId());
        }
        for (int i = edgesMap.size() - 1; i >= 0; --i) {
            Link resultLink = new Link(prefixesMap != null ? prefixesMap[i] : null, result);
            EdgesSet<P> edgeSet = edgesMap.getValue(i);
            this.debugListener.reducing(node, resultLink, edgeSet);
            if (!hasNestingRestrictions) {
                this.handleEdgeList(edgeSet, name, production, resultLink, edgesMap.getKey(i));
                continue;
            }
            this.handleEdgeListWithRestrictions(edgeSet, name, production, resultLink, edgesMap.getKey(i), filteredParents);
        }
    }

    private void updateNullableEdges(AbstractStackNode<P> node, AbstractNode result) {
        IntegerList propagatedReductions = node.getPropagatedReductions();
        int initialSize = propagatedReductions.size();
        IntegerObjectList<EdgesSet<P>> edgesMap = node.getEdges();
        ArrayList<Link>[] prefixesMap = node.getPrefixesMap();
        P production = node.getParentProduction();
        String name = edgesMap.getValue(0).get(0).getName();
        boolean hasNestingRestrictions = this.hasNestingRestrictions(name);
        IntegerList filteredParents = null;
        if (hasNestingRestrictions) {
            filteredParents = this.getFilteredParents(node.getId());
        }
        for (int i = edgesMap.size() - 1; i >= 0; --i) {
            int startLocation = edgesMap.getKey(i);
            if (propagatedReductions.containsBefore(startLocation, initialSize)) continue;
            propagatedReductions.add(startLocation);
            Link resultLink = new Link(prefixesMap != null ? prefixesMap[i] : null, result);
            EdgesSet<P> edgeSet = edgesMap.getValue(i);
            this.debugListener.reducing(node, resultLink, edgeSet);
            if (!hasNestingRestrictions) {
                this.handleEdgeList(edgeSet, name, production, resultLink, startLocation);
                continue;
            }
            this.handleEdgeListWithRestrictions(edgeSet, name, production, resultLink, startLocation, filteredParents);
        }
    }

    private void handleEdgeList(EdgesSet<P> edgeSet, String name, P production, Link resultLink, int startLocation) {
        AbstractContainerNode resultStore = null;
        int resultStoreId = -1;
        if (edgeSet.getLastVisitedLevel(resultStoreId) != this.location) {
            AbstractStackNode<P> edge = edgeSet.get(0);
            resultStore = edge.isRecovered() ? new RecoveredNode(this.inputURI, startLocation, this.location) : (edge.isExpandable() ? new ExpandableContainerNode(this.inputURI, startLocation, this.location, startLocation == this.location, edge.isSeparator(), edge.isLayout()) : new SortContainerNode(this.inputURI, startLocation, this.location, startLocation == this.location, edge.isSeparator(), edge.isLayout()));
            this.stacksWithNonTerminalsToReduce.push(edge, resultStore);
            this.debugListener.reduced(edge);
            for (int j = edgeSet.size() - 1; j >= 1; --j) {
                edge = edgeSet.get(j);
                this.stacksWithNonTerminalsToReduce.push(edge, resultStore);
                this.debugListener.reduced(edge);
            }
            edgeSet.setLastVisitedLevel(this.location, resultStoreId);
            edgeSet.setLastResult(resultStore, resultStoreId);
        } else {
            resultStore = edgeSet.getLastResult(resultStoreId);
        }
        resultStore.addAlternative(production, resultLink);
    }

    private void handleEdgeListWithRestrictions(EdgesSet<P> edgeSet, String name, P production, Link resultLink, int startLocation, IntegerList filteredParents) {
        this.firstTimeRegistration.clear();
        this.firstTimeReductions.clear();
        for (int j = edgeSet.size() - 1; j >= 0; --j) {
            AbstractContainerNode resultStore;
            AbstractStackNode<P> edge = edgeSet.get(j);
            int resultStoreId = this.getResultStoreId(edge.getId());
            if (!this.firstTimeReductions.contains(resultStoreId)) {
                if (this.firstTimeRegistration.contains(resultStoreId)) {
                    this.debugListener.filteredByNestingRestriction(edge);
                    continue;
                }
                this.firstTimeRegistration.add(resultStoreId);
                if (filteredParents == null || !filteredParents.contains(edge.getId())) {
                    resultStore = null;
                    if (edgeSet.getLastVisitedLevel(resultStoreId) == this.location) {
                        resultStore = edgeSet.getLastResult(resultStoreId);
                    }
                    if (resultStore == null) {
                        resultStore = edge.isRecovered() ? new RecoveredNode(this.inputURI, startLocation, this.location) : (edge.isExpandable() ? new ExpandableContainerNode(this.inputURI, startLocation, this.location, startLocation == this.location, edge.isSeparator(), edge.isLayout()) : new SortContainerNode(this.inputURI, startLocation, this.location, startLocation == this.location, edge.isSeparator(), edge.isLayout()));
                        edgeSet.setLastVisitedLevel(this.location, resultStoreId);
                        edgeSet.setLastResult(resultStore, resultStoreId);
                        this.stacksWithNonTerminalsToReduce.push(edge, resultStore);
                        this.firstTimeReductions.add(resultStoreId);
                    }
                    resultStore.addAlternative(production, resultLink);
                    this.debugListener.reduced(edge);
                    continue;
                }
                this.debugListener.filteredByNestingRestriction(edge);
                continue;
            }
            resultStore = edgeSet.getLastResult(resultStoreId);
            this.stacksWithNonTerminalsToReduce.push(edge, resultStore);
        }
    }

    private void moveToNext(AbstractStackNode<P> node, AbstractNode result) {
        int nextDot = node.getDot() + 1;
        AbstractStackNode<P>[] prod = node.getProduction();
        AbstractStackNode<P> newNext = prod[nextDot];
        AbstractStackNode<P> next = this.updateNextNode(newNext, node, result);
        AbstractStackNode<P>[][] alternateProds = node.getAlternateProductions();
        if (alternateProds != null) {
            IntegerObjectList<EdgesSet<P>> edgesMap = null;
            ArrayList<Link>[] prefixesMap = null;
            if (next != null) {
                edgesMap = next.getEdges();
                prefixesMap = next.getPrefixesMap();
            }
            for (int i = alternateProds.length - 1; i >= 0; --i) {
                prod = alternateProds[i];
                if (nextDot == prod.length) continue;
                AbstractStackNode<P> newAlternativeNext = prod[nextDot];
                if (edgesMap != null) {
                    this.updateAlternativeNextNode(newAlternativeNext, node, result, edgesMap, prefixesMap);
                    continue;
                }
                AbstractStackNode<P> alternativeNext = this.updateNextNode(newAlternativeNext, node, result);
                if (alternativeNext == null) continue;
                edgesMap = alternativeNext.getEdges();
                prefixesMap = alternativeNext.getPrefixesMap();
            }
        }
    }

    private void move(AbstractStackNode<P> node, AbstractNode result) {
        this.debugListener.moving(node, result);
        ICompletionFilter[] completionFilters = node.getCompletionFilters();
        if (completionFilters != null) {
            int startLocation = node.getStartLocation();
            for (int i = completionFilters.length - 1; i >= 0; --i) {
                if (!completionFilters[i].isFiltered(this.input, startLocation, this.location, this.positionStore)) continue;
                this.filteredNodes.push(node, result);
                this.debugListener.filteredByCompletionFilter(node, result);
                return;
            }
        }
        if (node.isEndNode()) {
            if (!result.isEmpty() || node.getId() == -2) {
                this.updateEdges(node, result);
            } else {
                this.updateNullableEdges(node, result);
            }
        }
        if (node.hasNext()) {
            this.moveToNext(node, result);
        }
    }

    private void reduceTerminals() {
        while (!this.stacksWithTerminalsToReduce.isEmpty()) {
            AbstractStackNode<P> node = this.stacksWithTerminalsToReduce.peekFirst();
            --this.totalNodesInQueue;
            if (node instanceof SkippingStackNode) {
                --this.recoveryNodesInQueue;
            }
            this.move(node, this.stacksWithTerminalsToReduce.popSecond());
        }
    }

    private void reduceNonTerminals() {
        while (!this.stacksWithNonTerminalsToReduce.isEmpty()) {
            this.move(this.stacksWithNonTerminalsToReduce.peekFirst(), this.stacksWithNonTerminalsToReduce.popSecond());
        }
    }

    private boolean findFirstStacksToReduce() {
        for (int i = 0; i < this.todoLists.length; ++i) {
            DoubleStack<AbstractStackNode<P>, AbstractNode> terminalsTodo = this.todoLists[i];
            if (terminalsTodo == null || terminalsTodo.isEmpty()) continue;
            this.stacksWithTerminalsToReduce = terminalsTodo;
            this.location += i;
            this.queueIndex = i;
            return true;
        }
        return this.attemptRecovery();
    }

    private boolean findStacksToReduce() {
        int queueDepth = this.todoLists.length;
        for (int i = 1; i < queueDepth; ++i) {
            this.queueIndex = (this.queueIndex + 1) % queueDepth;
            DoubleStack<AbstractStackNode<P>, AbstractNode> terminalsTodo = this.todoLists[this.queueIndex];
            if (terminalsTodo == null || terminalsTodo.isEmpty()) continue;
            this.stacksWithTerminalsToReduce = terminalsTodo;
            this.location += i;
            return true;
        }
        if (this.todoLists.length > 64) {
            this.resetTodoLists();
        }
        return false;
    }

    private void resetTodoLists() {
        this.todoLists = new DoubleStack[16];
        this.queueIndex = 0;
    }

    private boolean attemptRecovery() {
        if (this.recoverer != null) {
            this.debugListener.reviving(this.input, this.location, this.unexpandableNodes, this.unmatchableLeafNodes, this.unmatchableMidProductionNodes, this.filteredNodes);
            DoubleArrayList<AbstractStackNode<P>, AbstractNode> recoveredNodes = this.recoverer.reviveStacks(this.input, this.location, this.unexpandableNodes, this.unmatchableLeafNodes, this.unmatchableMidProductionNodes, this.filteredNodes);
            this.debugListener.revived(recoveredNodes);
            if (recoveredNodes.size() > 0) {
                for (int i = 0; i < recoveredNodes.size(); ++i) {
                    AbstractStackNode<P> recovered = recoveredNodes.getFirst(i);
                    this.debugListener.reviving(this.input, this.location, this.unexpandableNodes, this.unmatchableLeafNodes, this.unmatchableMidProductionNodes, this.filteredNodes);
                    this.queueRecoveryNode(recovered, recovered.getStartLocation(), recovered.getLength(), recoveredNodes.getSecond(i));
                }
                this.parseErrorRecovered = true;
                return this.findStacksToReduce();
            }
            this.parseErrorEncountered = true;
        }
        return false;
    }

    public boolean parseErrorHasOccurred() {
        return this.parseErrorEncountered;
    }

    private void queueMatchableNode(AbstractStackNode<P> node, int length, AbstractNode result) {
        int insertLocation;
        DoubleStack<AbstractStackNode<Object>, AbstractNode> terminalsTodo;
        assert (result != null);
        int queueDepth = this.todoLists.length;
        if (length >= queueDepth) {
            DoubleStack<AbstractStackNode<P>, AbstractNode>[] oldTodoLists = this.todoLists;
            this.todoLists = new DoubleStack[length + 1];
            System.arraycopy(oldTodoLists, this.queueIndex, this.todoLists, 0, queueDepth - this.queueIndex);
            System.arraycopy(oldTodoLists, 0, this.todoLists, queueDepth - this.queueIndex, this.queueIndex);
            queueDepth = length + 1;
            this.queueIndex = 0;
        }
        if ((terminalsTodo = this.todoLists[insertLocation = (this.queueIndex + length) % queueDepth]) == null) {
            terminalsTodo = new DoubleStack();
            this.todoLists[insertLocation] = terminalsTodo;
        }
        terminalsTodo.push(node, result);
        ++this.totalNodesInQueue;
    }

    private void queueRecoveryNode(AbstractStackNode<P> node, int startPosition, int length, AbstractNode result) {
        assert (result != null);
        int queueDepth = this.todoLists.length;
        if (startPosition < this.location) {
            int negativeOffset = this.location - startPosition;
            DoubleStack<AbstractStackNode<P>, AbstractNode>[] oldTodoLists = this.todoLists;
            this.todoLists = new DoubleStack[negativeOffset + Math.max(queueDepth, length) + 1];
            System.arraycopy(oldTodoLists, this.queueIndex, this.todoLists, negativeOffset, queueDepth - this.queueIndex);
            System.arraycopy(oldTodoLists, 0, this.todoLists, queueDepth - this.queueIndex + negativeOffset, this.queueIndex);
            this.queueIndex = 0;
            this.location = startPosition;
            DoubleStack<AbstractStackNode<Object>, AbstractNode> terminalsTodo = this.todoLists[length];
            if (terminalsTodo == null) {
                terminalsTodo = new DoubleStack();
                this.todoLists[length] = terminalsTodo;
            }
            terminalsTodo.push(node, result);
            ++this.totalNodesInQueue;
        } else if (startPosition == this.location) {
            this.queueMatchableNode(node, length, result);
        } else {
            throw new RuntimeException("discovered a future recovery? " + node);
        }
        ++this.recoveryNodesInQueue;
    }

    private boolean handleExpects(AbstractStackNode<P>[] expects, EdgesSet<P> cachedEdges, AbstractStackNode<P> stackBeingWorkedOn) {
        boolean hasValidAlternatives = false;
        this.sharedLastExpects.dirtyClear();
        block0: for (int i = expects.length - 1; i >= 0; --i) {
            AbstractStackNode<P> first = expects[i];
            if (first.isMatchable()) {
                int length = first.getLength();
                int endLocation = this.location + length;
                if (endLocation > this.input.length) continue;
                AbstractNode result = first.match(this.input, this.location);
                if (result == null) {
                    this.unmatchableLeafNodes.push(first);
                    this.debugListener.failedToMatch(first);
                    continue;
                }
                this.debugListener.matched(first, result);
                IEnterFilter[] enterFilters = first.getEnterFilters();
                if (enterFilters != null) {
                    for (int j = enterFilters.length - 1; j >= 0; --j) {
                        if (!enterFilters[j].isFiltered(this.input, this.location, this.positionStore)) continue;
                        this.debugListener.filteredByEnterFilter(first);
                        continue block0;
                    }
                }
                first = first.getCleanCopyWithResult(this.location, result);
                this.queueMatchableNode(first, length, result);
            } else {
                first = first.getCleanCopy(this.location);
                this.stacksToExpand.push(first);
            }
            first.initEdges();
            first.addEdges(cachedEdges, this.location);
            this.sharedLastExpects.add(first.getId(), first);
            hasValidAlternatives = true;
            this.debugListener.expanded(stackBeingWorkedOn, first);
        }
        return hasValidAlternatives;
    }

    protected boolean hasNestingRestrictions(String name) {
        return false;
    }

    protected IntegerList getFilteredParents(int childId) {
        return null;
    }

    protected int getResultStoreId(int id) {
        return -1;
    }

    private void expandStack(AbstractStackNode<P> stack) {
        this.debugListener.expanding(stack);
        IEnterFilter[] enterFilters = stack.getEnterFilters();
        if (enterFilters != null) {
            for (int i = enterFilters.length - 1; i >= 0; --i) {
                if (!enterFilters[i].isFiltered(this.input, this.location, this.positionStore)) continue;
                this.unexpandableNodes.push(stack);
                this.debugListener.filteredByEnterFilter(stack);
                return;
            }
        }
        if (stack.isMatchable()) {
            this.queueMatchableNode(stack, stack.getLength(), stack.getResult());
        } else if (!stack.isExpandable()) {
            EdgesSet<P> cachedEdges = this.cachedEdgesForExpect.get(stack.getName());
            if (cachedEdges == null || stack.isSeparator()) {
                AbstractStackNode<P>[] expects;
                cachedEdges = new EdgesSet(1);
                if (!stack.isSeparator()) {
                    this.cachedEdgesForExpect.put(stack.getName(), cachedEdges);
                }
                if ((expects = this.invokeExpects(stack)) == null) {
                    this.unexpandableNodes.push(stack);
                    return;
                }
                if (!this.handleExpects(expects, cachedEdges, stack)) {
                    this.unexpandableNodes.push(stack);
                    return;
                }
            } else {
                int resultStoreId = this.getResultStoreId(stack.getId());
                if (cachedEdges.getLastVisitedLevel(resultStoreId) == this.location) {
                    this.stacksWithNonTerminalsToReduce.push(stack, cachedEdges.getLastResult(resultStoreId));
                    this.debugListener.foundIterationCachedNullableResult(stack);
                }
            }
            cachedEdges.add(stack);
            stack.setIncomingEdges(cachedEdges);
        } else {
            int resultStoreId;
            EdgesSet<P> cachedEdges = this.cachedEdgesForExpect.get(stack.getName());
            if (cachedEdges == null) {
                boolean expanded = false;
                cachedEdges = new EdgesSet();
                this.cachedEdgesForExpect.put(stack.getName(), cachedEdges);
                AbstractStackNode<P>[] listChildren = stack.getChildren();
                block1: for (int i = listChildren.length - 1; i >= 0; --i) {
                    AbstractStackNode<P> child = listChildren[i];
                    int childId = child.getId();
                    IntegerKeyedDoubleValueHashMap.Entry<AbstractStackNode<P>, DoubleArrayList<AbstractStackNode<P>, AbstractNode>> sharedChildEntry = this.sharedNextNodes.get(childId);
                    if (sharedChildEntry != null && sharedChildEntry.value2 == null) {
                        AbstractStackNode sharedChild = (AbstractStackNode)sharedChildEntry.value1;
                        sharedChild.setEdgesSetWithPrefix(cachedEdges, null, this.location);
                    } else {
                        if (child.isMatchable()) {
                            int length = child.getLength();
                            int endLocation = this.location + length;
                            if (endLocation > this.input.length) continue;
                            AbstractNode result = child.match(this.input, this.location);
                            if (result == null) {
                                this.unmatchableLeafNodes.push(child);
                                this.debugListener.failedToMatch(child);
                                continue;
                            }
                            this.debugListener.matched(child, result);
                            IEnterFilter[] childEnterFilters = child.getEnterFilters();
                            if (childEnterFilters != null) {
                                for (int j = childEnterFilters.length - 1; j >= 0; --j) {
                                    if (!childEnterFilters[j].isFiltered(this.input, this.location, this.positionStore)) continue;
                                    this.debugListener.filteredByEnterFilter(child);
                                    continue block1;
                                }
                            }
                            child = child.getCleanCopyWithResult(this.location, result);
                            this.queueMatchableNode(child, length, result);
                        } else {
                            child = child.getCleanCopy(this.location);
                            this.stacksToExpand.push(child);
                        }
                        child.initEdges();
                        child.setEdgesSetWithPrefix(cachedEdges, null, this.location);
                        this.sharedNextNodes.putUnsafe(childId, child, null);
                        this.debugListener.expanded(stack, child);
                    }
                    expanded = true;
                }
                if (stack.canBeEmpty()) {
                    AbstractStackNode<P> empty = stack.getEmptyChild().getCleanCopyWithResult(this.location, EpsilonStackNode.EPSILON_RESULT);
                    empty.initEdges();
                    empty.addEdges(cachedEdges, this.location);
                    this.stacksToExpand.push(empty);
                    this.debugListener.expanded(stack, empty);
                    expanded = true;
                }
                if (!expanded) {
                    this.unexpandableNodes.push(stack);
                }
            }
            if (cachedEdges.getLastVisitedLevel(resultStoreId = this.getResultStoreId(stack.getId())) == this.location) {
                this.stacksWithNonTerminalsToReduce.push(stack, cachedEdges.getLastResult(resultStoreId));
                this.debugListener.foundIterationCachedNullableResult(stack);
            }
            cachedEdges.add(stack);
            stack.setIncomingEdges(cachedEdges);
        }
    }

    private void expand() {
        while (!this.stacksToExpand.isEmpty()) {
            this.expandStack(this.stacksToExpand.pop());
        }
    }

    protected AbstractNode parse(AbstractStackNode<P> startNode, URI inputURI, int[] input) {
        return this.parse(startNode, inputURI, input, (IRecoverer)null, (IDebugListener)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractNode parse(AbstractStackNode<P> startNode, URI inputURI, int[] input, IRecoverer<P> recoverer, IDebugListener<P> debugListener) {
        if (debugListener == null) {
            debugListener = new NopDebugListener();
        }
        this.initTime();
        try {
            if (this.invoked) {
                throw new RuntimeException("Can only invoke 'parse' once.");
            }
            this.invoked = true;
            this.inputURI = inputURI;
            this.input = input;
            this.recoverer = recoverer;
            this.debugListener = debugListener;
            this.visualizer = ParseStateVisualizer.shouldVisualizeUri(inputURI) ? new ParseStateVisualizer("Parser") : null;
            this.positionStore.index(input);
            this.todoLists = new DoubleStack[16];
            AbstractStackNode<P> rootNode = startNode;
            rootNode.initEdges();
            this.stacksToExpand.push(rootNode);
            this.lookAheadChar = input.length > 0 ? input[0] : 0;
            debugListener.shifting(this.location, input, this.positionStore);
            this.expand();
            AbstractContainerNode<P> result = null;
            if (this.findFirstStacksToReduce()) {
                boolean shiftedLevel = this.location != 0;
                while (true) {
                    int n = this.lookAheadChar = this.location < input.length ? input[this.location] : 0;
                    if (shiftedLevel) {
                        this.sharedNextNodes.clear();
                        this.cachedEdgesForExpect.clear();
                        this.unexpandableNodes.dirtyClear();
                        this.unmatchableLeafNodes.dirtyClear();
                        this.unmatchableMidProductionNodes.dirtyClear();
                        this.filteredNodes.dirtyClear();
                        debugListener.shifting(this.location, input, this.positionStore);
                    }
                    do {
                        debugListener.iterating();
                        this.reduceTerminals();
                        this.reduceNonTerminals();
                        this.expand();
                    } while (!this.stacksWithNonTerminalsToReduce.isEmpty() || !this.stacksWithTerminalsToReduce.isEmpty());
                    shiftedLevel = true;
                    if (this.onlyRecoveredStacksLeft() && this.attemptRecovery() || this.findStacksToReduce()) continue;
                    if (this.location == input.length) {
                        EdgesSet<P> startNodeEdgesSet = startNode.getIncomingEdges();
                        int resultStoreId = this.getResultStoreId(startNode.getId());
                        if (startNodeEdgesSet != null && startNodeEdgesSet.getLastVisitedLevel(resultStoreId) == input.length) {
                            result = startNodeEdgesSet.getLastResult(resultStoreId);
                            break;
                        }
                    }
                    if (!this.attemptRecovery()) break;
                }
            }
            this.visualize("Done", ParseStateVisualizer.PARSER_ID);
            if (result != null) {
                AbstractContainerNode<P> shiftedLevel = result;
                return shiftedLevel;
            }
        }
        finally {
            this.checkTime("Parsing");
        }
        try {
            this.parseErrorEncountered = true;
            int errorLocation = this.location == Integer.MAX_VALUE ? 0 : this.location;
            int line = this.positionStore.findLine(errorLocation);
            int column = this.positionStore.getColumn(errorLocation, line);
            if (this.location == input.length) {
                throw new ParseError("Parse error", inputURI, errorLocation, 0, line + 1, line + 1, column, column, this.unexpandableNodes, this.unmatchableLeafNodes, this.unmatchableMidProductionNodes, this.filteredNodes);
            }
            throw new ParseError("Parse error", inputURI, errorLocation, 1, line + 1, line + 1, column, column + 1, this.unexpandableNodes, this.unmatchableLeafNodes, this.unmatchableMidProductionNodes, this.filteredNodes);
        }
        catch (Throwable throwable) {
            this.checkTime("Error handling");
            throw throwable;
        }
    }

    private void initTime() {
        this.timestamp = System.nanoTime();
    }

    private boolean onlyRecoveredStacksLeft() {
        if (this.recoveryNodesInQueue == 0) {
            return false;
        }
        return this.recoveryNodesInQueue == this.totalNodesInQueue;
    }

    private void checkTime(String msg) {
        long newStamp = System.nanoTime();
        long duration = newStamp - this.timestamp;
        this.timestamp = newStamp;
        if (this.printTimes) {
            System.err.println(msg + ": " + duration / 1000000L);
        }
    }

    private static int[] charsToInts(char[] input) {
        int[] result = new int[Character.codePointCount(input, 0, input.length)];
        int j = 0;
        for (int i = 0; i < input.length; ++i) {
            if (Character.isLowSurrogate(input[i])) continue;
            result[j++] = Character.codePointAt(input, i);
        }
        return result;
    }

    private T parse(String nonterminal, URI inputURI, int[] input, int maxAmbDepth, IActionExecutor<T> actionExecutor, INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, IRecoverer<P> recoverer, IDebugListener<P> debugListener) {
        AbstractNode result = this.parse(new NonTerminalStackNode(-1, 0, nonterminal), inputURI, input, recoverer, debugListener);
        return this.buildResult(result, converter, nodeConstructorFactory, actionExecutor, maxAmbDepth);
    }

    @Override
    public T parse(String nonterminal, URI inputURI, char[] input, int maxAmbDepth, IActionExecutor<T> actionExecutor, INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, IRecoverer<P> recoverer, IDebugListener<P> debugListener) {
        return this.parse(nonterminal, inputURI, SGTDBF.charsToInts(input), maxAmbDepth, actionExecutor, converter, nodeConstructorFactory, recoverer, debugListener);
    }

    @Override
    public T parse(String nonterminal, URI inputURI, char[] input, int maxAmbDepth, IActionExecutor<T> actionExecutor, INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, IRecoverer<P> recoverer) {
        return this.parse(nonterminal, inputURI, input, maxAmbDepth, actionExecutor, converter, nodeConstructorFactory, recoverer, (IDebugListener<P>)null);
    }

    @Override
    public T parse(String nonterminal, URI inputURI, char[] input, int maxAmbDepth, IActionExecutor<T> actionExecutor, INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, IDebugListener<P> debugListener) {
        return this.parse(nonterminal, inputURI, input, maxAmbDepth, actionExecutor, converter, nodeConstructorFactory, (IRecoverer<P>)null, debugListener);
    }

    @Override
    public T parse(String nonterminal, URI inputURI, char[] input, int maxAmbDepth, IActionExecutor<T> actionExecutor, INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory) {
        return this.parse(nonterminal, inputURI, input, maxAmbDepth, actionExecutor, converter, nodeConstructorFactory, (IRecoverer<P>)null, (IDebugListener<P>)null);
    }

    private T parse(String nonterminal, URI inputURI, int[] input, int maxAmbDepth, INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, IRecoverer<P> recoverer, IDebugListener<P> debugListener) {
        AbstractNode result = this.parse(new NonTerminalStackNode(-1, 0, nonterminal), inputURI, input, recoverer, debugListener);
        return this.buildResult(result, converter, nodeConstructorFactory, new VoidActionExecutor(), maxAmbDepth);
    }

    @Override
    public T parse(String nonterminal, URI inputURI, char[] input, int maxAmbDepth, INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, IRecoverer<P> recoverer, IDebugListener<P> debugListener) {
        return this.parse(nonterminal, inputURI, SGTDBF.charsToInts(input), maxAmbDepth, converter, nodeConstructorFactory, recoverer, debugListener);
    }

    @Override
    public T parse(String nonterminal, URI inputURI, char[] input, int maxAmbDepth, INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, IRecoverer<P> recoverer) {
        return this.parse(nonterminal, inputURI, input, maxAmbDepth, converter, nodeConstructorFactory, recoverer, (IDebugListener<P>)null);
    }

    @Override
    public T parse(String nonterminal, URI inputURI, char[] input, int maxAmbDepth, INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, IDebugListener<P> debugListener) {
        return this.parse(nonterminal, inputURI, input, maxAmbDepth, converter, nodeConstructorFactory, (IRecoverer<P>)null, debugListener);
    }

    @Override
    public T parse(String nonterminal, URI inputURI, char[] input, int maxAmbDepth, INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory) {
        return this.parse(nonterminal, inputURI, SGTDBF.charsToInts(input), maxAmbDepth, converter, nodeConstructorFactory, null, null);
    }

    protected T parse(AbstractStackNode<P> startNode, URI inputURI, char[] input, INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory) {
        return this.parse(startNode, inputURI, input, Integer.MAX_VALUE, converter, nodeConstructorFactory);
    }

    protected T parse(AbstractStackNode<P> startNode, URI inputURI, char[] input, int maxAmbDepth, INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory) {
        AbstractNode result = this.parse(startNode, inputURI, SGTDBF.charsToInts(input), null, null);
        return this.buildResult(result, converter, nodeConstructorFactory, new VoidActionExecutor(), maxAmbDepth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T buildResult(AbstractNode result, INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, IActionExecutor<T> actionExecutor, int maxAmbDepth) {
        this.initTime();
        try {
            FilteringTracker filteringTracker = new FilteringTracker();
            Object rootEnvironment = actionExecutor != null ? actionExecutor.createRootEnvironment() : null;
            Object parseResult = null;
            try {
                parseResult = converter.convert(nodeConstructorFactory, result, this.positionStore, filteringTracker, actionExecutor, rootEnvironment, maxAmbDepth);
                actionExecutor.completed(rootEnvironment, parseResult == null);
            }
            catch (Throwable throwable) {
                actionExecutor.completed(rootEnvironment, parseResult == null);
                throw throwable;
            }
            if (parseResult != null) {
                if (this.recoverer != null && this.parseErrorRecovered) {
                    parseResult = this.introduceErrorNodes((T)parseResult, nodeConstructorFactory);
                }
                Object var9_10 = parseResult;
                return var9_10;
            }
            int offset = filteringTracker.getOffset();
            int endOffset = filteringTracker.getEndOffset();
            int length = endOffset - offset;
            int beginLine = this.positionStore.findLine(offset);
            int beginColumn = this.positionStore.getColumn(offset, beginLine);
            int endLine = this.positionStore.findLine(endOffset);
            int endColumn = this.positionStore.getColumn(endOffset, endLine);
            throw new ParseError("All results were filtered", this.inputURI, offset, length, beginLine + 1, endLine + 1, beginColumn, endColumn);
        }
        finally {
            this.checkTime("Unbinarizing, post-parse filtering, and mapping to UPTR");
        }
    }

    private T introduceErrorNodes(T tree, INodeConstructorFactory<T, S> nodeConstructorFactory) {
        if (!(tree instanceof IConstructor)) {
            return tree;
        }
        return (T)this.introduceErrorNodes((IConstructor)tree, nodeConstructorFactory);
    }

    private IConstructor introduceErrorNodes(IConstructor tree, INodeConstructorFactory<IConstructor, S> nodeConstructorFactory) {
        IWithKeywordParameters<? extends IConstructor> originalParams;
        IConstructor result = this.processedTrees.get(tree);
        if (result != null) {
            return result;
        }
        Type type = tree.getConstructorType();
        if (type == RascalValueFactory.Tree_Appl) {
            result = this.fixErrorAppl((ITree)tree, nodeConstructorFactory);
        } else if (type == RascalValueFactory.Tree_Char) {
            result = tree;
        } else if (type == RascalValueFactory.Tree_Amb) {
            result = this.fixErrorAmb((ITree)tree, nodeConstructorFactory);
        } else if (type == RascalValueFactory.Tree_Cycle) {
            result = tree;
        } else {
            throw new RuntimeException("Unrecognized tree type: " + type);
        }
        if (result != tree && (originalParams = tree.asWithKeywordParameters()).hasParameter("src")) {
            Object loc = originalParams.getParameter("src");
            result = result.asWithKeywordParameters().setParameter("src", (IValue)loc);
        }
        this.processedTrees.put(tree, result);
        return result;
    }

    private IConstructor fixErrorAppl(ITree tree, INodeConstructorFactory<IConstructor, S> nodeConstructorFactory) {
        IConstructor prod = TreeAdapter.getProduction(tree);
        IList childList = TreeAdapter.getArgs(tree);
        ArrayList<IConstructor> newChildren = null;
        IValue parseErrorPosition = null;
        boolean errorTree = false;
        int childCount = childList.length();
        for (int i = 0; i < childCount; ++i) {
            IConstructor child = (IConstructor)childList.get(i);
            IConstructor newChild = null;
            if (i == childCount - 1 && child.getConstructorType() == RascalValueFactory.Tree_Appl && TreeAdapter.getProduction((ITree)child).getConstructorType() == RascalValueFactory.Production_Skipped) {
                errorTree = true;
                newChild = child;
                IWithKeywordParameters<? extends IConstructor> childWithParams = child.asWithKeywordParameters();
                if (childWithParams.hasParameter("parseError")) {
                    parseErrorPosition = (IValue)childWithParams.getParameter("parseError");
                    newChild = childWithParams.unsetParameter("parseError");
                }
            } else {
                newChild = this.introduceErrorNodes(child, nodeConstructorFactory);
            }
            if ((newChild != child || errorTree) && newChildren == null) {
                newChildren = new ArrayList<IConstructor>(childCount);
                for (int j = 0; j < i; ++j) {
                    newChildren.add((IConstructor)childList.get(j));
                }
            }
            if (newChildren == null) continue;
            newChildren.add(newChild);
        }
        if (errorTree) {
            IConstructor result = nodeConstructorFactory.createErrorNode(newChildren, prod);
            if (parseErrorPosition != null) {
                IWithKeywordParameters<? extends IConstructor> resultWithParams = result.asWithKeywordParameters();
                result = resultWithParams.setParameter("parseError", parseErrorPosition);
            }
            return result;
        }
        if (newChildren != null) {
            return nodeConstructorFactory.createSortNode(newChildren, prod);
        }
        return tree;
    }

    private IConstructor fixErrorAmb(ITree tree, INodeConstructorFactory<IConstructor, S> nodeConstructorFactory) {
        ISet alternativeSet = TreeAdapter.getAlternatives(tree);
        ArrayList<IConstructor> alternatives = new ArrayList<IConstructor>(alternativeSet.size());
        boolean anyChanges = false;
        for (IValue alt : alternativeSet) {
            IConstructor newAlt = this.introduceErrorNodes((IConstructor)alt, nodeConstructorFactory);
            if (newAlt != alt) {
                anyChanges = true;
            }
            alternatives.add(newAlt);
        }
        if (anyChanges) {
            return nodeConstructorFactory.createAmbiguityNode(alternatives);
        }
        return tree;
    }

    private void visualize(String step, NodeId highlight) {
    }

    public int[] getInput() {
        return this.input;
    }

    public int getLocation() {
        return this.location;
    }

    public int getLookAheadChar() {
        return this.lookAheadChar;
    }

    public DoubleStack<AbstractStackNode<P>, AbstractNode>[] getTodoLists() {
        return this.todoLists;
    }

    public int getQueueIndex() {
        return this.queueIndex;
    }

    public Stack<AbstractStackNode<P>> getStacksToExpand() {
        return this.stacksToExpand;
    }

    public DoubleStack<AbstractStackNode<P>, AbstractContainerNode<P>> getStacksWithNonTerminalsToReduce() {
        return this.stacksWithNonTerminalsToReduce;
    }

    public DoubleStack<AbstractStackNode<P>, AbstractNode> getStacksWithTerminalsToReduce() {
        return this.stacksWithTerminalsToReduce;
    }

    public Stack<AbstractStackNode<P>> getUnexpandableNodes() {
        return this.unexpandableNodes;
    }

    public Stack<AbstractStackNode<P>> getUnmatchableLeafNodes() {
        return this.unmatchableLeafNodes;
    }

    public DoubleStack<DoubleArrayList<AbstractStackNode<P>, AbstractNode>, AbstractStackNode<P>> getUnmatchableMidProductionNodes() {
        return this.unmatchableMidProductionNodes;
    }

    public DoubleStack<AbstractStackNode<P>, AbstractNode> getFilteredNodes() {
        return this.filteredNodes;
    }
}

