/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack;

import org.rascalmpl.parser.gtd.stack.AbstractExpandableStackNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.StackNodeVisitor;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;

public class AlternativeStackNode<P>
extends AbstractExpandableStackNode<P> {
    private final P production;
    private final String name;
    private final AbstractStackNode<P>[] children;
    private final AbstractStackNode<P> emptyChild;

    public AlternativeStackNode(int id, int dot, P production, AbstractStackNode<P>[] alternatives) {
        super(id, dot);
        this.production = production;
        this.name = String.valueOf(id);
        this.children = this.generateAlternatives(alternatives);
        this.emptyChild = this.children.length == 0 ? this.generateEmptyChild() : null;
    }

    public AlternativeStackNode(int id, int dot, P production, AbstractStackNode<P>[] alternatives, IEnterFilter[] enterFilters, ICompletionFilter[] completionFilters) {
        super(id, dot, enterFilters, completionFilters);
        this.production = production;
        this.name = String.valueOf(id);
        this.children = this.generateAlternatives(alternatives);
        this.emptyChild = this.children.length == 0 ? this.generateEmptyChild() : null;
    }

    private AlternativeStackNode(AlternativeStackNode<P> original, int startLocation) {
        super(original, startLocation);
        this.production = original.production;
        this.name = original.name;
        this.children = original.children;
        this.emptyChild = original.emptyChild;
    }

    private AbstractStackNode<P>[] generateAlternatives(AbstractStackNode<P>[] alternatives) {
        AbstractStackNode[] children = new AbstractStackNode[alternatives.length];
        for (int i = alternatives.length - 1; i >= 0; --i) {
            AbstractStackNode<P> child = alternatives[i].getCleanCopy(-1);
            AbstractStackNode[] prod = new AbstractStackNode[]{child};
            child.setProduction(prod);
            child.setAlternativeProduction(this.production);
            children[i] = child;
        }
        return children;
    }

    private AbstractStackNode<P> generateEmptyChild() {
        AbstractStackNode<P> empty = EMPTY.getCleanCopy(-1);
        empty.setAlternativeProduction(this.production);
        return empty;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractStackNode<P> getCleanCopy(int startLocation) {
        return new AlternativeStackNode<P>(this, startLocation);
    }

    @Override
    public AbstractStackNode<P>[] getChildren() {
        return this.children;
    }

    @Override
    public boolean canBeEmpty() {
        return this.children.length == 0;
    }

    @Override
    public AbstractStackNode<P> getEmptyChild() {
        if (this.children.length > 0) {
            throw new UnsupportedOperationException();
        }
        return this.emptyChild;
    }

    @Override
    public String toShortString() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("alt");
        sb.append(this.name);
        sb.append('(');
        sb.append(this.startLocation);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return this.production.hashCode();
    }

    @Override
    public boolean equals(Object peer) {
        return super.equals(peer);
    }

    @Override
    public boolean isEqual(AbstractStackNode<P> stackNode) {
        if (!(stackNode instanceof AlternativeStackNode)) {
            return false;
        }
        AlternativeStackNode otherNode = (AlternativeStackNode)stackNode;
        if (!this.production.equals(otherNode.production)) {
            return false;
        }
        return this.hasEqualFilters(stackNode);
    }

    @Override
    public <R> R accept(StackNodeVisitor<P, R> visitor) {
        return visitor.visit(this);
    }
}

