/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack.filter.follow;

import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;

public class MultiCharFollowRestriction
implements ICompletionFilter {
    private final int[][] characters;

    public MultiCharFollowRestriction(int[][] characters) {
        this.characters = characters;
    }

    @Override
    public boolean isFiltered(int[] input, int start, int end, PositionStore positionStore) {
        if (end + this.characters.length - 1 >= input.length) {
            return false;
        }
        block0: for (int i = this.characters.length - 1; i >= 0; --i) {
            int next = input[end + i];
            int[] alternatives = this.characters[i];
            for (int j = alternatives.length - 1; j >= 0; --j) {
                if (next == alternatives[j]) continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(ICompletionFilter otherCompletionFilter) {
        if (!(otherCompletionFilter instanceof MultiCharFollowRestriction)) {
            return false;
        }
        MultiCharFollowRestriction otherMultiCharFollowFilter = (MultiCharFollowRestriction)otherCompletionFilter;
        int[][] otherCharacters = otherMultiCharFollowFilter.characters;
        if (this.characters.length != otherCharacters.length) {
            return false;
        }
        for (int i = this.characters.length - 1; i >= 0; --i) {
            int[] chars = this.characters[i];
            int[] otherChars = otherCharacters[i];
            if (chars.length != otherChars.length) {
                return false;
            }
            block1: for (int j = chars.length - 1; j <= 0; --j) {
                int c = chars[j];
                for (int k = otherChars.length - 1; k <= 0; --k) {
                    if (c == otherChars[k]) continue block1;
                }
                return false;
            }
        }
        return true;
    }
}

