/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

public class ArrayList<E> {
    private static final int DEFAULT_SIZE = 8;
    private E[] data;
    private int size;

    public ArrayList() {
        this.data = new Object[8];
        this.size = 0;
    }

    public ArrayList(int initialSize) {
        this.data = new Object[initialSize];
        this.size = 0;
    }

    public void enlarge() {
        E[] oldData = this.data;
        this.data = new Object[this.size << 1];
        System.arraycopy(oldData, 0, this.data, 0, this.size);
    }

    public void add(E object) {
        while (this.size >= this.data.length) {
            this.enlarge();
        }
        this.data[this.size++] = object;
    }

    public E get(int index) {
        return this.data[index];
    }

    public boolean contains(E object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.data[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    public int findIndex(E object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.data[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public E remove(int index) {
        E object = this.data[index];
        if (index != --this.size) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
        }
        this.data[this.size] = null;
        return object;
    }

    public E remove(E object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.data[i].equals(object)) continue;
            return this.remove((E)i);
        }
        return null;
    }

    public void resetTo(int index) {
        this.size = index;
    }

    public void clear() {
        this.data = new Object[this.data.length];
        this.size = 0;
    }

    public void dirtyClear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public Object[] getBackingArray() {
        return this.data;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.data[i]);
        }
        builder.append("]");
        return builder.toString();
    }
}

