/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class DoubleArrayList<F, S> {
    private static final int DEFAULT_SIZE = 8;
    private F[] first;
    private S[] second;
    private int size;

    public DoubleArrayList() {
        this.first = new Object[8];
        this.second = new Object[8];
        this.size = 0;
    }

    public DoubleArrayList(int initialSize) {
        this.first = new Object[initialSize];
        this.second = new Object[initialSize];
        this.size = 0;
    }

    public void enlarge() {
        F[] oldFirst = this.first;
        this.first = new Object[this.size << 1];
        System.arraycopy(oldFirst, 0, this.first, 0, this.size);
        S[] oldSecond = this.second;
        this.second = new Object[this.size << 1];
        System.arraycopy(oldSecond, 0, this.second, 0, this.size);
    }

    public void add(F firstObject, S secondObject) {
        while (this.size >= this.first.length) {
            this.enlarge();
        }
        this.first[this.size] = firstObject;
        this.second[this.size++] = secondObject;
    }

    public F getFirst(int i) {
        return this.first[i];
    }

    public S getSecond(int i) {
        return this.second[i];
    }

    public boolean containsFirst(F firstObject) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.first[i] != firstObject) continue;
            return true;
        }
        return false;
    }

    public boolean containsSecond(S secondObject) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.first[i] != secondObject) continue;
            return true;
        }
        return false;
    }

    public void remove(int index) {
        if (index != --this.size) {
            System.arraycopy(this.first, index + 1, this.first, index, this.size - index);
            System.arraycopy(this.second, index + 1, this.second, index, this.size - index);
        }
        this.first[this.size] = null;
        this.second[this.size] = null;
    }

    public void resetTo(int index) {
        this.size = index;
    }

    public void clear() {
        this.first = new Object[8];
        this.second = new Object[8];
        this.size = 0;
    }

    public void ditryClear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    private List<Pair<F, S>> zip() {
        ArrayList<Pair<F, S>> entries = new ArrayList<Pair<F, S>>(this.size);
        for (int i = 0; i < this.size; ++i) {
            entries.add(Pair.of(this.first[i], this.second[i]));
        }
        return entries;
    }

    public void sort(Comparator<Pair<F, S>> comparator) {
        List<Pair<F, S>> entries = this.zip();
        entries.sort(comparator);
        for (int i = 0; i < this.size; ++i) {
            Pair<F, S> elem = entries.get(i);
            this.first[i] = elem.getLeft();
            this.second[i] = elem.getRight();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("list[");
        for (int i = 0; i < this.size; ++i) {
            builder.append("\n    ");
            builder.append("<");
            builder.append(this.first[0]);
            builder.append(",");
            builder.append(this.second[1]);
            builder.append(">");
        }
        builder.append("]\n");
        return builder.toString();
    }
}

