/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

import java.util.Iterator;

public class HashMap<K, V> {
    private Entry<K, V>[] entries;
    private int hashMask;
    private int bitSize = 2;
    private int threshold;
    private int load;

    public HashMap() {
        int nrOfEntries = 1 << this.bitSize;
        this.hashMask = nrOfEntries - 1;
        this.entries = null;
        this.threshold = nrOfEntries;
        this.load = 0;
    }

    private void rehash() {
        int nrOfEntries = 1 << ++this.bitSize;
        int newHashMask = nrOfEntries - 1;
        Entry<K, V>[] oldEntries = this.entries;
        Entry[] newEntries = new Entry[nrOfEntries];
        Entry<Object, Object> currentEntryRoot = new Entry<Object, Object>(null, null, 0, null);
        Entry<Object, Object> shiftedEntryRoot = new Entry<Object, Object>(null, null, 0, null);
        int oldSize = oldEntries.length;
        for (int i = oldSize - 1; i >= 0; --i) {
            Entry<K, V> e = oldEntries[i];
            if (e == null) continue;
            Entry<Object, Object> lastCurrentEntry = currentEntryRoot;
            Entry<Object, Object> lastShiftedEntry = shiftedEntryRoot;
            int lastPosition = -1;
            do {
                int position;
                if ((position = e.hash & newHashMask) == i) {
                    if (position != lastPosition) {
                        lastCurrentEntry.next = e;
                    }
                    lastCurrentEntry = e;
                    continue;
                }
                if (position != lastPosition) {
                    lastShiftedEntry.next = e;
                }
                lastShiftedEntry = e;
            } while ((e = e.next) != null);
            lastCurrentEntry.next = null;
            lastShiftedEntry.next = null;
            newEntries[i] = currentEntryRoot.next;
            newEntries[i | oldSize] = shiftedEntryRoot.next;
        }
        this.threshold <<= 1;
        this.entries = newEntries;
        this.hashMask = newHashMask;
    }

    private void ensureCapacity() {
        if (this.entries == null) {
            this.entries = new Entry[1 << this.bitSize];
        } else if (this.load >= this.threshold) {
            this.rehash();
        }
    }

    public V put(K key, V value) {
        this.ensureCapacity();
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<K, V> currentStartEntry = this.entries[position];
        if (currentStartEntry != null) {
            Entry<K, V> entry = currentStartEntry;
            do {
                if (hash != entry.hash || !entry.key.equals(key)) continue;
                Object oldValue = entry.value;
                entry.value = value;
                return oldValue;
            } while ((entry = entry.next) != null);
        }
        this.entries[position] = new Entry<K, V>(key, value, hash, currentStartEntry);
        ++this.load;
        return null;
    }

    public void putUnsafe(K key, V value) {
        this.ensureCapacity();
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        this.entries[position] = new Entry<K, V>(key, value, hash, this.entries[position]);
        ++this.load;
    }

    public V remove(K key) {
        if (this.entries == null) {
            return null;
        }
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<K, V> previous = null;
        Entry<K, V> currentStartEntry = this.entries[position];
        if (currentStartEntry != null) {
            Entry<K, V> entry = currentStartEntry;
            do {
                if (hash == entry.hash && entry.key.equals(key)) {
                    if (previous == null) {
                        this.entries[position] = entry.next;
                    } else {
                        previous.next = entry.next;
                    }
                    --this.load;
                    return entry.value;
                }
                previous = entry;
            } while ((entry = entry.next) != null);
        }
        return null;
    }

    public V get(K key) {
        if (this.entries == null) {
            return null;
        }
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<K, V> entry = this.entries[position];
        while (entry != null) {
            if (hash == entry.hash && key.equals(entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public int size() {
        return this.load;
    }

    public void clear() {
        if (this.entries != null) {
            this.entries = new Entry[this.entries.length];
        }
        this.load = 0;
    }

    public Iterator<Entry<K, V>> entryIterator() {
        return new EntryIterator(this);
    }

    public Iterator<V> valueIterator() {
        return new ValueIterator(this);
    }

    public static class Entry<K, V> {
        public final int hash;
        public final K key;
        public V value;
        public Entry<K, V> next;

        public Entry(K key, V value, int hash, Entry<K, V> next) {
            this.key = key;
            this.value = value;
            this.hash = hash;
            this.next = next;
        }
    }

    private static class ValueIterator<K, V>
    implements Iterator<V> {
        private final Entry<K, V>[] data;
        private Entry<K, V> current;
        private int index;

        public ValueIterator(HashMap<K, V> hashMap) {
            this.data = hashMap.entries;
            this.index = this.data.length - 1;
            if (this.data != null) {
                this.current = new Entry<Object, Object>(null, null, -1, this.data[this.index]);
                this.locateNext();
            } else {
                this.current = null;
            }
        }

        private void locateNext() {
            Entry next = this.current.next;
            if (next != null) {
                this.current = next;
                return;
            }
            for (int i = this.index - 1; i >= 0; --i) {
                Entry<K, V> entry = this.data[i];
                if (entry == null) continue;
                this.current = entry;
                this.index = i;
                return;
            }
            this.current = null;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new UnsupportedOperationException("There are no more elements in this iterator.");
            }
            Entry<K, V> entry = this.current;
            this.locateNext();
            return entry.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }

    private static class EntryIterator<K, V>
    implements Iterator<Entry<K, V>> {
        private final Entry<K, V>[] data;
        private Entry<K, V> current;
        private int index;

        public EntryIterator(HashMap<K, V> hashMap) {
            this.data = hashMap.entries;
            this.index = this.data.length - 1;
            this.current = hashMap.entries != null ? new Entry<Object, Object>(null, null, -1, this.data[this.index]) : null;
            this.locateNext();
        }

        private void locateNext() {
            Entry next = this.current.next;
            if (next != null) {
                this.current = next;
                return;
            }
            for (int i = this.index - 1; i >= 0; --i) {
                Entry<K, V> entry = this.data[i];
                if (entry == null) continue;
                this.current = entry;
                this.index = i;
                return;
            }
            this.current = null;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new UnsupportedOperationException("There are no more elements in this iterator.");
            }
            Entry<K, V> entry = this.current;
            this.locateNext();
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }
}

