/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

public class IndexedStack<E> {
    private static final int DEFAULT_SIZE = 8;
    private E[] data;
    private int[] indexes;
    private int size;

    public IndexedStack() {
        this.data = new Object[8];
        this.indexes = new int[8];
        this.size = 0;
    }

    public IndexedStack(int initialSize) {
        this.data = new Object[initialSize];
        this.indexes = new int[initialSize];
        this.size = 0;
    }

    public void enlarge() {
        E[] oldData = this.data;
        this.data = new Object[this.size << 1];
        System.arraycopy(oldData, 0, this.data, 0, this.size);
        int[] oldIndexes = this.indexes;
        this.indexes = new int[this.size << 1];
        System.arraycopy(oldIndexes, 0, this.indexes, 0, this.size);
    }

    public void push(E object, int index) {
        while (this.size >= this.data.length) {
            this.enlarge();
        }
        this.data[this.size] = object;
        this.indexes[this.size++] = index;
    }

    public E peek() {
        return this.data[this.size - 1];
    }

    public int peekIndex() {
        return this.indexes[this.size - 1];
    }

    public E pop() {
        E object = this.data[--this.size];
        this.data[this.size] = null;
        return object;
    }

    public void purge() {
        this.data[--this.size] = null;
    }

    public E dirtyPop() {
        return this.data[--this.size];
    }

    public void dirtyPurge() {
        --this.size;
    }

    public E get(int index) {
        return this.data[index];
    }

    public int contains(E object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.data[i].equals(object)) continue;
            return this.indexes[i];
        }
        return -1;
    }

    public int findIndex(E object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.data[i].equals(object)) continue;
            return this.indexes[i];
        }
        return -1;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.data = new Object[this.data.length];
        this.size = 0;
    }
}

