/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

import java.util.Iterator;

public class IntegerKeyedDoubleValueHashMap<V1, V2> {
    private static final int DEFAULT_BIT_SIZE = 2;
    private Entry<V1, V2>[] entries;
    private int hashMask;
    private int bitSize = 2;
    private int threshold;
    private int load;

    public IntegerKeyedDoubleValueHashMap() {
        int nrOfEntries = 1 << 2;
        this.hashMask = nrOfEntries - 1;
        this.entries = new Entry[nrOfEntries];
        this.threshold = nrOfEntries;
        this.load = 0;
    }

    private void rehash() {
        int nrOfEntries = 1 << ++this.bitSize;
        int newHashMask = nrOfEntries - 1;
        Entry<V1, V2>[] oldEntries = this.entries;
        Entry[] newEntries = new Entry[nrOfEntries];
        Entry<Object, Object> currentEntryRoot = new Entry<Object, Object>(-1, null, null, null);
        Entry<Object, Object> shiftedEntryRoot = new Entry<Object, Object>(-1, null, null, null);
        int oldSize = oldEntries.length;
        for (int i = oldSize - 1; i >= 0; --i) {
            Entry<V1, V2> e = oldEntries[i];
            if (e == null) continue;
            Entry<Object, Object> lastCurrentEntry = currentEntryRoot;
            Entry<Object, Object> lastShiftedEntry = shiftedEntryRoot;
            int lastPosition = -1;
            do {
                int position;
                if ((position = e.key & newHashMask) == i) {
                    if (position != lastPosition) {
                        lastCurrentEntry.next = e;
                    }
                    lastCurrentEntry = e;
                    continue;
                }
                if (position != lastPosition) {
                    lastShiftedEntry.next = e;
                }
                lastShiftedEntry = e;
            } while ((e = e.next) != null);
            lastCurrentEntry.next = null;
            lastShiftedEntry.next = null;
            newEntries[i] = currentEntryRoot.next;
            newEntries[i | oldSize] = shiftedEntryRoot.next;
        }
        this.threshold <<= 1;
        this.entries = newEntries;
        this.hashMask = newHashMask;
    }

    private void ensureCapacity() {
        if (this.load > this.threshold) {
            this.rehash();
        }
    }

    public boolean put(int key, V1 value1, V2 value2) {
        this.ensureCapacity();
        int position = key & this.hashMask;
        Entry<V1, V2> currentStartEntry = this.entries[position];
        if (currentStartEntry != null) {
            Entry<V1, V2> entry = currentStartEntry;
            do {
                if (entry.key != key) continue;
                entry.value1 = value1;
                entry.value2 = value2;
                return false;
            } while ((entry = entry.next) != null);
        }
        this.entries[position] = new Entry<V1, V2>(key, value1, value2, currentStartEntry);
        ++this.load;
        return true;
    }

    public void putUnsafe(int key, V1 value1, V2 value2) {
        this.ensureCapacity();
        int position = key & this.hashMask;
        this.entries[position] = new Entry<V1, V2>(key, value1, value2, this.entries[position]);
        ++this.load;
    }

    public Entry<V1, V2> get(int key) {
        int position = key & this.hashMask;
        Entry<V1, V2> entry = this.entries[position];
        while (entry != null) {
            if (entry.key == key) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public Entry<V1, V2> remove(int key) {
        int position = key & this.hashMask;
        Entry<V1, V2> previous = null;
        Entry<V1, V2> currentStartEntry = this.entries[position];
        if (currentStartEntry != null) {
            Entry<V1, V2> entry = currentStartEntry;
            do {
                if (entry.key == key) {
                    if (previous == null) {
                        this.entries[position] = entry.next;
                    } else {
                        previous.next = entry.next;
                    }
                    --this.load;
                    return entry;
                }
                previous = entry;
            } while ((entry = entry.next) != null);
        }
        return null;
    }

    public int size() {
        return this.load;
    }

    public void clear() {
        this.bitSize = 2;
        int nrOfEntries = 1 << 2;
        this.hashMask = nrOfEntries - 1;
        this.entries = new Entry[nrOfEntries];
        this.threshold = nrOfEntries;
        this.load = 0;
    }

    public Iterator<Entry<V1, V2>> entryIterator() {
        return new EntryIterator(this);
    }

    public static class Entry<V1, V2> {
        public final int key;
        public V1 value1;
        public V2 value2;
        public Entry<V1, V2> next;

        public Entry(int key, V1 value1, V2 value2, Entry<V1, V2> next) {
            this.key = key;
            this.value1 = value1;
            this.value2 = value2;
            this.next = next;
        }
    }

    private static class EntryIterator<V1, V2>
    implements Iterator<Entry<V1, V2>> {
        private final Entry<V1, V2>[] data;
        private Entry<V1, V2> current;
        private int index;

        public EntryIterator(IntegerKeyedDoubleValueHashMap<V1, V2> integerKeyedDoubleValueHashMap) {
            this.data = integerKeyedDoubleValueHashMap.entries;
            this.index = this.data.length - 1;
            this.current = new Entry<Object, Object>(-1, null, null, this.data[this.index]);
            this.locateNext();
        }

        private void locateNext() {
            Entry next = this.current.next;
            if (next != null) {
                this.current = next;
                return;
            }
            for (int i = this.index - 1; i >= 0; --i) {
                Entry<V1, V2> entry = this.data[i];
                if (entry == null) continue;
                this.current = entry;
                this.index = i;
                return;
            }
            this.current = null;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Entry<V1, V2> next() {
            if (!this.hasNext()) {
                throw new UnsupportedOperationException("There are no more elements in this iterator.");
            }
            Entry<V1, V2> entry = this.current;
            this.locateNext();
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }
}

