/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

import java.util.Iterator;

public class IntegerKeyedHashMap<V> {
    private static final int DEFAULT_BIT_SIZE = 2;
    private Entry<V>[] entries;
    private int hashMask;
    private int bitSize = 2;
    private int threshold;
    private int load;

    public IntegerKeyedHashMap() {
        int nrOfEntries = 1 << 2;
        this.hashMask = nrOfEntries - 1;
        this.entries = new Entry[nrOfEntries];
        this.threshold = nrOfEntries;
        this.load = 0;
    }

    private void rehash() {
        int nrOfEntries = 1 << ++this.bitSize;
        int newHashMask = nrOfEntries - 1;
        Entry<V>[] oldEntries = this.entries;
        Entry[] newEntries = new Entry[nrOfEntries];
        Entry<Object> currentEntryRoot = new Entry<Object>(-1, null, null);
        Entry<Object> shiftedEntryRoot = new Entry<Object>(-1, null, null);
        int oldSize = oldEntries.length;
        for (int i = oldSize - 1; i >= 0; --i) {
            Entry<V> e = oldEntries[i];
            if (e == null) continue;
            Entry<Object> lastCurrentEntry = currentEntryRoot;
            Entry<Object> lastShiftedEntry = shiftedEntryRoot;
            int lastPosition = -1;
            do {
                int position;
                if ((position = e.key & newHashMask) == i) {
                    if (position != lastPosition) {
                        lastCurrentEntry.next = e;
                    }
                    lastCurrentEntry = e;
                    continue;
                }
                if (position != lastPosition) {
                    lastShiftedEntry.next = e;
                }
                lastShiftedEntry = e;
            } while ((e = e.next) != null);
            lastCurrentEntry.next = null;
            lastShiftedEntry.next = null;
            newEntries[i] = currentEntryRoot.next;
            newEntries[i | oldSize] = shiftedEntryRoot.next;
        }
        this.threshold <<= 1;
        this.entries = newEntries;
        this.hashMask = newHashMask;
    }

    private void ensureCapacity() {
        if (this.load > this.threshold) {
            this.rehash();
        }
    }

    public V put(int key, V value) {
        this.ensureCapacity();
        int position = key & this.hashMask;
        Entry<V> currentStartEntry = this.entries[position];
        if (currentStartEntry != null) {
            Entry<V> entry = currentStartEntry;
            do {
                if (entry.key != key) continue;
                Object oldValue = entry.value;
                entry.value = value;
                return oldValue;
            } while ((entry = entry.next) != null);
        }
        this.entries[position] = new Entry<V>(key, value, currentStartEntry);
        ++this.load;
        return null;
    }

    public void putAll(IntegerKeyedHashMap<V> all) {
        for (Entry<V> e : all.entries) {
            if (e == null) continue;
            this.put(e.key, e.value);
        }
    }

    public void putUnsafe(int key, V value) {
        this.ensureCapacity();
        int position = key & this.hashMask;
        this.entries[position] = new Entry<V>(key, value, this.entries[position]);
        ++this.load;
    }

    public V get(int key) {
        int position = key & this.hashMask;
        Entry<V> entry = this.entries[position];
        while (entry != null) {
            if (entry.key == key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public V remove(int key) {
        int position = key & this.hashMask;
        Entry<V> previous = null;
        Entry<V> currentStartEntry = this.entries[position];
        if (currentStartEntry != null) {
            Entry<V> entry = currentStartEntry;
            do {
                if (entry.key == key) {
                    if (previous == null) {
                        this.entries[position] = entry.next;
                    } else {
                        previous.next = entry.next;
                    }
                    --this.load;
                    return entry.value;
                }
                previous = entry;
            } while ((entry = entry.next) != null);
        }
        return null;
    }

    public int size() {
        return this.load;
    }

    public void clear() {
        this.bitSize = 2;
        int nrOfEntries = 1 << 2;
        this.hashMask = nrOfEntries - 1;
        this.entries = new Entry[nrOfEntries];
        this.threshold = nrOfEntries;
        this.load = 0;
    }

    public Iterator<Entry<V>> entryIterator() {
        return new EntryIterator(this);
    }

    public static class Entry<V> {
        public final int key;
        public V value;
        public Entry<V> next;

        public Entry(int key, V value, Entry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }

    private static class EntryIterator<V>
    implements Iterator<Entry<V>> {
        private final Entry<V>[] data;
        private Entry<V> current;
        private int index;

        public EntryIterator(IntegerKeyedHashMap<V> integerKeyedHashMap) {
            this.data = integerKeyedHashMap.entries;
            this.index = this.data.length - 1;
            this.current = new Entry<Object>(-1, null, this.data[this.index]);
            this.locateNext();
        }

        private void locateNext() {
            Entry next = this.current.next;
            if (next != null) {
                this.current = next;
                return;
            }
            for (int i = this.index - 1; i >= 0; --i) {
                Entry<V> entry = this.data[i];
                if (entry == null) continue;
                this.current = entry;
                this.index = i;
                return;
            }
            this.current = null;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Entry<V> next() {
            if (!this.hasNext()) {
                throw new UnsupportedOperationException("There are no more elements in this iterator.");
            }
            Entry<V> entry = this.current;
            this.locateNext();
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }
}

