/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.uptr;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import java.net.URI;
import java.util.IdentityHashMap;
import java.util.Map;
import org.rascalmpl.interpreter.asserts.Ambiguous;
import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.result.out.INodeConstructorFactory;
import org.rascalmpl.parser.gtd.util.ArrayList;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class UPTRNodeFactory
implements INodeConstructorFactory<ITree, ISourceLocation> {
    private static final RascalValueFactory VF = (RascalValueFactory)ValueFactoryFactory.getValueFactory();
    private static final IConstructor SKIPPED = VF.constructor(RascalValueFactory.Production_Skipped, VF.constructor(RascalValueFactory.Symbol_IterStar, VF.constructor(RascalValueFactory.Symbol_CharClass, VF.list(VF.constructor(RascalValueFactory.CharRange_Range, VF.integer(1), VF.integer(0x10FFFF))))));
    private boolean allowAmb;
    private final Map<URI, ISourceLocation> uriLookup = new IdentityHashMap<URI, ISourceLocation>(4);

    public UPTRNodeFactory(boolean allowAmbiguity) {
        this.allowAmb = allowAmbiguity;
    }

    @Override
    public ITree createCharNode(int charNumber) {
        return VF.character(charNumber);
    }

    @Override
    public ITree createLiteralNode(int[] characters, Object production) {
        IListWriter listWriter = VF.listWriter();
        for (int i = characters.length - 1; i >= 0; --i) {
            listWriter.insert(VF.character(characters[i]));
        }
        return VF.appl((IConstructor)production, (IList)listWriter.done());
    }

    private static ITree buildAppl(ArrayList<ITree> children, Object production) {
        return VF.appl((IConstructor)production, (ArrayList)children);
    }

    @Override
    public ITree createSortNode(ArrayList<ITree> children, Object production) {
        return UPTRNodeFactory.buildAppl(children, production);
    }

    @Override
    public ITree createSubListNode(ArrayList<ITree> children, Object production) {
        return UPTRNodeFactory.buildAppl(children, production);
    }

    @Override
    public ITree createListNode(ArrayList<ITree> children, Object production) {
        return UPTRNodeFactory.buildAppl(children, production);
    }

    private static ITree buildAmbiguityNode(ArrayList<ITree> alternatives, boolean allowAmb) {
        ISetWriter ambSublist = VF.setWriter();
        for (int i = alternatives.size() - 1; i >= 0; --i) {
            ambSublist.insert(alternatives.get(i));
        }
        if (allowAmb) {
            return VF.amb((ISet)ambSublist.done());
        }
        ITree result = VF.amb((ISet)ambSublist.done());
        if (result.isAmb()) {
            throw new Ambiguous(result);
        }
        return result;
    }

    @Override
    public ITree createAmbiguityNode(ArrayList<ITree> alternatives) {
        return UPTRNodeFactory.buildAmbiguityNode(alternatives, this.allowAmb);
    }

    @Override
    public ITree createSubListAmbiguityNode(ArrayList<ITree> alternatives) {
        return UPTRNodeFactory.buildAmbiguityNode(alternatives, this.allowAmb);
    }

    @Override
    public ITree createListAmbiguityNode(ArrayList<ITree> alternatives) {
        return UPTRNodeFactory.buildAmbiguityNode(alternatives, this.allowAmb);
    }

    private static ITree buildCycle(int depth, Object production) {
        return VF.cycle(ProductionAdapter.getType((IConstructor)production), depth);
    }

    @Override
    public ITree createCycleNode(int depth, Object production) {
        return UPTRNodeFactory.buildCycle(depth, production);
    }

    @Override
    public ITree createSubListCycleNode(Object production) {
        return UPTRNodeFactory.buildCycle(1, production);
    }

    @Override
    public ISourceLocation createPositionInformation(URI input, int offset, int endOffset, PositionStore positionStore) {
        int beginLine = positionStore.findLine(offset);
        int endLine = positionStore.findLine(endOffset);
        return VF.sourceLocation(this.uriLookup.computeIfAbsent(input, VF::sourceLocation), offset, endOffset - offset, beginLine + 1, endLine + 1, positionStore.getColumn(offset, beginLine), positionStore.getColumn(endOffset, endLine));
    }

    @Override
    public ITree addPositionInformation(ITree node, ISourceLocation location) {
        return (ITree)node.asWithKeywordParameters().setParameter("src", location);
    }

    @Override
    public ITree addParseErrorPosition(ITree node, ISourceLocation location) {
        return (ITree)node.asWithKeywordParameters().setParameter("parseError", location);
    }

    @Override
    public ArrayList<ITree> getChildren(ITree node) {
        IList args = TreeAdapter.getArgs(node);
        ArrayList<ITree> children = new ArrayList<ITree>(args.length());
        for (int i = 0; i < args.length(); ++i) {
            children.add((ITree)args.get(i));
        }
        return children;
    }

    @Override
    public Object getRhs(Object production) {
        return ProductionAdapter.getType((IConstructor)production);
    }

    @Override
    public boolean isAmbiguityNode(ITree node) {
        return TreeAdapter.isAmb(node);
    }

    @Override
    public Object getProductionFromNode(ITree node) {
        return TreeAdapter.getProduction(node);
    }

    @Override
    public ITree createSkippedNode(int[] characters) {
        return this.createLiteralNode(characters, SKIPPED);
    }

    @Override
    public ITree createErrorNode(ArrayList<ITree> children, Object production) {
        IConstructor prod = (IConstructor)production;
        IConstructor errorProd = VF.constructor(RascalValueFactory.Production_Error, prod.get(0), prod, VF.integer(children.size() - 1));
        return UPTRNodeFactory.buildAppl(children, errorProd);
    }
}

