/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.uptr.recovery;

import org.rascalmpl.parser.uptr.recovery.InputMatcher;

public class LiteralMatcher
implements InputMatcher {
    private int[] chars;

    public LiteralMatcher(String literal) {
        this.chars = new int[literal.length()];
        for (int i = 0; i < literal.length(); ++i) {
            this.chars[i] = literal.codePointAt(i);
        }
    }

    public LiteralMatcher(int[] literal) {
        this.chars = literal;
    }

    @Override
    public int match(int[] input, int location) {
        int length = this.chars.length;
        if (input.length < location + length) {
            return -1;
        }
        for (int i = 0; i < length; ++i) {
            if (input[location + i] == this.chars[i]) continue;
            return -1;
        }
        return location + length;
    }

    public String toString() {
        return "LiteralMatcher[" + new String(this.chars, 0, this.chars.length) + "]";
    }
}

