/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.utils.ShutdownHooks;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.repl.IREPLService;
import org.rascalmpl.repl.StopREPLException;
import org.rascalmpl.repl.output.IAnsiCommandOutput;
import org.rascalmpl.repl.output.ICommandOutput;
import org.rascalmpl.repl.output.IErrorCommandOutput;
import org.rascalmpl.repl.output.IOutputPrinter;
import org.rascalmpl.repl.output.IWebContentOutput;

public class BaseREPL {
    private final IREPLService replService;
    private final Terminal term;
    private final LineReader reader;
    private volatile boolean keepRunning = true;
    private final @MonotonicNonNull DefaultHistory history;
    private final String normalPrompt;
    private final boolean ansiColorsSupported;
    private final boolean unicodeSupported;
    private IDEServices ideServices;

    public BaseREPL(IREPLService replService, Terminal term) {
        this.replService = replService;
        this.term = term;
        LineReaderBuilder reader = LineReaderBuilder.builder().appName(replService.name()).terminal(term).parser(replService.inputParser());
        if (replService.storeHistory()) {
            reader.variable("history-file", replService.historyFile());
            this.history = new DefaultHistory();
            reader.history(this.history);
            ShutdownHooks.add(this.history::save);
        } else {
            this.history = null;
        }
        reader.option(LineReader.Option.BRACKETED_PASTE, false);
        reader.option(LineReader.Option.HISTORY_IGNORE_DUPS, replService.historyIgnoreDuplicates());
        reader.option(LineReader.Option.DISABLE_EVENT_EXPANSION, true);
        reader.variable("line-offset", 1);
        if (replService.supportsCompletion()) {
            reader.completer(new AggregateCompleter(replService.completers()));
            reader.completionMatcher(replService.completionMatcher());
        }
        this.ansiColorsSupported = !term.getType().equals("dumb");
        this.unicodeSupported = term.encoding().newEncoder().canEncode("\ud83d\udc93");
        this.normalPrompt = replService.prompt(this.ansiColorsSupported, this.unicodeSupported);
        reader.variable("secondary-prompt-pattern", replService.parseErrorPrompt(this.ansiColorsSupported, this.unicodeSupported));
        this.reader = reader.build();
    }

    public void run() throws IOException {
        try {
            this.ideServices = this.replService.connect(this.term, this.ansiColorsSupported, this.unicodeSupported);
            AtomicBoolean running = this.setupInterruptHandler();
            while (this.keepRunning) {
                try {
                    this.replService.flush();
                    this.term.writer().write("\u001b[?2004l");
                    String line = this.reader.readLine(this.normalPrompt);
                    if (line != null) {
                        running.set(true);
                        this.handleInput(line);
                        continue;
                    }
                    break;
                }
                catch (UserInterruptException u) {
                    this.reader.printAbove(this.replService.interruptedPrompt(this.ansiColorsSupported, this.unicodeSupported));
                    this.term.flush();
                }
                finally {
                    running.set(false);
                }
            }
        }
        catch (InterruptedException running) {
        }
        catch (EndOfFileException | StopREPLException _e) {
            this.replService.errorWriter().println("Quiting REPL");
        }
        catch (Throwable e) {
            PrintWriter err = this.replService.errorWriter();
            if (err.checkError()) {
                err = new PrintWriter(System.err, false);
            }
            err.println("Unexpected (uncaught) exception, closing the REPL: ");
            err.print(e.toString());
            e.printStackTrace(err);
            err.flush();
            throw e;
        }
        finally {
            try {
                this.replService.flush();
            }
            catch (Throwable _e) {}
            try {
                this.replService.disconnect();
            }
            catch (Throwable _e) {}
            this.term.flush();
            if (this.history != null) {
                ShutdownHooks.remove(this.history::save);
                this.history.save();
            }
        }
    }

    public void queueCommand(String command) {
        this.reader.addCommandsInBuffer(Arrays.asList(command.split("[\\n\\r]")));
    }

    private AtomicBoolean setupInterruptHandler() {
        AtomicBoolean running = new AtomicBoolean(false);
        AtomicReference<Object> original = new AtomicReference<Object>(null);
        original.set(this.term.handle(Terminal.Signal.INT, s2 -> {
            if (running.get()) {
                try {
                    this.replService.handleInterrupt();
                }
                catch (InterruptedException e) {
                    return;
                }
            } else {
                Terminal.SignalHandler fallback = (Terminal.SignalHandler)original.get();
                if (fallback != null) {
                    fallback.handle(s2);
                }
            }
        }));
        return running;
    }

    private void handleInput(String line) throws InterruptedException, StopREPLException {
        this.writeResult(this.replService.handleInput(line));
    }

    private void writeResult(ICommandOutput result) {
        PrintWriter target = this.replService.outputWriter();
        if (result instanceof IErrorCommandOutput) {
            target = this.replService.errorWriter();
            result = ((IErrorCommandOutput)result).getError();
        }
        if (result instanceof IWebContentOutput) {
            try {
                IWebContentOutput webContent = (IWebContentOutput)result;
                this.ideServices.browse(webContent.webUri(), webContent.webTitle(), webContent.webviewColumn());
            }
            catch (UnsupportedOperationException webContent) {
                // empty catch block
            }
        }
        IOutputPrinter writer = this.ansiColorsSupported && result instanceof IAnsiCommandOutput ? ((IAnsiCommandOutput)result).asAnsi() : result.asPlain();
        writer.write(target, this.unicodeSupported);
    }
}

