/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.completers;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.rascalmpl.repl.completers.RascalQualifiedNames;

public class RascalIdentifierCompletion
implements Completer {
    private final BiFunction<String, String, Map<String, String>> lookupPartialIdentifiers;

    public RascalIdentifierCompletion(BiFunction<String, String, Map<String, String>> lookupPartialIdentifiers) {
        this.lookupPartialIdentifiers = lookupPartialIdentifiers;
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        boolean canBeIdentifier;
        switch (line.words().get(0)) {
            case ":": 
            case "import": 
            case "extend": {
                canBeIdentifier = false;
                break;
            }
            default: {
                canBeIdentifier = true;
            }
        }
        if (canBeIdentifier) {
            this.completePartialIdentifier(line.word(), candidates);
        }
    }

    public void completePartialIdentifier(String name, List<Candidate> candidates) {
        int qualifiedSplit = (name = RascalQualifiedNames.unescape(name)).lastIndexOf("::");
        String qualifier = qualifiedSplit > -1 ? name.substring(0, qualifiedSplit) : "";
        String partial = qualifiedSplit > -1 ? name.substring(qualifiedSplit + 2) : name;
        for (Map.Entry<String, String> can : this.lookupPartialIdentifiers.apply(qualifier, partial).entrySet()) {
            String id = RascalQualifiedNames.escape(can.getKey());
            candidates.add(new Candidate(id, id, can.getValue(), null, null, null, false));
        }
    }
}

