/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.completers;

import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.values.ValueFactoryFactory;

public class RascalQualifiedNames {
    private static final Pattern splitIdentifiers = Pattern.compile("::");
    private static final Set<String> RASCAL_KEYWORDS = new HashSet<String>();

    public static String escape(String name) {
        return splitIdentifiers.splitAsStream(name + " ").map(RascalQualifiedNames::escapeKeyword).collect(Collectors.joining("::")).trim();
    }

    public static String unescape(String term) {
        if (!term.contains("\\")) {
            return term;
        }
        return splitIdentifiers.splitAsStream(term + " ").map(RascalQualifiedNames::unescapeKeyword).collect(Collectors.joining("::")).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assureKeywordsAreScrapped() {
        if (RASCAL_KEYWORDS.isEmpty()) {
            Set<String> set = RASCAL_KEYWORDS;
            synchronized (set) {
                if (!RASCAL_KEYWORDS.isEmpty()) {
                    return;
                }
                String rascalGrammar = "";
                URIResolverRegistry reg = URIResolverRegistry.getInstance();
                try (Reader grammarReader = reg.getCharacterReader(ValueFactoryFactory.getValueFactory().sourceLocation("std", "", "/lang/rascal/syntax/Rascal.rsc"));){
                    int read;
                    StringBuilder res = new StringBuilder();
                    char[] chunk = new char[8192];
                    while ((read = grammarReader.read(chunk, 0, chunk.length)) != -1) {
                        res.append(chunk, 0, read);
                    }
                    rascalGrammar = res.toString();
                }
                catch (IOException | URISyntaxException e) {
                    e.printStackTrace();
                }
                if (!rascalGrammar.isEmpty()) {
                    Pattern findBasicTypeSection;
                    Pattern findKeywordSection = Pattern.compile("^\\s*keyword([^=]|\\s)*=(?<keywords>([^;]|\\s)*);", 8);
                    Matcher m4 = findKeywordSection.matcher(rascalGrammar);
                    if (m4.find()) {
                        String keywords = "|" + m4.group("keywords");
                        Pattern keywordEntry = Pattern.compile("\\s*[|]\\s*[\"](?<keyword>[^\"]*)[\"]");
                        m4 = keywordEntry.matcher(keywords);
                        while (m4.find()) {
                            RASCAL_KEYWORDS.add(m4.group("keyword"));
                        }
                    }
                    if ((m4 = (findBasicTypeSection = Pattern.compile("^\\s*syntax\\s*BasicType([^=]|\\s)*=(?<keywords>([^;]|\\s)*);", 8)).matcher(rascalGrammar)).find()) {
                        String keywords = "|" + m4.group("keywords");
                        Pattern keywordEntry = Pattern.compile("\\s*[|][^:]*:\\s*[\"](?<keyword>[^\"]*)[\"]");
                        m4 = keywordEntry.matcher(keywords);
                        while (m4.find()) {
                            RASCAL_KEYWORDS.add(m4.group("keyword"));
                        }
                    }
                }
                if (RASCAL_KEYWORDS.isEmpty()) {
                    RASCAL_KEYWORDS.add("syntax");
                }
            }
        }
    }

    private static String escapeKeyword(String s2) {
        RascalQualifiedNames.assureKeywordsAreScrapped();
        if (RASCAL_KEYWORDS.contains(s2.trim())) {
            return "\\" + s2;
        }
        return s2;
    }

    private static String unescapeKeyword(String s2) {
        if (s2.startsWith("\\") && !s2.contains("-")) {
            return s2.substring(1);
        }
        return s2;
    }
}

