/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.rascal;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.io.StandardTextWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.jline.jansi.Ansi;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;
import org.rascalmpl.interpreter.utils.ReadEvalPrintDialogMessages;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.repl.output.IAnsiCommandOutput;
import org.rascalmpl.repl.output.ICommandOutput;
import org.rascalmpl.repl.output.IErrorCommandOutput;
import org.rascalmpl.repl.output.IOutputPrinter;
import org.rascalmpl.repl.output.impl.AsciiStringOutputPrinter;
import org.rascalmpl.repl.output.impl.PrinterErrorCommandOutput;

public class ParseErrorPrinter {
    public static IErrorCommandOutput parseErrorMaybePrompt(ParseError pe, ISourceLocation promptRoot, String input, Terminal term, int promptOffset) {
        if (pe.getLocation().top().equals(promptRoot) && ParseErrorPrinter.ansiSupported(term)) {
            return ParseErrorPrinter.buildPromptError(pe, input, term.writer(), promptOffset);
        }
        return new PrinterErrorCommandOutput(ParseErrorPrinter.defaultPrinter(pe, promptRoot, input));
    }

    private static boolean ansiSupported(Terminal term) {
        return term.getStringCapability(InfoCmp.Capability.cursor_down) != null && term.getStringCapability(InfoCmp.Capability.save_cursor) != null && term.getStringCapability(InfoCmp.Capability.restore_cursor) != null;
    }

    private static IOutputPrinter defaultPrinter(final ParseError pe, final ISourceLocation promptRoot, final String input) {
        return new IOutputPrinter(){

            @Override
            public void write(PrintWriter target, boolean unicodeSupported) {
                ReadEvalPrintDialogMessages.parseErrorMessage(target, input, promptRoot.getScheme(), pe, new StandardTextWriter(true));
            }

            @Override
            public String mimeType() {
                return "text/plain";
            }
        };
    }

    private static void writeUnderLine(PrintWriter out, int column, String line) {
        ParseErrorPrinter.writeUnderLine(out, column, line, 0, line.length());
    }

    private static void writeUnderLine(PrintWriter out, int column, String line, int offset, int length) {
        Ansi ansi = Ansi.ansi();
        if (column >= 0) {
            ansi = ansi.cursorToColumn(column);
        }
        if (offset >= ((String)line).length()) {
            line = (String)line + " ";
            length = 1;
        }
        out.write(ansi.reset().fgRed().bold().a(Ansi.Attribute.UNDERLINE).a((CharSequence)line, offset, offset + length).reset().toString());
    }

    private static IErrorCommandOutput buildPromptError(final ParseError pe, String input, PrintWriter stdOut, int promptOffset) {
        ParseErrorPrinter.highlightErrorInInput(pe, input, stdOut, promptOffset);
        return new IErrorCommandOutput(){

            @Override
            public ICommandOutput getError() {
                return new IAnsiCommandOutput(){

                    @Override
                    public IOutputPrinter asAnsi() {
                        return new IOutputPrinter(){

                            @Override
                            public void write(PrintWriter target, boolean unicodeSupported) {
                                target.write(unicodeSupported ? "\u274c " : "! ");
                                target.write("Rascal could not recognize this command, ");
                                ParseErrorPrinter.writeUnderLine(target, -1, "beyond line " + pe.getBeginLine() + " and column " + pe.getBeginColumn());
                                target.println();
                            }

                            @Override
                            public String mimeType() {
                                return "text/x-ansi";
                            }
                        };
                    }

                    @Override
                    public IOutputPrinter asPlain() {
                        return new AsciiStringOutputPrinter("! Parse error highlighted");
                    }
                };
            }

            @Override
            public IOutputPrinter asPlain() {
                return new AsciiStringOutputPrinter("! Parse error highlighted");
            }
        };
    }

    private static void lineUp(PrintWriter out) {
        out.write(Ansi.ansi().cursorUpLine().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void highlightErrorInInput(ParseError pe, String input, PrintWriter stdOut, int promptOffset) {
        stdOut.write(Ansi.ansi().saveCursorPosition().toString());
        ParseErrorPrinter.lineUp(stdOut);
        try {
            int currentLine;
            List<String> lines = ParseErrorPrinter.splitLines(input);
            for (currentLine = lines.size(); currentLine > pe.getEndLine(); --currentLine) {
                ParseErrorPrinter.lineUp(stdOut);
            }
            while (currentLine >= pe.getBeginLine()) {
                String thisLine = lines.get(currentLine - 1);
                int offset = 0;
                int endOffset = thisLine.length();
                if (pe.getBeginLine() == currentLine) {
                    offset = pe.getBeginColumn();
                }
                if (pe.getEndLine() == currentLine) {
                    endOffset = pe.getEndColumn();
                }
                if (thisLine.isEmpty() && endOffset == 0) {
                    thisLine = " ";
                    endOffset = 1;
                }
                ParseErrorPrinter.writeUnderLine(stdOut, promptOffset + offset, thisLine, offset, endOffset - offset);
                ParseErrorPrinter.lineUp(stdOut);
                --currentLine;
            }
        }
        finally {
            stdOut.write(Ansi.ansi().restoreCursorPosition().toString());
        }
    }

    private static List<String> splitLines(String input) {
        ArrayList<String> lines = new ArrayList<String>();
        int end = 0;
        int start = 0;
        while (start <= input.length()) {
            end = input.indexOf(10, start);
            end = end == -1 ? input.length() : end;
            lines.add(input.substring(start, end));
            start = end + 1;
        }
        return lines;
    }
}

