/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.streams;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.io.StandardTextWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.jline.jansi.Ansi;
import org.rascalmpl.interpreter.utils.LimitedResultWriter;

public class ReplTextWriter
extends StandardTextWriter {
    private static final String RESET = Ansi.ansi().reset().toString();
    private static final String RESET_RED = Ansi.ansi().reset().fg(Ansi.Color.RED).toString();
    private static final String SOURCE_LOCATION_PREFIX = Ansi.ansi().reset().fg(Ansi.Color.BLUE).a(Ansi.Attribute.UNDERLINE).toString();

    public ReplTextWriter() {
        super(true);
    }

    public ReplTextWriter(boolean indent) {
        super(indent);
    }

    public static String valueToString(IValue value) {
        String string;
        StringWriter stream = new StringWriter();
        try {
            new ReplTextWriter().write(value, stream);
            string = stream.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioex) {
                throw new RuntimeException("Should have never happened.", ioex);
            }
        }
        stream.close();
        return string;
    }

    @Override
    public void write(IValue value, Writer stream) throws IOException {
        final GroupingWriter groupingWriter = new GroupingWriter(stream);
        value.accept(new StandardTextWriter.Writer(groupingWriter, this.indent, this.tabSize){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IValue visitSourceLocation(ISourceLocation o) throws IOException {
                groupingWriter.startGrouping();
                try {
                    groupingWriter.write(SOURCE_LOCATION_PREFIX);
                    IValue result = super.visitSourceLocation(o);
                    groupingWriter.write(groupingWriter.writingToErrorStream() ? RESET_RED : RESET);
                    IValue iValue = result;
                    return iValue;
                }
                finally {
                    groupingWriter.stopGrouping();
                }
            }
        });
        assert (!groupingWriter.isGrouping());
        groupingWriter.flush();
    }

    private static final class GroupingWriter
    extends Writer {
        private final Writer original;
        private StringBuilder groupingBuffer;

        public GroupingWriter(Writer original) {
            this.original = original;
            this.groupingBuffer = null;
        }

        public boolean writingToErrorStream() {
            return this.original instanceof LimitedResultWriter;
        }

        @Override
        public void write(int c) throws IOException {
            if (this.isGrouping()) {
                this.groupingBuffer.append((char)c);
            } else {
                this.original.write(c);
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            if (this.isGrouping()) {
                this.groupingBuffer.append(str, off, len);
            } else {
                this.original.write(str, off, len);
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.isGrouping()) {
                this.groupingBuffer.append(cbuf, off, len);
            } else {
                this.original.write(cbuf, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            if (!this.isGrouping()) {
                this.original.flush();
            }
        }

        @Override
        public void close() throws IOException {
            this.stopGrouping();
            this.original.close();
        }

        public void stopGrouping() throws IOException {
            if (this.isGrouping()) {
                this.original.write(this.groupingBuffer.toString());
                this.groupingBuffer = null;
            }
        }

        public void startGrouping() throws IOException {
            if (!this.isGrouping()) {
                this.groupingBuffer = new StringBuilder(256);
            }
        }

        public boolean isGrouping() {
            return this.groupingBuffer != null;
        }
    }
}

