/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.streams;

import java.io.PrintWriter;
import java.io.Writer;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;
import org.rascalmpl.repl.streams.ItalicErrorWriter;
import org.rascalmpl.repl.streams.RedErrorWriter;

public class StreamUtil {
    public static PrintWriter generateErrorStream(Terminal tm, Writer out) {
        if (StreamUtil.supportsColors(tm)) {
            return new PrintWriter((Writer)new RedErrorWriter(out), true);
        }
        if (StreamUtil.supportsItalic(tm)) {
            return new PrintWriter((Writer)new ItalicErrorWriter(out), true);
        }
        return new PrintWriter(System.err, true);
    }

    public static boolean supportsColors(Terminal tm) {
        Integer cols = tm.getNumericCapability(InfoCmp.Capability.max_colors);
        return cols != null && cols >= 8;
    }

    public static boolean supportsItalic(Terminal tm) {
        String ital = tm.getStringCapability(InfoCmp.Capability.enter_italics_mode);
        return ital != null && !ital.equals("");
    }
}

