/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.runtime;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import org.rascalmpl.types.DefaultRascalTypeVisitor;
import org.rascalmpl.types.RascalType;
import org.rascalmpl.values.parsetrees.ITree;

public class Fingerprint {
    private static final int boolHashCode = "bool".hashCode();
    private static final int intHashCode = "num".hashCode();
    private static final int realHashCode = "num".hashCode();
    private static final int ratHashCode = "num".hashCode();
    private static final int numHashCode = "num".hashCode();
    private static final int strHashCode = "str".hashCode();
    private static final int locHashCode = "loc".hashCode();
    private static final int datetimeHashCode = "datetime".hashCode();
    private static final int listHashCode = "list".hashCode();
    private static final int mapHashCode = "map".hashCode();
    private static final int setHashCode = "set".hashCode();
    private static final int tupleHashCode = "tuple".hashCode();
    private static final int valueHashCode = "value".hashCode();

    public static int getFingerprint(final IValue v) {
        int res = v.getType().accept(new DefaultRascalTypeVisitor<Integer, RuntimeException>(Integer.valueOf(v.hashCode())){

            @Override
            public Integer visitList(Type type) throws RuntimeException {
                return listHashCode;
            }

            @Override
            public Integer visitMap(Type type) throws RuntimeException {
                return mapHashCode;
            }

            @Override
            public Integer visitSet(Type type) throws RuntimeException {
                return setHashCode;
            }

            @Override
            public Integer visitNode(Type type) throws RuntimeException {
                return ((INode)v).getName().hashCode() << 2 + ((INode)v).arity();
            }

            @Override
            public Integer visitConstructor(Type type) throws RuntimeException {
                IConstructor cons = (IConstructor)v;
                return cons.getName().hashCode() << 2 + cons.arity();
            }

            @Override
            public Integer visitAbstractData(Type type) throws RuntimeException {
                return this.visitConstructor(type);
            }

            @Override
            public Integer visitTuple(Type type) throws RuntimeException {
                return tupleHashCode << 2 + ((ITuple)v).arity();
            }

            @Override
            public Integer visitValue(Type type) throws RuntimeException {
                return valueHashCode;
            }

            @Override
            public Integer visitReified(RascalType type) throws RuntimeException {
                return this.visitConstructor(type);
            }

            @Override
            public Integer visitNonTerminal(RascalType type) throws RuntimeException {
                return this.visitAbstractData(type.asAbstractDataType());
            }
        });
        return res;
    }

    public static int getConcreteFingerprint(IValue v) {
        if (v instanceof ITree && ((ITree)v).isAppl()) {
            return ((ITree)v).getProduction().hashCode();
        }
        return Fingerprint.getFingerprint(v);
    }
}

