/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.runtime.traverse;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWithKeywordParameters;
import java.util.Iterator;
import java.util.Map;
import org.rascalmpl.runtime.traverse.ITraverseSpecialization;
import org.rascalmpl.runtime.traverse.TraversalState;
import org.rascalmpl.runtime.traverse.TraverseOnce;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class TraverseOnceNoRebuild
extends TraverseOnce
implements ITraverseSpecialization {
    public TraverseOnceNoRebuild(IValueFactory vf) {
        super(vf);
    }

    @Override
    public IValue traverseTupleOnce(IValue subject, TraversalState tr) {
        ITuple tuple = (ITuple)subject;
        int arity = tuple.arity();
        boolean hasMatched = false;
        boolean hasChanged = false;
        for (int i = 0; i < arity; ++i) {
            tr.setMatchedAndChanged(false, false);
            tr.traverse.once(tuple.get(i), tr);
            hasMatched |= tr.hasMatched();
            hasChanged |= tr.hasChanged();
        }
        tr.setMatchedAndChanged(hasMatched, hasChanged);
        return subject;
    }

    @Override
    public IValue traverseADTOnce(IValue subject, TraversalState tr) {
        IConstructor cons = (IConstructor)subject;
        boolean hasKwParams = cons.mayHaveKeywordParameters() && cons.asWithKeywordParameters().hasParameters();
        int arity = cons.arity();
        if (arity == 0 && !hasKwParams) {
            return subject;
        }
        boolean hasChanged = false;
        boolean hasMatched = false;
        for (int i = 0; i < arity; ++i) {
            IValue child = cons.get(i);
            tr.setMatchedAndChanged(false, false);
            child = tr.traverse.once(child, tr);
            hasChanged |= tr.hasChanged();
            hasMatched |= tr.hasMatched();
        }
        if (hasKwParams) {
            IWithKeywordParameters<? extends IConstructor> consKw = cons.asWithKeywordParameters();
            for (String kwName : consKw.getParameterNames()) {
                Object val = consKw.getParameter(kwName);
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once((IValue)val, tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            }
        }
        tr.setMatchedAndChanged(hasMatched, hasChanged);
        return subject;
    }

    @Override
    public IValue traverseConcreteTreeOnce(IValue subject, TraversalState tr) {
        ITree tree = (ITree)subject;
        IList list = TreeAdapter.getArgs(tree);
        int len = list.length();
        if (len > 0) {
            boolean hasChanged = false;
            boolean hasMatched = false;
            if (TreeAdapter.isTop(tree)) {
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(list.get(0), tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(list.get(1), tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(list.get(2), tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            } else {
                for (int i = 0; i < len; ++i) {
                    IValue elem = list.get(i);
                    if (i % 2 != 0) continue;
                    tr.setMatchedAndChanged(false, false);
                    tr.traverse.once(elem, tr);
                    hasChanged |= tr.hasChanged();
                    hasMatched |= tr.hasMatched();
                }
            }
            tr.setMatchedAndChanged(hasMatched, hasChanged);
        }
        return subject;
    }

    @Override
    public IValue traverseMapOnce(IValue subject, TraversalState tr) {
        IMap map = (IMap)subject;
        if (!map.isEmpty()) {
            Iterator<Map.Entry<IValue, IValue>> iter = map.entryIterator();
            boolean hasChanged = false;
            boolean hasMatched = false;
            while (iter.hasNext()) {
                Map.Entry<IValue, IValue> entry = iter.next();
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(entry.getKey(), tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(entry.getValue(), tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            }
            tr.setMatchedAndChanged(hasMatched, hasChanged);
            return subject;
        }
        return subject;
    }

    @Override
    public IValue traverseSetOnce(IValue subject, TraversalState tr) {
        ISet set = (ISet)subject;
        if (!set.isEmpty()) {
            boolean hasChanged = false;
            boolean hasMatched = false;
            for (IValue v : set) {
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(v, tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            }
            tr.setMatchedAndChanged(hasMatched, hasChanged);
            return subject;
        }
        return subject;
    }

    @Override
    public IValue traverseListOnce(IValue subject, TraversalState tr) {
        IList list = (IList)subject;
        int len = list.length();
        if (len > 0) {
            boolean hasChanged = false;
            boolean hasMatched = false;
            for (int i = 0; i < len; ++i) {
                IValue elem = list.get(i);
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once(elem, tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            }
            tr.setMatchedAndChanged(hasMatched, hasChanged);
            return subject;
        }
        return subject;
    }

    @Override
    public IValue traverseNodeOnce(IValue subject, TraversalState tr) {
        boolean hasKwParams;
        IValue result = subject;
        INode node = (INode)subject;
        int arity = node.arity();
        boolean bl = hasKwParams = node.mayHaveKeywordParameters() && node.asWithKeywordParameters().hasParameters();
        if (arity == 0 && !hasKwParams) {
            result = subject;
        }
        boolean hasChanged = false;
        boolean hasMatched = false;
        for (int i = 0; i < arity; ++i) {
            IValue child = node.get(i);
            tr.setMatchedAndChanged(false, false);
            tr.traverse.once(child, tr);
            hasChanged |= tr.hasChanged();
            hasMatched |= tr.hasMatched();
        }
        if (hasKwParams) {
            IWithKeywordParameters<? extends INode> nodeKw = node.asWithKeywordParameters();
            for (String kwName : nodeKw.getParameterNames()) {
                Object val2 = nodeKw.getParameter(kwName);
                tr.setMatchedAndChanged(false, false);
                tr.traverse.once((IValue)val2, tr);
                hasChanged |= tr.hasChanged();
                hasMatched |= tr.hasMatched();
            }
        }
        tr.setMatchedAndChanged(hasMatched, hasChanged);
        return result;
    }

    @Override
    public IValue traverseStringOnce(IValue subject, TraversalState tr) {
        boolean hasMatched = tr.hasMatched();
        boolean hasChanged = tr.hasChanged();
        tr.setMatchedAndChanged(false, false);
        IValue res = this.traverseString(subject, tr);
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return res;
    }

    private IValue traverseString(IValue subject, TraversalState tr) {
        IString subjectIString = (IString)subject;
        String subjectString = subjectIString.getValue();
        int len = subjectString.length();
        int subjectCursor = 0;
        boolean hasMatched = false;
        boolean hasChanged = false;
        while (subjectCursor < len) {
            tr.setMatchedAndChanged(false, false);
            tr.setBegin(0);
            tr.setEnd(len);
            this.traverseTop(this.vf.string(subjectString.substring(subjectCursor, len)), tr);
            subjectCursor = tr.hasMatched() ? (subjectCursor += tr.getEnd()) : ++subjectCursor;
            hasMatched |= tr.hasMatched();
            hasChanged |= tr.hasChanged();
        }
        tr.setMatchedAndChanged(tr.hasMatched() | hasMatched, tr.hasChanged() | hasChanged);
        return subject;
    }
}

