/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import org.rascalmpl.ast.BasicType;
import org.rascalmpl.interpreter.BasicTypeEvaluator;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.asserts.NotYetImplemented;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.NonWellformedType;
import org.rascalmpl.types.RascalTypeFactory;

public abstract class BasicType
extends org.rascalmpl.ast.BasicType {
    public BasicType(ISourceLocation __param1, IConstructor tree) {
        super(__param1, tree);
    }

    public static class Void
    extends BasicType.Void {
        public Void(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().getArity() == 0) {
                return BasicTypeEvaluator.__getTf().voidType();
            }
            throw new NonWellformedType("void cannot have type arguments.", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TF.voidType();
        }
    }

    public static class Value
    extends BasicType.Value {
        public Value(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().getArity() == 0) {
                return BasicTypeEvaluator.__getTf().valueType();
            }
            throw new NonWellformedType("value cannot have type arguments.", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TF.valueType();
        }
    }

    public static class Tuple
    extends BasicType.Tuple {
        public Tuple(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            return __eval.__getTypeArgument();
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            throw new NonWellformedType("tuple should have type arguments, like tuple[value,value].", this);
        }
    }

    public static class String
    extends BasicType.String {
        public String(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().getArity() == 0) {
                return BasicTypeEvaluator.__getTf().stringType();
            }
            throw new NonWellformedType("string cannot have type arguments.", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TF.stringType();
        }
    }

    public static class Set
    extends BasicType.Set {
        public Set(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().isBottom()) {
                return TF.listType(TF.voidType());
            }
            if (__eval.__getTypeArgument().getArity() == 1) {
                return BasicTypeEvaluator.__getTf().setType(__eval.__getTypeArgument().getFieldType(0));
            }
            throw new NonWellformedType("set should have exactly one type argument, like set[value]", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            throw new NonWellformedType("set should have one type argument, like set[value].", this);
        }
    }

    public static class ListRelation
    extends BasicType.ListRelation {
        public ListRelation(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            return BasicTypeEvaluator.__getTf().lrelTypeFromTuple(__eval.__getTypeArgument());
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            throw new NonWellformedType("lrel should have at least one type argument, like lrel[value,value].", this);
        }
    }

    public static class Relation
    extends BasicType.Relation {
        public Relation(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            return BasicTypeEvaluator.__getTf().relTypeFromTuple(__eval.__getTypeArgument());
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            throw new NonWellformedType("rel should have at least one type argument, like rel[value,value].", this);
        }
    }

    public static class Type
    extends BasicType.Type {
        public Type(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().isBottom()) {
                return RascalTypeFactory.getInstance().reifiedType(TF.voidType());
            }
            if (__eval.__getTypeArgument().getArity() == 1) {
                return RascalTypeFactory.getInstance().reifiedType(__eval.__getTypeArgument().getFieldType(0));
            }
            throw new NonWellformedType("type should have exactly one type argument, like type[value]", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            throw new NonWellformedType("type should have at one type argument, like type[value].", this);
        }
    }

    public static class Real
    extends BasicType.Real {
        public Real(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().getArity() == 0) {
                return BasicTypeEvaluator.__getTf().realType();
            }
            throw new NonWellformedType("real cannot have type arguments.", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TF.realType();
        }
    }

    public static class Num
    extends BasicType.Num {
        public Num(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().getArity() == 0) {
                return BasicTypeEvaluator.__getTf().numberType();
            }
            throw new NonWellformedType("num cannot have type arguments.", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TF.numberType();
        }
    }

    public static class Node
    extends BasicType.Node {
        public Node(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().getArity() == 0) {
                return BasicTypeEvaluator.__getTf().nodeType();
            }
            throw new NonWellformedType("node cannot have type arguments.", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TF.nodeType();
        }
    }

    public static class Map
    extends BasicType.Map {
        public Map(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().isBottom()) {
                return TF.mapType(TF.voidType(), TF.voidType());
            }
            if (__eval.__getTypeArgument().getArity() == 2) {
                return TF.mapTypeFromTuple(__eval.__getTypeArgument());
            }
            throw new NonWellformedType("map should have exactly two type arguments, like map[value,value]", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            throw new NonWellformedType("map should have at two type arguments, like map[value,value].", this);
        }
    }

    public static class Loc
    extends BasicType.Loc {
        public Loc(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().getArity() == 0) {
                return BasicTypeEvaluator.__getTf().sourceLocationType();
            }
            throw new NonWellformedType("loc cannot have type arguments.", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TF.sourceLocationType();
        }
    }

    public static class List
    extends BasicType.List {
        public List(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument() == TF.voidType()) {
                return TF.listType(TF.voidType());
            }
            if (__eval.__getTypeArgument().getArity() == 1) {
                return TF.listType(__eval.__getTypeArgument().getFieldType(0));
            }
            throw new NonWellformedType("list should have exactly one type argument, like list[value]", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            throw new NonWellformedType("list should have one type argument, like list[value].", this);
        }
    }

    public static class Rational
    extends BasicType.Rational {
        public Rational(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().getArity() == 0) {
                return BasicTypeEvaluator.__getTf().integerType();
            }
            throw new NonWellformedType("rat cannot have type arguments.", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TF.rationalType();
        }
    }

    public static class Int
    extends BasicType.Int {
        public Int(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().getArity() == 0) {
                return BasicTypeEvaluator.__getTf().integerType();
            }
            throw new NonWellformedType("int cannot have type arguments.", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TF.integerType();
        }
    }

    public static class DateTime
    extends BasicType.DateTime {
        public DateTime(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().getArity() == 0) {
                return BasicTypeEvaluator.__getTf().dateTimeType();
            }
            throw new NonWellformedType("datetime cannot have type arguments.", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TF.dateTimeType();
        }
    }

    public static class Bool
    extends BasicType.Bool {
        public Bool(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            if (__eval.__getTypeArgument().getArity() == 0) {
                return BasicTypeEvaluator.__getTf().boolType();
            }
            throw new NonWellformedType("bool cannot have type arguments.", this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TF.boolType();
        }
    }

    public static class Bag
    extends BasicType.Bag {
        public Bag(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public io.usethesource.vallang.type.Type __evaluate(BasicTypeEvaluator __eval) {
            throw new NotYetImplemented(this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            throw new NonWellformedType("bag should have one type argument, like bag[value].", this);
        }
    }
}

