/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.Arrays;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.FunctionBody;
import org.rascalmpl.ast.FunctionDeclaration;
import org.rascalmpl.ast.FunctionModifier;
import org.rascalmpl.ast.Signature;
import org.rascalmpl.ast.Tags;
import org.rascalmpl.ast.Visibility;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.JavaMethod;
import org.rascalmpl.interpreter.result.RascalFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.MissingModifier;
import org.rascalmpl.interpreter.staticErrors.NonAbstractJavaFunction;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.parser.ASTBuilder;

public abstract class FunctionDeclaration
extends org.rascalmpl.ast.FunctionDeclaration {
    public static boolean hasJavaModifier(org.rascalmpl.ast.FunctionDeclaration func) {
        List<FunctionModifier> mods = func.getSignature().getModifiers().getModifiers();
        for (FunctionModifier m4 : mods) {
            if (!m4.isJava()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTestModifier(org.rascalmpl.ast.FunctionDeclaration func) {
        List<FunctionModifier> mods = func.getSignature().getModifiers().getModifiers();
        for (FunctionModifier m4 : mods) {
            if (!m4.isTest()) continue;
            return true;
        }
        return false;
    }

    public FunctionDeclaration(ISourceLocation __param1, IConstructor tree) {
        super(__param1, tree);
    }

    public static class Conditional
    extends FunctionDeclaration.Conditional {
        public Conditional(ISourceLocation src, IConstructor node, Tags tags, Visibility visibility, Signature signature, org.rascalmpl.ast.Expression expression, List<org.rascalmpl.ast.Expression> conditions) {
            super(src, node, tags, visibility, signature, expression, conditions);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            boolean hasVarArgs = this.getSignature().getParameters().isVarArgs();
            if (FunctionDeclaration.hasJavaModifier(this)) {
                throw new NonAbstractJavaFunction(this);
            }
            ISourceLocation src = this.getLocation();
            Object ret = ASTBuilder.makeStat("Return", src, ASTBuilder.makeStat("Expression", src, this.getExpression()));
            Object fail = ASTBuilder.makeStat("Fail", src, ASTBuilder.make("Target", "Labeled", src, this.getSignature().getName()));
            Object ite = ASTBuilder.makeStat("IfThenElse", src, ASTBuilder.make("Label", "Empty", src, new Object[0]), this.getConditions(), ret, fail);
            List<AbstractAST> sl = Arrays.asList(ite);
            Object body = ASTBuilder.make("FunctionBody", "Default", src, sl);
            Default func = (Default)ASTBuilder.make("FunctionDeclaration", "Default", src, this.getTags(), this.getVisibility(), this.getSignature(), body);
            boolean isPublic = this.getVisibility().isPublic() || this.getVisibility().isDefault();
            RascalFunction lambda = new RascalFunction(__eval, func, hasVarArgs, __eval.getCurrentEnvt(), __eval.__getAccumulators());
            __eval.getCurrentEnvt().storeFunction(((AbstractFunction)lambda).getName(), lambda);
            __eval.getCurrentEnvt().markFunctionNameFinal(((AbstractFunction)lambda).getName());
            __eval.getCurrentEnvt().markFunctionNameOverloadable(((AbstractFunction)lambda).getName());
            if (!isPublic) {
                __eval.getCurrentEnvt().markFunctionNamePrivate(((AbstractFunction)lambda).getName());
            }
            return lambda;
        }
    }

    public static class Expression
    extends FunctionDeclaration.Expression {
        public Expression(ISourceLocation src, IConstructor node, Tags tags, Visibility visibility, Signature signature, org.rascalmpl.ast.Expression expression) {
            super(src, node, tags, visibility, signature, expression);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            boolean isPublic;
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            boolean hasVarArgs = this.getSignature().getParameters().isVarArgs();
            boolean bl = isPublic = this.getVisibility().isPublic() || this.getVisibility().isDefault();
            if (FunctionDeclaration.hasJavaModifier(this)) {
                throw new NonAbstractJavaFunction(this);
            }
            RascalFunction lambda = new RascalFunction(__eval, this, hasVarArgs, __eval.getCurrentEnvt(), __eval.__getAccumulators());
            __eval.getCurrentEnvt().markFunctionNameFinal(((AbstractFunction)lambda).getName());
            __eval.getCurrentEnvt().markFunctionNameOverloadable(((AbstractFunction)lambda).getName());
            __eval.getCurrentEnvt().storeFunction(((AbstractFunction)lambda).getName(), lambda);
            if (!isPublic) {
                __eval.getCurrentEnvt().markFunctionNamePrivate(((AbstractFunction)lambda).getName());
            }
            return lambda;
        }
    }

    public static class Default
    extends FunctionDeclaration.Default {
        public Default(ISourceLocation __param1, IConstructor tree, Tags __param2, Visibility __param3, Signature __param4, FunctionBody __param5) {
            super(__param1, tree, __param2, __param3, __param4, __param5);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            boolean isPublic;
            boolean hasVarArgs = this.getSignature().getParameters().isVarArgs();
            boolean bl = isPublic = this.getVisibility().isPublic() || this.getVisibility().isDefault();
            if (FunctionDeclaration.hasJavaModifier(this)) {
                throw new NonAbstractJavaFunction(this);
            }
            if (!this.getBody().isDefault()) {
                throw new MissingModifier("java", this);
            }
            RascalFunction lambda = new RascalFunction(__eval, this, hasVarArgs, __eval.getCurrentEnvt(), __eval.__getAccumulators());
            __eval.getCurrentEnvt().storeFunction(((AbstractFunction)lambda).getName(), lambda);
            __eval.getCurrentEnvt().markFunctionNameFinal(((AbstractFunction)lambda).getName());
            __eval.getCurrentEnvt().markFunctionNameOverloadable(((AbstractFunction)lambda).getName());
            if (!isPublic) {
                __eval.getCurrentEnvt().markFunctionNamePrivate(((AbstractFunction)lambda).getName());
            }
            return lambda;
        }

        @Override
        public Type typeOf(Environment __eval, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return this.getSignature().typeOf(__eval, eval, instantiateTypeParameters);
        }
    }

    public static class Abstract
    extends FunctionDeclaration.Abstract {
        public Abstract(ISourceLocation __param1, IConstructor tree, Tags __param2, Visibility __param3, Signature __param4) {
            super(__param1, tree, __param2, __param3, __param4);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            boolean varArgs = this.getSignature().getParameters().isVarArgs();
            if (!FunctionDeclaration.hasJavaModifier(this)) {
                throw new MissingModifier("java", this);
            }
            JavaMethod lambda = new JavaMethod(__eval, this, varArgs, __eval.getCurrentEnvt(), __eval.__getJavaBridge());
            String name = Names.name(this.getSignature().getName());
            boolean isPublic = this.getVisibility().isPublic() || this.getVisibility().isDefault();
            __eval.getCurrentEnvt().storeFunction(name, lambda);
            __eval.getCurrentEnvt().markFunctionNameFinal(((AbstractFunction)lambda).getName());
            __eval.getCurrentEnvt().markFunctionNameOverloadable(((AbstractFunction)lambda).getName());
            if (!isPublic) {
                __eval.getCurrentEnvt().markFunctionNamePrivate(((AbstractFunction)lambda).getName());
            }
            return lambda;
        }
    }
}

