/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.rascalmpl.ast.Import;
import org.rascalmpl.ast.ImportedModule;
import org.rascalmpl.ast.LocationLiteral;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.ast.SyntaxDefinition;
import org.rascalmpl.ast.Tag;
import org.rascalmpl.ast.TagString;
import org.rascalmpl.ast.Toplevel;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.asserts.Ambiguous;
import org.rascalmpl.interpreter.control_exceptions.InterruptException;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.env.GlobalEnvironment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.result.ICallableValue;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.result.SourceLocationResult;
import org.rascalmpl.interpreter.staticErrors.CyclicExtend;
import org.rascalmpl.interpreter.staticErrors.CyclicImportExtend;
import org.rascalmpl.interpreter.staticErrors.ModuleImport;
import org.rascalmpl.interpreter.staticErrors.ModuleNameMismatch;
import org.rascalmpl.interpreter.staticErrors.StaticError;
import org.rascalmpl.interpreter.staticErrors.SyntaxError;
import org.rascalmpl.interpreter.staticErrors.UndeclaredModule;
import org.rascalmpl.interpreter.staticErrors.UndeclaredModuleProvider;
import org.rascalmpl.interpreter.utils.Modules;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.library.lang.rascal.syntax.RascalParser;
import org.rascalmpl.parser.ASTBuilder;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.parser.gtd.exception.UndeclaredNonTerminalException;
import org.rascalmpl.parser.gtd.result.out.DefaultNodeFlattener;
import org.rascalmpl.parser.uptr.UPTRNodeFactory;
import org.rascalmpl.parser.uptr.action.NoActionExecutor;
import org.rascalmpl.semantics.dynamic.Module;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.RascalFunctionValueFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;
import org.rascalmpl.values.parsetrees.visitors.IdentityTreeVisitor;

public abstract class Import {
    private static final ThreadLocal<ASTBuilder> builder = ThreadLocal.withInitial(() -> new ASTBuilder());

    public static void importModule(String name, ISourceLocation src, IEvaluator<Result<IValue>> eval) {
        GlobalEnvironment heap = eval.__getHeap();
        if (!heap.existsModule(name)) {
            heap.addModule(new ModuleEnvironment(name, heap));
            Import.loadModule(src, name, eval);
        } else if (eval.getCurrentEnvt() == eval.__getRootScope()) {
            heap.resetModule(name);
            Import.loadModule(src, name, eval);
        }
        Import.addImportToCurrentModule(src, name, eval);
        if (heap.getModule(name).isDeprecated()) {
            eval.warning(src + ":" + name + " is deprecated, " + heap.getModule(name).getDeprecatedMessage(), src);
        }
    }

    public static void extendCurrentModule(ISourceLocation x, String name, IEvaluator<Result<IValue>> eval) {
        GlobalEnvironment heap = eval.__getHeap();
        ModuleEnvironment other = heap.getModule(name);
        eval.getCurrentModuleEnvironment().addExtend(name);
        if (other == null) {
            heap.addModule(new ModuleEnvironment(name, heap));
            other = Import.loadModule(x, name, eval);
        } else if (eval.getCurrentEnvt() == eval.__getRootScope()) {
            heap.resetModule(name);
            other = Import.loadModule(x, name, eval);
        }
        ModuleEnvironment thisEnv = eval.getCurrentModuleEnvironment();
        Set<String> extendSet = other.getExtendsTransitive();
        if (extendSet.contains(thisEnv.getName())) {
            List<String> path = eval.getHeap().findCyclicExtendPathFrom(other.getName(), thisEnv.getName());
            assert (!path.isEmpty()) : "weird to have detected a non-existent cycle";
            throw new CyclicExtend(thisEnv.getName(), path.stream().map(m4 -> eval.getRascalResolver().resolveModule((String)m4)).collect(Collectors.toList()), x);
        }
        if (!other.isInitialized()) {
            String startCycle = other.getName();
            List<ISourceLocation> cycle = heap.getLoadStack().stream().takeWhile(m4 -> !startCycle.equals(m4)).map(m4 -> eval.getRascalResolver().resolveModule((String)m4)).collect(Collectors.toList());
            cycle.add(eval.getRascalResolver().resolveModule(startCycle));
            throw new CyclicImportExtend(other.getName(), cycle, x);
        }
        thisEnv.extend(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleEnvironment loadModule(ISourceLocation x, String name, IEvaluator<Result<IValue>> eval) {
        ModuleEnvironment env;
        block15: {
            GlobalEnvironment heap = eval.getHeap();
            String jobName = "loading modules";
            ModuleEnvironment m4 = heap.getModule(name);
            if (m4 == null) {
                m4 = new ModuleEnvironment(name, heap);
                heap.addModule(m4);
            }
            if (heap.pushModuleLoading(name)) {
                heap.popModuleLoading();
                return m4;
            }
            env = m4;
            ISourceLocation uri = eval.getRascalResolver().resolveModule(name);
            try {
                eval.jobTodo(jobName, 1);
                if (uri == null) {
                    throw new ModuleImport(name, "can not find in search path", x);
                }
                org.rascalmpl.ast.Module module = Import.buildModule(uri, env, eval, jobName);
                if (Import.isDeprecated(module)) {
                    eval.warning("Deprecated module " + name + ":" + Import.getDeprecatedMessage(module), uri);
                }
                if (module != null) {
                    String internalName = Module.getModuleName(module);
                    if (!internalName.equals(name)) {
                        throw new ModuleNameMismatch(internalName, name, x);
                    }
                    heap.setModuleURI(name, module.getLocation().getURI());
                    module.interpret(eval);
                }
            }
            catch (StaticError e) {
                Import.handleLoadError(env, e.getMessage(), e.getLocation(), "");
            }
            catch (Throw e) {
                Import.handleLoadError(env, e.getMessage(), e.getLocation(), e.getTrace().toString());
            }
            catch (Throwable e) {
                String msg = e.getClass().getSimpleName() + ": " + e.getMessage();
                Import.handleLoadError(env, msg, x, Arrays.stream(e.getStackTrace()).map(Object::toString).collect(Collectors.joining("\n")));
            }
            finally {
                env.setInitialized();
                eval.jobStep(jobName, name, 1);
                String popped = heap.popModuleLoading();
                if ($assertionsDisabled || popped.equals(name)) break block15;
                throw new AssertionError((Object)(popped + " != " + name));
            }
        }
        return env;
    }

    private static void handleLoadError(ModuleEnvironment m4, String message, ISourceLocation error, String trace) {
        m4.addLoadError(message, error, trace);
    }

    private static boolean isDeprecated(org.rascalmpl.ast.Module preModule) {
        for (Tag tag : preModule.getHeader().getTags().getTags()) {
            if (!((Name.Lexical)tag.getName()).getString().equals("deprecated")) continue;
            return true;
        }
        return false;
    }

    private static String getDeprecatedMessage(org.rascalmpl.ast.Module preModule) {
        for (Tag tag : preModule.getHeader().getTags().getTags()) {
            if (!((Name.Lexical)tag.getName()).getString().equals("deprecated")) continue;
            String contents = ((TagString.Lexical)tag.getContents()).getString();
            return contents.substring(1, contents.length() - 1);
        }
        return "";
    }

    private static org.rascalmpl.ast.Module buildModule(ISourceLocation uri, ModuleEnvironment env, IEvaluator<Result<IValue>> eval, String jobName) throws IOException {
        ITree tree = eval.parseModuleAndFragments(eval, uri, jobName);
        return Import.getBuilder().buildModule(tree);
    }

    private static ASTBuilder getBuilder() {
        return builder.get();
    }

    private static void addImportToCurrentModule(ISourceLocation src, String name, IEvaluator<Result<IValue>> eval) {
        ModuleEnvironment module = eval.getHeap().getModule(name);
        if (module == null) {
            throw new UndeclaredModule(name, src);
        }
        ModuleEnvironment current = eval.getCurrentModuleEnvironment();
        current.addImport(name, module);
        current.setSyntaxDefined(current.definesSyntax() || module.definesSyntax());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITree parseModuleAndFragments(char[] data, ISourceLocation location, String jobName, IEvaluator<Result<IValue>> eval) {
        ITree result;
        block25: {
            ITree tree;
            eval.__setInterrupt(false);
            NoActionExecutor actions = new NoActionExecutor();
            try {
                eval.jobTodo(jobName, 1);
                tree = new RascalParser().parse("start__Module", location.getURI(), data, Integer.MAX_VALUE, actions, new DefaultNodeFlattener(), new UPTRNodeFactory(true));
            }
            catch (ParseError e) {
                throw new SyntaxError("module", IRascalValueFactory.getInstance().sourceLocation(location, e.getOffset(), e.getLength(), e.getBeginLine(), e.getEndLine(), e.getBeginColumn(), e.getEndColumn()));
            }
            finally {
                eval.jobStep(jobName, "parsed " + URIUtil.getLocationName(location), 1);
            }
            if (TreeAdapter.isAmb(tree)) {
                return tree;
            }
            ITree top = TreeAdapter.getStartTop(tree);
            String name = Modules.getName(top);
            GlobalEnvironment heap = eval.getHeap();
            ModuleEnvironment env = heap.getModule(name);
            if (env == null) {
                env = new ModuleEnvironment(name, heap);
            }
            env.setBootstrap(Import.needBootstrapParser(data));
            Environment old = eval.getCurrentEnvt();
            try {
                eval.setCurrentEnvt(env);
                Import.declareTypesWhichDoNotNeedImportedModulesAlready(eval, env, top);
                eval.getCurrentModuleEnvironment().clearProductions();
                ISet rules = Modules.getSyntax(top);
                eval.getMonitor().jobTodo(jobName, rules.size());
                for (Object rule : rules) {
                    Import.evalSyntax(eval, name, (IConstructor)rule);
                    eval.getMonitor().jobStep(jobName, "defining syntax for " + name, 1);
                    if (!eval.isInterrupted()) continue;
                    throw new InterruptException(eval.getStackTrace(), eval.getCurrentAST().getLocation());
                }
                ISet imports = Modules.getImports(top);
                eval.getMonitor().jobTodo(jobName, imports.size());
                for (Object mod : imports) {
                    Import.evalImport(eval, (IConstructor)mod);
                    eval.getMonitor().jobStep(jobName, "importing for " + name, 1);
                    if (!eval.isInterrupted()) continue;
                    throw new InterruptException(eval.getStackTrace(), eval.getCurrentAST().getLocation());
                }
                ISet extend = Modules.getExtends(top);
                eval.getMonitor().jobTodo(jobName, extend.size());
                for (Object mod : extend) {
                    Import.evalImport(eval, (IConstructor)mod);
                    eval.getMonitor().jobStep(jobName, "extending for " + name, 1);
                    if (!eval.isInterrupted()) continue;
                    throw new InterruptException(eval.getStackTrace(), eval.getCurrentAST().getLocation());
                }
                ISet externals = Modules.getExternals(top);
                eval.getMonitor().jobTodo(jobName, externals.size());
                for (IValue mod : externals) {
                    Import.evalImport(eval, (IConstructor)mod);
                    eval.getMonitor().jobStep(jobName, "external importing for " + name, 1);
                    if (!eval.isInterrupted()) continue;
                    throw new InterruptException(eval.getStackTrace(), eval.getCurrentAST().getLocation());
                }
            }
            finally {
                eval.setCurrentEnvt(old);
            }
            result = tree;
            try {
                if (eval.getHeap().isBootstrapper() || !Import.needBootstrapParser(data) && (!env.definesSyntax() || !Import.containsBackTick(data, 0))) break block25;
                RascalFunctionValueFactory vf = eval.getFunctionValueFactory();
                URIResolverRegistry reg = URIResolverRegistry.getInstance();
                ISourceLocation parserCacheFile = URIUtil.changeExtension(location, "parsers");
                IFunction parsers = null;
                if (env.getBootstrap()) {
                    parsers = vf.bootstrapParsers();
                } else if (reg.exists(parserCacheFile)) {
                    parsers = vf.loadParsers(parserCacheFile, vf.bool(false), vf.integer(Integer.MAX_VALUE), vf.bool(false), vf.integer(0), vf.integer(0), vf.bool(false), vf.bool(false), vf.set(new IValue[0]));
                } else {
                    IConstructor dummy = TreeAdapter.getType(tree);
                    IMap syntaxDefinition = env.getSyntaxDefinition();
                    IMap grammar = (IMap)eval.getParserGenerator().getGrammarFromModules(eval.getMonitor(), env.getName(), syntaxDefinition).get("rules");
                    IConstructor reifiedType = vf.reifiedType(dummy, grammar);
                    parsers = vf.parsers(reifiedType, vf.bool(false), vf.integer(Integer.MAX_VALUE), vf.bool(false), vf.integer(0), vf.integer(0), vf.bool(false), vf.bool(false), vf.set(new IValue[0]));
                }
                try {
                    eval.getMonitor().jobTodo(jobName, 1);
                    result = Import.parseFragments(vf, eval.getMonitor(), parsers, tree, location, env);
                }
                finally {
                    eval.getMonitor().jobStep(jobName, "parsed concrete fragments", 1);
                }
            }
            catch (IOException | ClassNotFoundException | URISyntaxException e) {
                eval.warning("reusing parsers failed during module import: " + e.getMessage(), env.getLocation());
            }
        }
        return result;
    }

    private static void declareTypesWhichDoNotNeedImportedModulesAlready(IEvaluator<Result<IValue>> eval, ModuleEnvironment env, ITree top) {
        List<Toplevel> decls = Modules.getTypeDeclarations(top, Import.getBuilder());
        eval.__getTypeDeclarator().evaluateDeclarations(decls, eval.getCurrentEnvt(), true);
    }

    public static void evalImport(IEvaluator<Result<IValue>> eval, IConstructor mod) {
        org.rascalmpl.ast.Import imp = (org.rascalmpl.ast.Import)Import.getBuilder().buildValue(mod);
        String name = Names.fullName(imp.getModule().getName());
        try {
            imp.interpret(eval);
        }
        catch (Throw rascalException) {
            Import.handleLoadError(eval.getHeap().getModule(name), rascalException.getMessage(), rascalException.getLocation(), rascalException.getTrace().toString());
        }
        catch (CyclicExtend | CyclicImportExtend e) {
            Import.handleLoadError(eval.getHeap().getModule(name), e.getMessage(), e.getLocation(), "");
        }
        catch (StaticError e) {
            Import.handleLoadError(eval.getHeap().getModule(name), e.getMessage(), e.getLocation(), "");
        }
        catch (Throwable e) {
            Import.handleLoadError(eval.getHeap().getModule(name), e.getMessage(), imp.getLocation(), Arrays.stream(e.getStackTrace()).map(Object::toString).collect(Collectors.joining("\n")));
        }
    }

    public static void evalSyntax(IEvaluator<Result<IValue>> eval, String moduleName, IConstructor mod) {
        org.rascalmpl.ast.Import def = (org.rascalmpl.ast.Import)Import.getBuilder().buildValue(mod);
        try {
            def.interpret(eval);
        }
        catch (Throw rascalException) {
            Import.handleLoadError(eval.getHeap().getModule(moduleName), rascalException.getMessage(), rascalException.getLocation(), rascalException.getTrace().toString());
        }
        catch (StaticError e) {
            Import.handleLoadError(eval.getHeap().getModule(moduleName), e.getMessage(), e.getLocation(), "");
        }
        catch (Throwable e) {
            Import.handleLoadError(eval.getHeap().getModule(moduleName), e.getMessage(), def.getLocation(), Arrays.stream(e.getStackTrace()).map(Object::toString).collect(Collectors.joining("\n")));
        }
    }

    public static ITree parseFragments(final RascalFunctionValueFactory vf, final IRascalMonitor monitor, final IFunction parsers, IConstructor module, final ISourceLocation location, ModuleEnvironment env) {
        return (ITree)module.accept(new IdentityTreeVisitor<ImplementationError>(){

            @Override
            public ITree visitTreeAppl(ITree tree) {
                IConstructor pattern = this.getConcretePattern(tree);
                if (pattern != null) {
                    ITree parsedFragment = Import.parseFragment(vf, monitor, parsers, (ITree)TreeAdapter.getArgs(tree).get(0), location);
                    return TreeAdapter.setArgs(tree, vf.list(parsedFragment));
                }
                IListWriter w = vf.listWriter();
                IList args = TreeAdapter.getArgs(tree);
                for (IValue arg : args) {
                    if (!TreeAdapter.isLayout(tree) && !TreeAdapter.isLexical(tree)) {
                        w.append(arg.accept(this));
                        continue;
                    }
                    w.append(arg);
                }
                args = (IList)w.done();
                return TreeAdapter.setArgs(tree, args);
            }

            private IConstructor getConcretePattern(ITree tree) {
                String cons;
                String sort = TreeAdapter.getSortName(tree);
                if ((sort.equals("Expression") || sort.equals("Pattern")) && (cons = TreeAdapter.getConstructorName(tree)).equals("concrete")) {
                    return (IConstructor)TreeAdapter.getArgs(tree).get(0);
                }
                return null;
            }

            @Override
            public ITree visitTreeAmb(ITree arg) {
                throw new Ambiguous(arg);
            }
        });
    }

    private static ITree parseFragment(RascalFunctionValueFactory vf, IRascalMonitor monitor, IFunction parsers, ITree tree, ISourceLocation uri) {
        ITree symTree = TreeAdapter.getArg(tree, "symbol");
        ITree lit = TreeAdapter.getArg(tree, "parts");
        HashMap<String, ITree> antiquotes = new HashMap<String, ITree>();
        try {
            IConstructor reifiedSym = vf.reifiedType(vf.sym2symbol(symTree), vf.map());
            TreeMap<Integer, Integer> corrections = new TreeMap<Integer, Integer>();
            char[] input = Import.replaceAntiQuotesByHoles(vf, lit, antiquotes, corrections);
            ITree fragment = (ITree)parsers.call(reifiedSym, vf.string(new String(input)), uri);
            fragment = fragment.accept(new AdjustLocations(corrections, vf));
            fragment = Import.replaceHolesByAntiQuotes(vf, fragment, antiquotes, corrections);
            IConstructor prod = TreeAdapter.getProduction(tree);
            IConstructor sym = ProductionAdapter.getDefined(prod);
            sym = SymbolAdapter.delabel(sym);
            prod = ProductionAdapter.setDefined(prod, vf.constructor(RascalValueFactory.Symbol_Label, vf.string("$parsed"), sym));
            return TreeAdapter.setProduction(TreeAdapter.setArg(tree, "parts", fragment), prod);
        }
        catch (Throw e) {
            IConstructor exception = (IConstructor)e.getException();
            if (exception.getName().equals("ParseError")) {
                ISourceLocation err = (ISourceLocation)exception.get(0);
                ISourceLocation loc = TreeAdapter.getLocation(tree);
                ISourceLocation src = vf.sourceLocation(loc.top(), loc.getOffset() + err.getOffset(), loc.getLength(), loc.getBeginLine() + err.getBeginLine() - 1, loc.getEndLine() + err.getEndLine() - 1, loc.getBeginColumn() + err.getBeginColumn(), loc.getBeginColumn() + err.getEndColumn());
                monitor.warning("parse error in concrete syntax: " + src, src);
                return (ITree)tree.asWithKeywordParameters().setParameter("parseError", src);
            }
            if (exception.getName().equals("Ambiguity")) {
                ISourceLocation ambLocation = (ISourceLocation)exception.get(0);
                ISourceLocation loc = TreeAdapter.getLocation(tree);
                ISourceLocation src = ambLocation.hasOffsetLength() ? vf.sourceLocation(loc.top(), loc.getOffset() + ambLocation.getOffset(), loc.getLength(), loc.getBeginLine() + ambLocation.getBeginLine() - 1, loc.getEndLine() + ambLocation.getEndLine() - 1, loc.getBeginColumn() + ambLocation.getBeginColumn(), loc.getBeginColumn() + ambLocation.getEndColumn()) : loc;
                monitor.warning("ambiguity in concrete syntax", src);
                return (ITree)tree.asWithKeywordParameters().setParameter("parseError", src);
            }
            ISourceLocation loc = TreeAdapter.getLocation(tree);
            monitor.warning("internal error while parsing concrete syntax: " + e.getException(), loc);
            return (ITree)tree.asWithKeywordParameters().setParameter("parseError", loc);
        }
        catch (StaticError e) {
            ISourceLocation loc = TreeAdapter.getLocation(tree);
            ISourceLocation src = vf.sourceLocation(loc.top(), loc.getOffset(), loc.getLength(), loc.getBeginLine(), loc.getEndLine(), loc.getBeginColumn(), loc.getBeginColumn());
            monitor.warning("internal error while parsing concrete syntax: " + e.getMessage(), e.getLocation());
            return (ITree)tree.asWithKeywordParameters().setParameter("can not parse fragment due to " + e.getMessage(), src);
        }
        catch (UndeclaredNonTerminalException e) {
            ISourceLocation loc = TreeAdapter.getLocation(tree);
            ISourceLocation src = vf.sourceLocation(loc.top(), loc.getOffset(), loc.getLength(), loc.getBeginLine(), loc.getEndLine(), loc.getBeginColumn(), loc.getBeginColumn());
            monitor.warning("error while parsing concrete syntax: " + e.getMessage(), src);
            return (ITree)tree.asWithKeywordParameters().setParameter("can not parse fragment due to " + e.getMessage(), src);
        }
    }

    private static char[] replaceAntiQuotesByHoles(RascalFunctionValueFactory vf, ITree lit, Map<String, ITree> antiquotes, SortedMap<Integer, Integer> corrections) {
        IList parts = TreeAdapter.getArgs(lit);
        StringBuilder b = new StringBuilder();
        ISourceLocation loc = TreeAdapter.getLocation(lit);
        int offset = 0;
        int shift = loc.getOffset();
        corrections.put(offset, shift);
        for (IValue elem : parts) {
            ITree part = (ITree)elem;
            String cons = TreeAdapter.getConstructorName(part);
            int partLen = TreeAdapter.getLocation(part).getLength();
            if (cons.equals("text")) {
                offset += partLen;
                b.append(TreeAdapter.yield(part));
                continue;
            }
            if (cons.equals("newline")) {
                corrections.put(++offset, shift += partLen - 1);
                b.append('\n');
                continue;
            }
            if (cons.equals("lt")) {
                corrections.put(++offset, ++shift);
                b.append('<');
                continue;
            }
            if (cons.equals("gt")) {
                corrections.put(++offset, ++shift);
                b.append('>');
                continue;
            }
            if (cons.equals("bq")) {
                corrections.put(++offset, ++shift);
                b.append('`');
                continue;
            }
            if (cons.equals("bs")) {
                corrections.put(++offset, ++shift);
                b.append('\\');
                continue;
            }
            if (!cons.equals("hole")) continue;
            String hole = Import.createHole(vf, part, antiquotes);
            corrections.put(offset += hole.length(), shift += partLen - hole.length());
            b.append(hole);
        }
        return b.toString().toCharArray();
    }

    private static String createHole(RascalFunctionValueFactory vf, ITree part, Map<String, ITree> antiquotes) {
        IString ph = vf.createHole(part, vf.integer(antiquotes.size()));
        antiquotes.put(ph.getValue(), part);
        return ph.getValue();
    }

    private static ITree replaceHolesByAntiQuotes(final IValueFactory vf, ITree fragment, final Map<String, ITree> antiquotes, SortedMap<Integer, Integer> corrections) {
        return fragment.accept(new IdentityTreeVisitor<ImplementationError>(){

            @Override
            public ITree visitTreeAppl(ITree tree) {
                String cons = TreeAdapter.getConstructorName(tree);
                if (cons == null || !cons.equals("$MetaHole")) {
                    IListWriter w = vf.listWriter();
                    IList args = TreeAdapter.getArgs(tree);
                    for (IValue elem : args) {
                        if (!TreeAdapter.isLayout((ITree)elem)) {
                            w.append(elem.accept(this));
                            continue;
                        }
                        w.append(elem);
                    }
                    args = (IList)w.done();
                    return TreeAdapter.setArgs(tree, args);
                }
                IConstructor type = this.retrieveHoleType(tree);
                return (ITree)((ITree)antiquotes.get(TreeAdapter.yield(tree))).asWithKeywordParameters().setParameter("holeType", type).asWithKeywordParameters().setParameter("category", vf.string("MetaVariable"));
            }

            private IConstructor retrieveHoleType(ITree tree) {
                IConstructor prod = TreeAdapter.getProduction(tree);
                ISet attrs = ProductionAdapter.getAttributes(prod);
                for (IValue attr : attrs) {
                    IValue arg;
                    if (((IConstructor)attr).getConstructorType() != RascalValueFactory.Attr_Tag || !(arg = ((IConstructor)attr).get(0)).getType().isNode() || !((INode)arg).getName().equals("holeType")) continue;
                    return (IConstructor)((INode)arg).get(0);
                }
                throw new ImplementationError("expected to find a holeType, but did not: " + tree);
            }

            @Override
            public ITree visitTreeAmb(ITree arg) {
                ISetWriter w = vf.setWriter();
                for (IValue elem : TreeAdapter.getAlternatives(arg)) {
                    w.insert(elem.accept(this));
                }
                return (ITree)arg.set("alternatives", (IValue)w.done());
            }
        });
    }

    private static boolean containsBackTick(char[] data, int offset) {
        for (int i = data.length - 1; i >= offset; --i) {
            if (data[i] != '`') continue;
            return true;
        }
        return false;
    }

    private static boolean needBootstrapParser(char[] input) {
        return new String(input).contains("@bootstrapParser");
    }

    private static class AdjustLocations
    extends IdentityTreeVisitor<ImplementationError> {
        private SortedMap<Integer, Integer> corrections;
        private IValueFactory vf;

        AdjustLocations(SortedMap<Integer, Integer> corrections, IValueFactory vf) {
            this.corrections = corrections;
            this.vf = vf;
        }

        private int offsetFor(int locOffset) {
            if (this.corrections.isEmpty()) {
                return 0;
            }
            int key = -1;
            SortedMap<Integer, Integer> rest = this.corrections.tailMap(locOffset);
            if (rest.isEmpty()) {
                key = this.corrections.lastKey();
                assert (key < locOffset);
            } else if (rest.firstKey() == locOffset) {
                key = locOffset;
            } else {
                assert (rest.firstKey() > locOffset);
                SortedMap<Integer, Integer> front = this.corrections.headMap(rest.firstKey());
                if (front.isEmpty()) {
                    return 0;
                }
                key = front.lastKey();
                assert (key < locOffset);
            }
            int off = (Integer)this.corrections.get(key);
            return off;
        }

        @Override
        public ITree visitTreeAppl(ITree tree) {
            ISourceLocation loc = TreeAdapter.getLocation(tree);
            if (loc == null) {
                return tree;
            }
            int off = this.offsetFor(loc.getOffset());
            loc = this.vf.sourceLocation(loc, loc.getOffset() + off, loc.getLength());
            IListWriter w = this.vf.listWriter();
            IList args = TreeAdapter.getArgs(tree);
            for (IValue arg : args) {
                if (!TreeAdapter.isLayout((ITree)arg)) {
                    w.append(arg.accept(this));
                    continue;
                }
                w.append(arg);
            }
            args = (IList)w.done();
            return TreeAdapter.setLocation(TreeAdapter.setArgs(tree, args), loc);
        }

        @Override
        public ITree visitTreeAmb(ITree arg) throws ImplementationError {
            ((IValue)TreeAdapter.getAlternatives(arg).iterator().next()).accept(this);
            return arg;
        }
    }

    public static class Syntax
    extends Import.Syntax {
        public Syntax(ISourceLocation __param1, IConstructor tree, SyntaxDefinition __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            String parseTreeModName = "ParseTree";
            if (!eval.__getHeap().existsModule(parseTreeModName)) {
                Import.loadModule(this.getLocation(), parseTreeModName, eval);
            }
            Import.addImportToCurrentModule(this.getLocation(), parseTreeModName, eval);
            this.getSyntax().interpret(eval);
            return Syntax.nothing();
        }
    }

    public static class Default
    extends Import.Default {
        public Default(ISourceLocation __param1, IConstructor tree, ImportedModule __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            String name = Names.fullName(this.getModule().getName());
            try {
                Import.importModule(name, this.getLocation(), eval);
            }
            finally {
                eval.setCurrentAST(this);
            }
            return ResultFactory.nothing();
        }
    }

    public static class Extend
    extends Import.Extend {
        public Extend(ISourceLocation src, IConstructor node, ImportedModule module) {
            super(src, node, module);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            String name = Names.fullName(this.getModule().getName());
            Import.extendCurrentModule(this.getLocation(), name, eval);
            return ResultFactory.nothing();
        }
    }

    public static class External
    extends Import.External {
        public External(ISourceLocation src, IConstructor node, QualifiedName name, LocationLiteral at) {
            super(src, node, name, at);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            ISourceLocation sl = (ISourceLocation)this.getAt().interpret(eval).getValue();
            String resourceScheme = sl.getScheme();
            if (resourceScheme.contains("+")) {
                String uriScheme = resourceScheme.substring(resourceScheme.indexOf("+") + 1);
                resourceScheme = resourceScheme.substring(0, resourceScheme.indexOf("+"));
                try {
                    sl = URIUtil.changeScheme(sl, uriScheme);
                }
                catch (URISyntaxException e) {
                    throw RuntimeExceptionFactory.malformedURI(sl.toString().substring(sl.toString().indexOf("+") + 1), null, null);
                }
            }
            String moduleName = Names.fullName(this.getName());
            IString mn = VF.string(moduleName);
            ICallableValue importer = this.getImporter(resourceScheme, eval.getCurrentEnvt());
            if (importer != null) {
                Type[] argTypes = new Type[]{TF.stringType(), TF.sourceLocationType()};
                IValue[] argValues = new IValue[]{mn, sl};
                IValue module = importer.call(argTypes, argValues, null).getValue();
                Object moduleText = module.getType().isString() ? ((IString)module).getValue() : TreeAdapter.yield((IConstructor)module);
                moduleText = "@generated\n" + (String)moduleText;
                try {
                    OutputStream outputStream;
                    URIResolverRegistry reg = URIResolverRegistry.getInstance();
                    String moduleEnvName = eval.getCurrentModuleEnvironment().getName();
                    ISourceLocation ur = null;
                    ur = moduleEnvName.equals("$") ? URIUtil.rootLocation("cwd") : eval.getRascalResolver().getRootForModule(moduleEnvName);
                    Result loc = new SourceLocationResult(TF.sourceLocationType(), ur, (IEvaluatorContext)eval);
                    String modulePath = moduleName.replaceAll("::", "/");
                    loc = loc.add(ResultFactory.makeResult(TF.stringType(), VF.string(modulePath), eval));
                    loc = loc.fieldUpdate("extension", ResultFactory.makeResult(TF.stringType(), VF.string(".rsc"), eval), eval.getCurrentEnvt().getStore());
                    try {
                        outputStream = reg.getOutputStream((ISourceLocation)loc.getValue(), false);
                    }
                    catch (IOException e) {
                        outputStream = reg.getOutputStream(URIUtil.rootLocation("cwd"), false);
                    }
                    if (outputStream == null) {
                        outputStream = reg.getOutputStream(URIUtil.rootLocation("cwd"), false);
                    }
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
                    writer.write((String)moduleText);
                    writer.close();
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.moduleNotFound(mn, eval.getCurrentAST(), eval.getStackTrace());
                }
                Import.importModule(Names.fullName(this.getName()), this.getLocation(), eval);
                return ResultFactory.nothing();
            }
            throw new UndeclaredModuleProvider(resourceScheme, eval.getCurrentAST());
        }

        private ICallableValue getImporter(String s2, Environment currentEnvt) {
            return currentEnvt.getHeap().getResourceImporter(s2);
        }
    }
}

