/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.FactParseError;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import java.io.IOException;
import java.io.StringReader;
import org.rascalmpl.ast.JustTime;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.DateTimeSyntax;

public abstract class JustTime
extends org.rascalmpl.ast.JustTime {
    public JustTime(ISourceLocation __param1, IConstructor tree) {
        super(__param1, tree);
    }

    public static class Lexical
    extends JustTime.Lexical {
        public Lexical(ISourceLocation __param1, IConstructor tree, String __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            String timePart = this.getString().substring(2);
            return this.createVisitedTime(__eval, timePart, this);
        }

        private Result<IValue> createVisitedTime(IEvaluator<Result<IValue>> eval, String timePart, JustTime.Lexical x) {
            try {
                timePart = timePart.replaceAll(":", "");
                StandardTextReader parser = new StandardTextReader();
                IValue result = parser.read(VF, new StringReader("$T" + timePart));
                return Lexical.makeResult(TF.dateTimeType(), result, eval);
            }
            catch (FactTypeUseException e) {
                throw new DateTimeSyntax(e.getMessage(), eval.getCurrentAST().getLocation());
            }
            catch (FactParseError e) {
                throw new DateTimeSyntax(e.getMessage(), eval.getCurrentAST().getLocation());
            }
            catch (IOException e) {
                throw new ImplementationError(e.getMessage());
            }
        }
    }
}

