/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.shell;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.rascalmpl.interpreter.staticErrors.CommandlineError;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.file.MavenRepositoryURIResolver;
import org.rascalmpl.uri.jar.JarURIResolver;
import org.rascalmpl.values.IRascalValueFactory;

public class CommandlineParser {
    private final IValueFactory vf = IRascalValueFactory.getInstance();
    private final TypeFactory tf = TypeFactory.getInstance();
    private final PrintWriter out;

    public CommandlineParser(PrintWriter out) {
        this.out = out;
    }

    public IList parsePlainCommandLineArgs(String[] commandline) {
        IListWriter w = this.vf.listWriter();
        for (String arg : commandline) {
            w.append(this.vf.string(arg));
        }
        return (IList)w.done();
    }

    public Map<String, IValue> parseKeywordCommandLineArgs(String name, String[] commandline, Type kwTypes) {
        HashMap<String, Type> expectedTypes = new HashMap<String, Type>();
        LinkedList<String> pathConfigParam = new LinkedList<String>();
        String pathConfigName = null;
        for (String kwp : kwTypes.getFieldNames()) {
            Type kwtype = kwTypes.getFieldType(kwp);
            if (kwtype == PathConfig.PathConfigType) {
                expectedTypes.putAll(PathConfig.PathConfigFields);
                expectedTypes.put("project", this.tf.sourceLocationType());
                pathConfigParam.add(kwp);
                pathConfigName = kwp;
                continue;
            }
            expectedTypes.put(kwp, kwtype);
        }
        for (String param : pathConfigParam) {
            expectedTypes.remove(param);
        }
        HashMap<String, IValue> params = new HashMap<String, IValue>();
        for (int i = 0; i < commandline.length; ++i) {
            IWriter<IList> writer;
            if (List.of("-help", "--help", "/?", "?", "\\?", "-?", "--?").contains(commandline[i].trim())) {
                this.printMainHelpMessage(kwTypes);
                System.exit(0);
                continue;
            }
            if (!commandline[i].startsWith("-")) continue;
            String label = commandline[i].replaceFirst("^-+", "");
            Type expected = (Type)expectedTypes.get(label);
            if (expected == null) {
                throw new CommandlineError("unknown argument: " + label, kwTypes, name);
            }
            if (expected.isSubtypeOf(this.tf.boolType())) {
                String arg;
                if (i == commandline.length - 1 || commandline[i + 1].startsWith("-")) {
                    params.put(label, this.vf.bool(true));
                    continue;
                }
                if (i >= commandline.length - 1) continue;
                if ((arg = commandline[++i].trim()).equals("1") || arg.equals("true")) {
                    params.put(label, this.vf.bool(true));
                    continue;
                }
                params.put(label, this.vf.bool(false));
                continue;
            }
            if (i == commandline.length - 1 || commandline[i + 1].startsWith("-")) {
                throw new CommandlineError("expected option for " + label, kwTypes, name);
            }
            if (expected.isSubtypeOf(this.tf.listType(this.tf.sourceLocationType()))) {
                if (!commandline[i + 1].startsWith("-") && commandline[i + 1].matches(".*" + File.pathSeparator + "(?!//).*")) {
                    String[] pathElems = commandline[++i].trim().split(File.pathSeparator + "(?!//)");
                    IListWriter writer2 = this.vf.listWriter();
                    Arrays.stream(pathElems).forEach(e -> writer2.append(this.parseCommandlineOption(name, this.tf.sourceLocationType(), (String)e)));
                    params.put(label, (IValue)writer2.done());
                    continue;
                }
                writer = this.vf.listWriter();
                while (i + 1 < commandline.length && !commandline[i + 1].startsWith("-")) {
                    writer.append(this.parseCommandlineOption(name, expected.getElementType(), commandline[++i]));
                }
                params.put(label, (IValue)writer.done());
                continue;
            }
            if (expected.isSubtypeOf(this.tf.listType(this.tf.valueType()))) {
                writer = this.vf.listWriter();
                while (i + 1 < commandline.length && !commandline[i + 1].startsWith("-")) {
                    writer.append(this.parseCommandlineOption(name, expected.getElementType(), commandline[++i]));
                }
                params.put(label, (IValue)writer.done());
                continue;
            }
            if (expected.isSubtypeOf(this.tf.setType(this.tf.valueType()))) {
                writer = this.vf.setWriter();
                while (i + 1 < commandline.length && !commandline[i + 1].startsWith("-")) {
                    writer.insert(this.parseCommandlineOption(name, expected.getElementType(), commandline[++i]));
                }
                params.put(label, writer.done());
                continue;
            }
            params.put(label, this.parseCommandlineOption(name, expected, commandline[++i]));
        }
        if (params.get("project") != null && pathConfigName != null) {
            PathConfig pcfg = PathConfig.fromSourceProjectRascalManifest((ISourceLocation)params.get("project"), PathConfig.RascalConfigMode.INTERPRETER, true);
            IConstructor cons = pcfg.asConstructor();
            for (Map.Entry<String, Type> entry : PathConfig.PathConfigFields.entrySet()) {
                IList param2;
                if (params.get(entry.getKey()) == null) continue;
                if (entry.getValue() == this.tf.sourceLocationType()) {
                    cons = cons.asWithKeywordParameters().setParameter(entry.getKey(), (IValue)params.get(entry.getKey()));
                    continue;
                }
                IList param1 = (IList)cons.asWithKeywordParameters().getParameter(entry.getKey());
                if (param1 == null) {
                    param1 = this.vf.list(new IValue[0]);
                }
                if ((param2 = (IList)params.get(entry.getKey())) == null) {
                    param2 = this.vf.list(new IValue[0]);
                }
                cons = cons.asWithKeywordParameters().setParameter(entry.getKey(), param1.concat(param2));
            }
            params.put(pathConfigName, cons);
        } else if (pathConfigName != null) {
            IConstructor pcfg = new PathConfig().asConstructor();
            for (Map.Entry<String, Type> e2 : PathConfig.PathConfigFields.entrySet()) {
                IValue value = (IValue)params.get(e2.getKey());
                if (value == null) continue;
                pcfg = pcfg.asWithKeywordParameters().setParameter(e2.getKey(), value);
                params.remove(e2.getKey());
            }
            params.put(pathConfigName, pcfg);
        }
        if (pathConfigName != null) {
            IList srcs;
            URIResolverRegistry reg = URIResolverRegistry.getInstance();
            IValue pcfg = (IValue)params.get(pathConfigName);
            IList libs = (IList)pcfg.asWithKeywordParameters().getParameter("libs");
            if (libs != null) {
                libs = libs.stream().map(ISourceLocation.class::cast).map(l -> reg.isDirectory((ISourceLocation)l) ? l : JarURIResolver.jarify(MavenRepositoryURIResolver.mavenize(l))).collect(this.vf.listWriter());
                pcfg = pcfg.asWithKeywordParameters().setParameter("libs", libs);
            }
            if ((srcs = (IList)pcfg.asWithKeywordParameters().getParameter("srcs")) != null) {
                srcs = srcs.stream().map(ISourceLocation.class::cast).map(l -> reg.isDirectory((ISourceLocation)l) ? l : JarURIResolver.jarify(MavenRepositoryURIResolver.mavenize(l))).collect(this.vf.listWriter());
                pcfg = pcfg.asWithKeywordParameters().setParameter("srcs", srcs);
            }
            params.put(pathConfigName, pcfg);
        }
        return params;
    }

    private void printMainHelpMessage(Type kwTypes) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        String mainClass = trace[trace.length - 1].getClassName();
        HashMap<String, Type> fields = new HashMap<String, Type>();
        this.out.println("Help for " + mainClass + "\n");
        for (int i = 0; i < kwTypes.getArity(); ++i) {
            fields.put(kwTypes.getFieldName(i), kwTypes.getFieldType(i));
        }
        if (fields.containsValue(PathConfig.PathConfigType)) {
            fields.putAll(PathConfig.PathConfigFields);
            fields.put("project", this.tf.sourceLocationType());
            List pcfgsKeys = fields.entrySet().stream().filter(e -> e.getValue() == PathConfig.PathConfigType).map(e -> (String)e.getKey()).collect(Collectors.toList());
            pcfgsKeys.stream().forEach(k -> fields.remove(k));
        }
        if (fields.isEmpty()) {
            this.out.println("\t-help    this help message is printed.");
            this.out.println();
            this.out.println("This command has no further parameters.");
            return;
        }
        List keys = fields.keySet().stream().collect(Collectors.toList());
        keys.sort(String::compareTo);
        int maxLength = ((String)keys.stream().max((a, b) -> Integer.compare(a.length(), b.length())).get()).length();
        for (String key : keys) {
            String explanation = this.parameterTypeExplanation(key, (Type)fields.get(key));
            this.out.println("    -" + String.format("%-" + maxLength + "." + key.length() + "s", key) + ": " + explanation);
        }
    }

    private String parameterTypeExplanation(String key, Type type) {
        if (key.equals("help") || key.equals("h") || key.equals("?")) {
            return "this help message is printed.";
        }
        if (type == this.tf.boolType()) {
            return "true or false or nothing";
        }
        if (type == this.tf.stringType()) {
            return "any string value. Use \" or ' to include spaces.";
        }
        if (type == this.tf.sourceLocationType()) {
            return "a path, a URI, or a Rascal source location";
        }
        if (type == this.tf.listType(this.tf.sourceLocationType())) {
            return "a list of paths, URIs or Rascal locs separated by " + File.pathSeparator;
        }
        if (type.isSubtypeOf(this.tf.numberType())) {
            return "a numerical value";
        }
        return "a Rascal value expression of " + type;
    }

    private IValue parseCommandlineOption(String toolName, Type expected, String option) {
        if (expected.isSubtypeOf(this.tf.stringType())) {
            return this.vf.string(option);
        }
        if (expected.isSubtypeOf(this.tf.sourceLocationType())) {
            try {
                if (option.trim().startsWith("|") && option.trim().endsWith("|")) {
                    return (ISourceLocation)new StandardTextReader().read(this.vf, expected, new StringReader(option.trim()));
                }
                if (option.contains("://")) {
                    return URIUtil.createFromURI(option.trim());
                }
                if (option.trim().equals(".")) {
                    return URIUtil.rootLocation("cwd");
                }
                if (option.trim().equals("..")) {
                    return URIUtil.correctLocation("cwd", "", "..");
                }
                if (option.trim().startsWith(".." + File.separatorChar)) {
                    return this.parseCommandlineOption(toolName, expected, System.getProperty("user.dir") + File.separatorChar + option);
                }
                if (option.trim().startsWith("." + File.separatorChar)) {
                    return this.parseCommandlineOption(toolName, expected, System.getProperty("user.dir") + option.substring(1));
                }
                return URIUtil.createFileLocation(option.trim());
            }
            catch (FactTypeUseException e) {
                throw new CommandlineError("expected " + expected + " but got " + option + " (" + e.getMessage() + ")", expected, toolName);
            }
            catch (IOException e) {
                throw new CommandlineError("unxped problem while parsing commandline:" + e.getMessage(), expected, toolName);
            }
            catch (URISyntaxException e) {
                throw new CommandlineError("expected " + expected + " but got " + option + " (" + e.getMessage() + ")", expected, toolName);
            }
        }
        StringReader reader = new StringReader(option);
        try {
            return new StandardTextReader().read(this.vf, expected, reader);
        }
        catch (FactTypeUseException e) {
            throw new CommandlineError("expected " + expected + " but got " + option + " (" + e.getMessage() + ")", expected, toolName);
        }
        catch (IOException e) {
            throw new CommandlineError("unexpected problem while parsing commandline:" + e.getMessage(), expected, toolName);
        }
    }
}

