/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.shell;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jline.terminal.Terminal;
import org.rascalmpl.repl.BaseREPL;
import org.rascalmpl.repl.rascal.RascalInterpreterREPL;
import org.rascalmpl.repl.rascal.RascalReplServices;
import org.rascalmpl.shell.ShellRunner;

public class REPLRunner
implements ShellRunner {
    private final Terminal term;
    private final int remoteIDEServicesPort;

    public REPLRunner(Terminal term) {
        this(term, -1);
    }

    public REPLRunner(Terminal term, int remoteIDEServicesPort) {
        this.term = term;
        this.remoteIDEServicesPort = remoteIDEServicesPort;
    }

    @Override
    public void run(String[] args) throws IOException {
        BaseREPL repl = new BaseREPL(new RascalReplServices(new RascalInterpreterREPL(this.remoteIDEServicesPort), REPLRunner.getHistoryFile()), this.term);
        repl.run();
    }

    private static Path getHistoryFile() throws IOException {
        Path home = FileSystems.getDefault().getPath(System.getProperty("user.home"), new String[0]);
        Path rascalDir = home.resolve(".rascal");
        if (!Files.isDirectory(rascalDir, new LinkOption[0])) {
            Files.createDirectories(rascalDir, new FileAttribute[0]);
        }
        return rascalDir.resolve(".repl-history-rascal-terminal-jline3");
    }
}

