/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.tasks.facts;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.rascalmpl.tasks.IDependencyListener;
import org.rascalmpl.tasks.IExpirationListener;
import org.rascalmpl.tasks.IFact;
import org.rascalmpl.tasks.facts.IRef;
import org.rascalmpl.tasks.facts.SoftRef;
import org.rascalmpl.tasks.facts.WeakRef;

public abstract class AbstractFact<V>
implements IFact<V> {
    static final ReferenceQueue<Object> queue = new ReferenceQueue();
    protected V value = null;
    private IRef<V> valueRef = null;
    protected int status = 2;
    protected final Set<IDependencyListener> listeners = new HashSet<IDependencyListener>();
    protected final Set<IFact<?>> dependencies = new HashSet();
    protected final Object key;
    protected final String keyName;
    protected IExpirationListener<V> exp;

    protected AbstractFact(Object key, String keyName, IExpirationListener<V> exp) {
        this.key = key;
        this.keyName = keyName;
        this.exp = exp;
    }

    @Override
    public boolean isValid() {
        return this.status == 0;
    }

    @Override
    public void registerListener(IDependencyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(IDependencyListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void remove() {
        for (IDependencyListener iDependencyListener : this.listeners) {
            iDependencyListener.changed(this, IDependencyListener.Change.REMOVED, null);
        }
        this.listeners.clear();
        for (IFact iFact : this.dependencies) {
            iFact.unregisterListener(this);
        }
        this.dependencies.clear();
        this.value = null;
        this.clearRef();
    }

    protected void notifyInvalidated() {
        for (IDependencyListener f : this.listeners) {
            f.changed(this, IDependencyListener.Change.INVALIDATED, null);
        }
    }

    protected void notifyChanged() {
        for (IDependencyListener f : this.listeners) {
            f.changed(this, IDependencyListener.Change.CHANGED, null);
        }
    }

    protected void notifyAvailable() {
        for (IDependencyListener f : this.listeners) {
            f.changed(this, IDependencyListener.Change.AVAILABLE, null);
        }
    }

    @Override
    public Collection<IDependencyListener> getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    public String toString() {
        return this.keyName;
    }

    @Override
    public synchronized void setDepends(Collection<IFact<V>> deps) {
        for (IFact<?> iFact : this.dependencies) {
            if (deps.contains(iFact)) continue;
            iFact.unregisterListener(this);
        }
        for (IFact<Object> iFact : deps) {
            if (this.dependencies.contains(iFact)) continue;
            iFact.registerListener(this);
        }
        this.dependencies.clear();
        this.dependencies.addAll(deps);
    }

    @Override
    public synchronized Collection<IFact<?>> getDepends() {
        return Collections.unmodifiableCollection(this.dependencies);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public synchronized void expire() {
        if (this.status != 0) {
            if (this.exp != null) {
                this.exp.expire(this.key);
            }
            for (IDependencyListener iDependencyListener : this.listeners) {
                iDependencyListener.changed(this, IDependencyListener.Change.EXPIRED, null);
            }
            this.listeners.clear();
            for (IFact iFact : this.dependencies) {
                iFact.unregisterListener(this);
            }
            this.dependencies.clear();
            this.value = null;
            this.clearRef();
        } else {
            this.valueRef = null;
        }
    }

    protected void setRefWeak(V value) {
        this.valueRef = new WeakRef<V>(value, this);
    }

    protected void setRefSoft(V value) {
        this.valueRef = new SoftRef<V>(value, this);
    }

    protected void clearRef() {
        if (this.valueRef != null) {
            this.valueRef.clear();
            this.valueRef = null;
        }
    }

    protected V getRef() {
        if (this.valueRef != null) {
            return this.valueRef.get();
        }
        return null;
    }

    public static void pruneExpired() {
        Reference<Object> o = queue.poll();
        while (o != null) {
            AbstractFact fact = ((IRef)((Object)o)).getFact();
            fact.expire();
            o = queue.poll();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
        result = 31 * result + this.status;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.valueRef == null ? 0 : this.valueRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFact other = (AbstractFact)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.valueRef == null ? other.valueRef != null : !this.valueRef.equals(other.valueRef));
    }
}

