/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.test.infrastructure;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.rascalmpl.test.infrastructure.RascalJUnitTestPrefix;
import org.rascalmpl.test.infrastructure.RecursiveJavaOnlyTest;
import org.rascalmpl.test.infrastructure.RecursiveRascalParallelTest;
import org.rascalmpl.test.infrastructure.RecursiveTest;

public class RecursiveTestSuite
extends Suite {
    public RecursiveTestSuite(Class<?> setupClass) throws InitializationError {
        super(setupClass, RecursiveTestSuite.getClasses(setupClass));
    }

    private static Class<?>[] getClasses(Class<?> setupClass) {
        String[] directories;
        ArrayList result = new ArrayList();
        if (setupClass.isAnnotationPresent(RecursiveTest.class)) {
            directories = setupClass.getAnnotation(RecursiveTest.class).value();
            RecursiveTestSuite.addClassesFromDirectories(setupClass, result, directories, true);
        }
        if (setupClass.isAnnotationPresent(RecursiveJavaOnlyTest.class)) {
            directories = setupClass.getAnnotation(RecursiveJavaOnlyTest.class).value();
            RecursiveTestSuite.addClassesFromDirectories(setupClass, result, directories, false);
        }
        return result.toArray(new Class[0]);
    }

    private static void addClassesFromDirectories(Class<?> setupClass, List<Class<?>> result, String[] directories, boolean includeRascalTests) {
        String packageName = setupClass.getPackage().getName();
        Object path = setupClass.getProtectionDomain().getCodeSource().getLocation().getFile();
        path = (String)path + packageName.replace('.', File.separatorChar);
        for (String dir : directories) {
            RecursiveTestSuite.findTestClasses(setupClass.getPackage(), new File((String)path + File.separatorChar + dir), includeRascalTests, result);
        }
    }

    private static void findTestClasses(Package root, File path, boolean includeRascalTests, List<Class<?>> result) {
        block2: for (File f : path.listFiles()) {
            if (f.isDirectory()) {
                RecursiveTestSuite.findTestClasses(root, f, includeRascalTests, result);
                continue;
            }
            if (!f.getName().endsWith(".class")) continue;
            Object className = f.getName().substring(0, f.getName().length() - 6);
            className = path.getPath().replace(File.separatorChar, '.') + "." + (String)className;
            className = ((String)className).substring(((String)className).indexOf(root.getName()));
            try {
                Class<?> currentClass = Class.forName((String)className);
                if (currentClass.isAnnotationPresent(RascalJUnitTestPrefix.class) || currentClass.isAnnotationPresent(RecursiveRascalParallelTest.class)) {
                    if (!includeRascalTests) continue;
                    result.add(currentClass);
                    continue;
                }
                for (Method m4 : currentClass.getMethods()) {
                    if (!m4.isAnnotationPresent(Test.class)) continue;
                    result.add(currentClass);
                    continue block2;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

