/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.test.infrastructure;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.TypeFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.env.GlobalEnvironment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.StaticError;
import org.rascalmpl.shell.ShellEvaluatorFactory;
import org.rascalmpl.test.infrastructure.RascalJUnitTestRunner;
import org.rascalmpl.test.infrastructure.RascalJunitConsoleMonitor;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.ValueFactoryFactory;

public class TestFramework {
    private static final Evaluator evaluator;
    private static final GlobalEnvironment heap;
    private static final ModuleEnvironment root;
    private static final PrintWriter stderr;
    private static final PrintWriter stdout;
    private static final String ROOT_TEST_ENVIRONMENT = "___test___";
    private Set<ISourceLocation> generatedModules = new HashSet<ISourceLocation>();

    private void reset() {
        heap.clear();
        root.reset();
        for (ISourceLocation mod : this.generatedModules) {
            try {
                URIResolverRegistry.getInstance().remove(mod, true);
            }
            catch (IOException iOException) {}
        }
        this.generatedModules.clear();
        evaluator.getAccumulators().clear();
    }

    @After
    public void assureEvaluatorIsSane() {
        Assert.assertTrue(evaluator.getCurrentEnvt().isRootScope());
        Assert.assertTrue(evaluator.getCurrentEnvt().isRootStackFrame());
        Assert.assertTrue("When we are at the root scope and stack frame, the accumulators should be empty as well", evaluator.getAccumulators().empty());
    }

    public boolean runTest(String command) {
        this.reset();
        return this.execute(command);
    }

    public boolean runRascalTests(String command) {
        try {
            this.reset();
            this.execute(command);
            boolean bl = evaluator.runTests(evaluator.getMonitor(), Optional.empty());
            return bl;
        }
        finally {
            stderr.flush();
            stdout.flush();
        }
    }

    public boolean runTestInSameEvaluator(String command) {
        return this.execute(command);
    }

    public boolean runTest(String command1, String command2) {
        this.reset();
        this.execute(command1);
        return this.execute(command2);
    }

    public TestFramework prepare(String command) {
        try {
            this.reset();
            this.execute(command);
        }
        catch (StaticError e) {
            throw e;
        }
        catch (Exception e) {
            System.err.println("Unhandled exception while preparing test: " + e);
            throw new AssertionError((Object)e.getMessage());
        }
        return this;
    }

    public TestFramework prepareMore(String command) {
        try {
            this.execute(command);
        }
        catch (StaticError e) {
            throw e;
        }
        catch (Exception e) {
            System.err.println("Unhandled exception while preparing test: " + e);
            throw new AssertionError((Object)e.getMessage());
        }
        return this;
    }

    public boolean prepareModule(String name, String module) throws FactTypeUseException {
        this.reset();
        try {
            ISourceLocation moduleLoc = ValueFactoryFactory.getValueFactory().sourceLocation("memory", "test-modules", "/" + name.replace("::", "/") + ".rsc");
            this.generatedModules.add(moduleLoc);
            try (OutputStream target = URIResolverRegistry.getInstance().getOutputStream(moduleLoc, false);){
                target.write(module.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean execute(String command) {
        Result<IValue> result = evaluator.eval(null, command, URIUtil.rootLocation("stdin"));
        if (result.getStaticType().isBottom()) {
            return true;
        }
        if (result.getValue() == null) {
            return false;
        }
        if (result.getStaticType() == TypeFactory.getInstance().boolType()) {
            return ((IBool)result.getValue()).getValue();
        }
        return false;
    }

    static {
        ISourceLocation projectLoc = RascalJUnitTestRunner.inferProjectRootFromClass(TestFramework.class);
        if (projectLoc == null) {
            projectLoc = URIUtil.rootLocation("cwd");
        }
        evaluator = ShellEvaluatorFactory.getDefaultEvaluatorForLocation(projectLoc, Reader.nullReader(), new PrintWriter(System.err, true), new PrintWriter(System.out, false), RascalJunitConsoleMonitor.getInstance(), ROOT_TEST_ENVIRONMENT);
        heap = evaluator.getHeap();
        root = heap.getModule(ROOT_TEST_ENVIRONMENT);
        stdout = evaluator.getOutPrinter();
        stderr = evaluator.getErrorPrinter();
        try {
            assert (false);
            throw new RuntimeException("Make sure you enable the assert statement in your run configuration ( add -ea )");
        }
        catch (AssertionError assertionError) {
            return;
        }
    }
}

