/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.util.function.Consumer;

public interface ISourceLocationWatcher {
    public String scheme();

    public void watch(ISourceLocation var1, Consumer<ISourceLocationChanged> var2, boolean var3) throws IOException;

    public void unwatch(ISourceLocation var1, Consumer<ISourceLocationChanged> var2, boolean var3) throws IOException;

    public boolean supportsRecursiveWatch();

    public static ISourceLocationChanged created(ISourceLocation loc) {
        return ISourceLocationWatcher.makeChange(loc, ISourceLocationChangeType.CREATED);
    }

    public static ISourceLocationChanged deleted(ISourceLocation loc) {
        return ISourceLocationWatcher.makeChange(loc, ISourceLocationChangeType.DELETED);
    }

    public static ISourceLocationChanged modified(ISourceLocation loc) {
        return ISourceLocationWatcher.makeChange(loc, ISourceLocationChangeType.MODIFIED);
    }

    public static ISourceLocationChanged makeChange(final ISourceLocation loc, final ISourceLocationChangeType changeType) {
        return new ISourceLocationChanged(){

            @Override
            public ISourceLocationChangeType getChangeType() {
                return changeType;
            }

            @Override
            public ISourceLocation getLocation() {
                return loc;
            }
        };
    }

    public static enum ISourceLocationChangeType {
        CREATED,
        DELETED,
        MODIFIED;

    }

    public static interface ISourceLocationChanged {
        public ISourceLocation getLocation();

        public ISourceLocationChangeType getChangeType();

        default public boolean isCreated() {
            return this.getChangeType() == ISourceLocationChangeType.CREATED;
        }

        default public boolean isDeleted() {
            return this.getChangeType() == ISourceLocationChangeType.DELETED;
        }

        default public boolean isChanged() {
            return this.getChangeType() == ISourceLocationChangeType.MODIFIED;
        }
    }
}

