/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkDetector {
    private static final Pattern findLinks = Pattern.compile("(\\[[^\\]]*\\]\\((?<markdown>[^\\)]*)\\))|(?<sourceLocation>\\|[^\\t-\\n\\r\\s\\|]*://[^\\t-\\n\\r\\s\\|]*\\|(?:\\([^\\)]*\\))?)");

    public static Type typeOf(String link) {
        return link.startsWith("|") ? Type.SOURCE_LOCATION : Type.HYPERLINK;
    }

    public static String findAt(String input, int offset) {
        if (input == null || 0 > offset || offset > input.length()) {
            return null;
        }
        Matcher m4 = findLinks.matcher(input);
        while (m4.find()) {
            if (m4.start() > offset) {
                return null;
            }
            if (m4.end() < offset) continue;
            return m4.group("markdown") != null ? m4.group("markdown") : m4.group("sourceLocation");
        }
        return null;
    }

    public static enum Type {
        SOURCE_LOCATION,
        HYPERLINK;

    }
}

