/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkifiedString {
    private List<Integer> linkOffsets;
    private List<Integer> linkLengths;
    private List<String> linkTargets;
    private String linkedString;
    private static final Pattern findLinks = Pattern.compile("(?:\\uE007\\[([^\\]]*)\\]\\(([^\\)]*)\\))|(\\|[^\\t-\\n\\r\\s\\|]*://[^\\t-\\n\\r\\s\\|]*\\|(?:\\([^\\)]*\\))?)");

    public String getString() {
        return this.linkedString;
    }

    public boolean containsLinks() {
        return this.linkOffsets != null && this.linkOffsets.size() > 0;
    }

    public int linkCount() {
        return this.linkOffsets == null ? 0 : this.linkOffsets.size();
    }

    public int linkOffset(int index) {
        if (this.linkOffsets == null) {
            throw new IllegalStateException("There are no links");
        }
        return this.linkOffsets.get(index);
    }

    public int linkLength(int index) {
        if (this.linkLengths == null) {
            throw new IllegalStateException("There are no links");
        }
        return this.linkLengths.get(index);
    }

    public String linkTarget(int index) {
        if (this.linkTargets == null) {
            throw new IllegalStateException("There are no links");
        }
        return this.linkTargets.get(index);
    }

    public LinkifiedString(String input) {
        this.linkedString = input;
        StringBuffer sb = null;
        Matcher m4 = findLinks.matcher(input);
        while (m4.find()) {
            if (this.linkOffsets == null) {
                this.linkOffsets = new ArrayList<Integer>();
                this.linkLengths = new ArrayList<Integer>();
                this.linkTargets = new ArrayList<String>();
            }
            if (m4.group(3) == null) {
                if (sb == null) {
                    sb = new StringBuffer(input.length());
                }
                String name = "\u261e " + m4.group(1);
                String url = m4.group(2);
                this.linkTargets.add(url);
                m4.appendReplacement(sb, LinkifiedString.escapeReplacement(name));
                this.linkOffsets.add(sb.length() - name.length() + 1);
                this.linkLengths.add(name.length());
                continue;
            }
            String loc = m4.group(3);
            this.linkTargets.add(loc);
            if (sb != null) {
                m4.appendReplacement(sb, LinkifiedString.escapeReplacement(loc));
                this.linkOffsets.add(sb.length() - loc.length() + 1);
            } else {
                this.linkOffsets.add(m4.start() + 1);
            }
            this.linkLengths.add(loc.length());
        }
        if (sb != null) {
            m4.appendTail(sb);
            this.linkedString = sb.toString();
        }
    }

    private static String escapeReplacement(String replacement) {
        if (replacement.length() < 20) {
            return replacement.replace("\\", "\\\\").replace("$", "\\$");
        }
        int stringLength = replacement.length();
        StringBuilder sb = new StringBuilder(stringLength);
        for (int currentChar = 0; currentChar < stringLength; ++currentChar) {
            char c = replacement.charAt(currentChar);
            if (c == '\\') {
                sb.append('\\');
            } else if (c == '$') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String getLinkAt(int offset) {
        if (!this.containsLinks()) {
            return null;
        }
        for (int i = 0; i < this.linkOffsets.size() && this.linkOffsets.get(i) <= offset; ++i) {
            if (this.linkOffsets.get(i) + this.linkLengths.get(i) < offset) continue;
            return this.linkTargets.get(i);
        }
        return null;
    }
}

