/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.uri.ILogicalSourceLocationResolver;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.jar.JarURIResolver;

public class StandardLibraryURIResolver
implements ILogicalSourceLocationResolver {
    private static final ISourceLocation currentRascalJar = URIUtil.getChildLocation(JarURIResolver.jarify(StandardLibraryURIResolver.resolveCurrentRascalJar()), "org/rascalmpl/library");

    private static ISourceLocation resolveCurrentRascalJar() {
        try {
            return PathConfig.resolveCurrentRascalRuntimeJar();
        }
        catch (IOException e) {
            return URIUtil.unknownLocation();
        }
    }

    @Override
    public ISourceLocation resolve(ISourceLocation input) throws IOException {
        return URIUtil.getChildLocation(currentRascalJar, input.getPath());
    }

    @Override
    public String scheme() {
        return "std";
    }

    @Override
    public String authority() {
        return "";
    }

    public static ISourceLocation getDebugBootstrapLocation() {
        return currentRascalJar;
    }
}

