/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.classloaders;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.rascalmpl.uri.URIResolverRegistry;

public class SourceLocationClassLoader
extends ClassLoader {
    private final Map<String, Class<?>> cache = new ConcurrentHashMap();
    private final List<ClassLoader> path;
    private final Stack<SearchItem> stack = new Stack();

    public SourceLocationClassLoader(IList classpath, ClassLoader parent) {
        super(parent);
        this.path = this.initialize(classpath);
    }

    public SourceLocationClassLoader(List<ISourceLocation> classpath, ClassLoader parent) {
        super(parent);
        this.path = this.initialize(classpath);
    }

    private List<ClassLoader> initialize(Iterable<? extends IValue> locs) {
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        ArrayList<URL> fileLocations = new ArrayList<URL>(10);
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>(10);
        for (IValue iValue : locs) {
            try {
                ISourceLocation loc = reg.logicalToPhysical((ISourceLocation)iValue);
                ClassLoader loader = reg.getClassLoader(loc, this);
                if (loader instanceof URLClassLoader) {
                    for (URL url : ((URLClassLoader)loader).getURLs()) {
                        fileLocations.add(url);
                    }
                    continue;
                }
                result.add(loader);
            }
            catch (IOException iOException) {}
        }
        if (!fileLocations.isEmpty()) {
            result.add(new URLClassLoader(fileLocations.toArray(new URL[0]), (ClassLoader)this));
        }
        return result;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class cached = this.cache.computeIfAbsent(name, n -> {
            String fileName = n.replace('.', '/') + ".class";
            for (ClassLoader l : this.path) {
                Class<?> clazz;
                block11: {
                    InputStream stream;
                    block10: {
                        stream = l.getResourceAsStream(fileName);
                        try {
                            if (stream != null) break block10;
                            if (stream == null) continue;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        stream.close();
                        continue;
                    }
                    clazz = this.defineClass((String)n, ByteBuffer.wrap(stream.readAllBytes()), null);
                    if (stream == null) break block11;
                    stream.close();
                }
                return clazz;
            }
            return null;
        });
        if (cached == null) {
            throw new ClassNotFoundException(name);
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        URL parent = super.getResource(name);
        if (parent != null) {
            return parent;
        }
        if (this.stack.contains(new SearchItem(this, name))) {
            return null;
        }
        for (ClassLoader l : this.path) {
            try {
                this.stack.push(new SearchItem(this, name));
                URL url = l.getResource(name);
                if (url == null) continue;
                URL uRL = url;
                return uRL;
            }
            finally {
                this.stack.pop();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>(this.path.size());
        result.addAll(Collections.list(super.getResources(name)));
        for (ClassLoader l : this.path) {
            SearchItem item = new SearchItem(l, name);
            if (this.stack.contains(item)) continue;
            try {
                this.stack.push(item);
                result.addAll(Collections.list(l.getResources(name)));
            }
            finally {
                this.stack.pop();
            }
        }
        return Collections.enumeration(result);
    }

    private static class SearchItem {
        private final ClassLoader loader;
        private final String className;

        public SearchItem(ClassLoader loader, String className) {
            this.loader = loader;
            this.className = className;
        }

        public boolean equals(Object obj) {
            if (obj.getClass().equals(this.getClass())) {
                SearchItem other = (SearchItem)obj;
                return other.loader == this.loader && other.className.equals(this.className);
            }
            return false;
        }

        public int hashCode() {
            return 17 + 7 * this.loader.hashCode() + 19 * this.className.hashCode();
        }
    }
}

