/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.file;

import io.usethesource.vallang.ISourceLocation;
import java.io.File;
import java.util.Arrays;
import org.rascalmpl.uri.ILogicalSourceLocationResolver;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.file.FileURIResolver;

public class SystemPathURIResolver
implements ILogicalSourceLocationResolver {
    @Override
    public String scheme() {
        return "PATH";
    }

    @Override
    public ISourceLocation resolve(ISourceLocation input) {
        String thePath = System.getenv("PATH");
        if (thePath == null) {
            return input;
        }
        return Arrays.stream(thePath.split(File.pathSeparator)).map(FileURIResolver::constructFileURI).map(r -> URIUtil.getChildLocation(r, input.getPath())).filter(URIResolverRegistry.getInstance()::exists).findFirst().orElse(input);
    }

    @Override
    public String authority() {
        return "";
    }
}

