/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.libraries;

import io.usethesource.vallang.ISourceLocation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import org.rascalmpl.uri.ISourceLocationInput;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.classloaders.IClassloaderLocationResolver;
import org.rascalmpl.values.ValueFactoryFactory;

public abstract class ClassResourceInput
implements ISourceLocationInput,
IClassloaderLocationResolver {
    protected final Class<?> clazz;
    protected final String scheme;
    protected final String prefix;

    public ClassResourceInput(String scheme, Class<?> clazz, String prefix) {
        this.clazz = clazz;
        this.scheme = scheme;
        this.prefix = this.normalizePrefix(prefix);
    }

    private String normalizePrefix(String prefix) {
        if (!((String)prefix).startsWith("/")) {
            prefix = "/" + (String)prefix;
        }
        while (((String)prefix).endsWith("/") && ((String)prefix).length() > 1) {
            prefix = ((String)prefix).substring(0, ((String)prefix).length() - 2);
        }
        return prefix;
    }

    protected String getPath(ISourceLocation uri) {
        String path = uri.getPath();
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.contains("//")) {
            path = path.replaceAll("//", "/");
        }
        return this.prefix + (this.prefix.endsWith("/") ? "" : "/") + path;
    }

    @Override
    public boolean exists(ISourceLocation uri) {
        return this.clazz.getResource(this.getPath(uri)) != null;
    }

    @Override
    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        InputStream resourceAsStream = this.clazz.getResourceAsStream(this.getPath(uri));
        if (resourceAsStream != null) {
            return resourceAsStream;
        }
        throw new FileNotFoundException(uri.toString());
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public boolean isDirectory(ISourceLocation uri) {
        try {
            return URIResolverRegistry.getInstance().isDirectory(this.resolve(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isFile(ISourceLocation uri) {
        try {
            return URIResolverRegistry.getInstance().isFile(this.resolve(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    protected ISourceLocation resolve(ISourceLocation uri) throws IOException {
        try {
            URL res = this.clazz.getResource(this.getPath(uri));
            if (res == null) {
                throw new FileNotFoundException(this.getPath(uri));
            }
            if (res.getProtocol().equals("jar") && res.getPath().startsWith("file:/")) {
                return ValueFactoryFactory.getValueFactory().sourceLocation("jar", null, res.getPath().substring("file:".length()));
            }
            return ValueFactoryFactory.getValueFactory().sourceLocation(URIUtil.fromURL(res));
        }
        catch (URISyntaxException e) {
            assert (false);
            throw new IOException(e);
        }
    }

    @Override
    public long lastModified(ISourceLocation uri) throws IOException {
        return URIResolverRegistry.getInstance().lastModified(this.resolve(uri));
    }

    @Override
    public String[] list(ISourceLocation uri) throws IOException {
        return URIResolverRegistry.getInstance().listEntries(this.resolve(uri));
    }

    @Override
    public boolean supportsHost() {
        return false;
    }

    @Override
    public Charset getCharset(ISourceLocation uri) throws IOException {
        return URIResolverRegistry.getInstance().getCharset(this.resolve(uri));
    }

    @Override
    public ClassLoader getClassLoader(ISourceLocation loc, ClassLoader parent) throws IOException {
        assert (loc.getScheme().equals(this.scheme()));
        return this.clazz.getClassLoader();
    }
}

