/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.project;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.util.function.Function;
import org.rascalmpl.uri.ILogicalSourceLocationResolver;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;

public class IDETargetURIResolver
implements ILogicalSourceLocationResolver {
    private final Function<ISourceLocation, ISourceLocation> resolver;

    public IDETargetURIResolver(Function<ISourceLocation, ISourceLocation> resolver) {
        this.resolver = resolver;
    }

    @Override
    public ISourceLocation resolve(ISourceLocation input) throws IOException {
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        ISourceLocation projectLoc = URIUtil.correctLocation("project", input.getAuthority(), "");
        ISourceLocation resolved = this.resolver.apply(projectLoc);
        ISourceLocation bin = URIUtil.getChildLocation(resolved, "bin");
        ISourceLocation targetClasses = URIUtil.getChildLocation(resolved, "target/classes");
        if (reg.exists(bin) && !reg.exists(targetClasses)) {
            return URIUtil.getChildLocation(bin, input.getPath());
        }
        if (reg.exists(targetClasses)) {
            return URIUtil.getChildLocation(targetClasses, input.getPath());
        }
        if (reg.exists(URIUtil.getChildLocation(resolved, "pom.xml"))) {
            return URIUtil.getChildLocation(targetClasses, input.getPath());
        }
        return URIUtil.getChildLocation(bin, input.getPath());
    }

    @Override
    public String scheme() {
        return "target";
    }

    @Override
    public String authority() {
        return "";
    }
}

