/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.remote;

import io.usethesource.vallang.ISourceLocation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import org.rascalmpl.uri.FileAttributes;
import org.rascalmpl.uri.ISourceLocationInput;

public class HttpURIResolver
implements ISourceLocationInput {
    private final HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).followRedirects(HttpClient.Redirect.NORMAL).build();

    @Override
    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        try {
            HttpResponse<InputStream> response = this.httpClient.send(HttpRequest.newBuilder(uri.getURI()).GET().build(), HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() >= 400) {
                throw new FileNotFoundException(uri + " does not exist, server replied: " + response.statusCode());
            }
            return response.body();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return InputStream.nullInputStream();
        }
    }

    @Override
    public String scheme() {
        return "http";
    }

    @Override
    public boolean exists(ISourceLocation uri) {
        try {
            this.sendHeadRequest(uri);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isDirectory(ISourceLocation uri) {
        return false;
    }

    @Override
    public boolean isFile(ISourceLocation uri) {
        return true;
    }

    @Override
    public long lastModified(ISourceLocation uri) {
        try {
            return this.extractLastModified(this.sendHeadRequest(uri));
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public long size(ISourceLocation uri) throws IOException {
        try {
            return this.extractSize(this.sendHeadRequest(uri));
        }
        catch (IOException e) {
            return 0L;
        }
    }

    private long extractLastModified(HttpHeaders headers) {
        return headers.firstValueAsLong("Last-Modified").orElse(Instant.now().toEpochMilli());
    }

    private long extractSize(HttpHeaders headers) {
        return headers.firstValueAsLong("Content-Length").orElse(0L);
    }

    @Override
    public String[] list(ISourceLocation uri) {
        return new String[0];
    }

    @Override
    public boolean supportsHost() {
        return true;
    }

    @Override
    public Charset getCharset(ISourceLocation uri) throws IOException {
        try {
            String encoding = this.sendHeadRequest(uri).firstValue("Content-Encoding").orElse(null);
            if (encoding != null && Charset.isSupported(encoding)) {
                return Charset.forName(encoding);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean isReadable(ISourceLocation uri) throws IOException {
        if (this.exists(uri)) {
            return true;
        }
        throw new FileNotFoundException(uri.toString());
    }

    @Override
    public FileAttributes stat(ISourceLocation loc) throws IOException {
        HttpHeaders headers = this.sendHeadRequest(loc);
        return new FileAttributes(true, true, this.extractLastModified(headers), this.extractLastModified(headers), true, false, this.extractSize(headers));
    }

    private HttpHeaders sendHeadRequest(ISourceLocation loc) throws IOException {
        try {
            HttpRequest req = HttpRequest.newBuilder(loc.getURI()).method("HEAD", HttpRequest.BodyPublishers.noBody()).header("Accept-Encoding", "identity").build();
            HttpResponse<Void> resp = this.httpClient.send(req, HttpResponse.BodyHandlers.discarding());
            if (resp.statusCode() != 200) {
                throw new FileNotFoundException(loc + " does not exist, server replied: " + resp.statusCode());
            }
            return resp.headers();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return HttpHeaders.of(Collections.emptyMap(), (a, b) -> false);
        }
    }
}

