/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.watch;

import io.usethesource.vallang.ISourceLocation;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.rascalmpl.uri.ISourceLocationWatcher;
import org.rascalmpl.uri.URIResolverRegistry;

public class SimulatedRecursiveWatcher
implements Closeable {
    private volatile boolean closed = false;
    private final ISourceLocationWatcher nativeWatcher;
    private final List<Consumer<ISourceLocationWatcher.ISourceLocationChanged>> subscriptions = new CopyOnWriteArrayList<Consumer<ISourceLocationWatcher.ISourceLocationChanged>>();
    private final Set<ISourceLocation> activeWatches = ConcurrentHashMap.newKeySet();
    private final Executor exec;

    public SimulatedRecursiveWatcher(ISourceLocation rootLocation, Consumer<ISourceLocationWatcher.ISourceLocationChanged> initialConsumer, ISourceLocationWatcher nativeWatcher, Executor exec) {
        this.nativeWatcher = nativeWatcher;
        this.exec = exec;
        this.subscriptions.add(initialConsumer);
        try {
            nativeWatcher.watch(rootLocation, this::handler, false);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.registerChildWatches(rootLocation);
    }

    private void handler(ISourceLocationWatcher.ISourceLocationChanged event) {
        if (this.closed) {
            return;
        }
        for (Consumer<ISourceLocationWatcher.ISourceLocationChanged> s2 : this.subscriptions) {
            this.exec.execute(() -> s2.accept(event));
        }
        ISourceLocation loc = event.getLocation();
        if (event.isCreated() && URIResolverRegistry.getInstance().isDirectory(loc)) {
            this.registerChildWatches(loc);
        } else if (event.isDeleted() && this.activeWatches.contains(loc)) {
            try {
                this.activeWatches.remove(loc);
                this.nativeWatcher.unwatch(loc, this::handler, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void registerChildWatches(ISourceLocation loc) {
        if (this.closed) {
            return;
        }
        this.exec.execute(() -> {
            URIResolverRegistry reg = URIResolverRegistry.getInstance();
            ArrayDeque<ISourceLocation> todo = new ArrayDeque<ISourceLocation>();
            todo.push(loc);
            while (!todo.isEmpty()) {
                ISourceLocation current = (ISourceLocation)todo.pop();
                if (this.activeWatches.contains(current)) continue;
                try {
                    this.nativeWatcher.watch(current, this::handler, false);
                    this.activeWatches.add(current);
                    for (ISourceLocation e : reg.list(current)) {
                        if (!reg.isDirectory(e)) continue;
                        todo.push(e);
                    }
                }
                catch (IOException iOException) {
                }
            }
        });
    }

    public void add(Consumer<ISourceLocationWatcher.ISourceLocationChanged> c) {
        this.subscriptions.add(c);
    }

    public void remove(Consumer<ISourceLocationWatcher.ISourceLocationChanged> c) {
        this.subscriptions.remove(c);
    }

    public boolean isEmpty() {
        return this.subscriptions.isEmpty();
    }

    public SimulatedRecursiveWatcher merge(SimulatedRecursiveWatcher b) {
        this.subscriptions.addAll(b.subscriptions);
        try {
            b.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public void close() {
        this.closed = true;
        for (ISourceLocation a : this.activeWatches) {
            try {
                this.nativeWatcher.unwatch(a, this::handler, false);
            }
            catch (IOException iOException) {}
        }
        this.activeWatches.clear();
    }
}

