/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.watch;

import engineering.swat.watch.DaemonThreadPool;
import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.uri.ISourceLocationWatcher;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.watch.SimulatedRecursiveWatcher;

public class WatchRegistry {
    private final Map<String, ISourceLocationWatcher> watchers = new ConcurrentHashMap<String, ISourceLocationWatcher>();
    private final Map<ISourceLocation, SimulatedRecursiveWatcher> simulatedRecursiveWatchers = new ConcurrentHashMap<ISourceLocation, SimulatedRecursiveWatcher>();
    private final NavigableMap<ISourceLocation, Set<SimulatedWatchEntry>> internalWatchers = new ConcurrentSkipListMap<ISourceLocation, Set<SimulatedWatchEntry>>(WatchRegistry.makeISourceLocationComparator());
    private final Map<WatchKey, KeyedWeakReference> wrappedHandlers = new ConcurrentHashMap<WatchKey, KeyedWeakReference>();
    private final URIResolverRegistry reg;
    public final ReferenceQueue<? super Consumer<ISourceLocationWatcher.ISourceLocationChanged>> clearedReferences = new ReferenceQueue();
    private final UnaryOperator<ISourceLocation> resolver;
    private volatile @Nullable ISourceLocationWatcher fallback;
    private final ExecutorService exec = DaemonThreadPool.buildConstrainedCached("simulated-watches", Math.max(2, Math.min(6, Runtime.getRuntime().availableProcessors() - 2)));

    public WatchRegistry(URIResolverRegistry reg, UnaryOperator<ISourceLocation> resolver) {
        this.reg = reg;
        this.resolver = resolver;
        this.cleanup();
    }

    public void registerNative(String scheme, ISourceLocationWatcher watcher) {
        this.watchers.put(scheme, watcher);
    }

    public void setFallback(ISourceLocationWatcher fallback) {
        this.fallback = fallback;
    }

    public boolean hasFallback() {
        return this.fallback != null;
    }

    private ISourceLocation safeResolve(ISourceLocation loc) {
        return (ISourceLocation)this.resolver.apply(loc);
    }

    private static Comparator<ISourceLocation> makeISourceLocationComparator() {
        return Comparator.comparing(ISourceLocation::getScheme).thenComparing(ISourceLocation::getAuthority).thenComparing(ISourceLocation::getPath).thenComparing(ISourceLocation::getQuery);
    }

    public void watch(ISourceLocation loc, boolean recursive, Predicate<ISourceLocation> hasResolvers, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback) throws IOException {
        ISourceLocation resolvedLoc = this.safeResolve(loc);
        if (!this.reg.exists(resolvedLoc)) {
            throw new IOException("Cannot watch nonexistent location " + loc);
        }
        if (recursive && !this.reg.isDirectory(resolvedLoc)) {
            throw new IOException("Cannot recursively watch a file: " + loc);
        }
        ISourceLocationWatcher watcher = this.watchers.get(resolvedLoc.getScheme());
        if (watcher != null) {
            this.startNormalWatch(loc, recursive, callback, resolvedLoc, watcher);
        } else if (hasResolvers.test(resolvedLoc)) {
            this.startSimulatedWatch(loc, recursive, callback, resolvedLoc);
        } else if (this.fallback != null) {
            this.fallback.watch(resolvedLoc, callback, recursive);
        }
    }

    private void startSimulatedWatch(ISourceLocation loc, boolean recursive, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback, ISourceLocation resolvedLoc) {
        this.internalWatchers.computeIfAbsent(resolvedLoc, k -> ConcurrentHashMap.newKeySet()).add(new SimulatedWatchEntry(recursive, this.translateWatchEvents(callback, loc, resolvedLoc, recursive)));
    }

    private ISourceLocation startNormalWatch(ISourceLocation loc, boolean recursive, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback, ISourceLocation resolvedLoc, ISourceLocationWatcher watcher) throws IOException {
        if (recursive && !this.reg.isDirectory(resolvedLoc)) {
            loc = URIUtil.getParentLocation(loc);
            resolvedLoc = this.safeResolve(loc);
        }
        Consumer<ISourceLocationWatcher.ISourceLocationChanged> translator = this.translateWatchEvents(callback, loc, resolvedLoc, recursive);
        if (recursive && watcher.supportsRecursiveWatch() || !recursive) {
            watcher.watch(resolvedLoc, translator, recursive);
        } else {
            this.simulatedRecursiveWatchers.computeIfAbsent(resolvedLoc, rl -> new SimulatedRecursiveWatcher((ISourceLocation)rl, translator, watcher, this.exec)).add(translator);
        }
        return loc;
    }

    private Consumer<ISourceLocationWatcher.ISourceLocationChanged> translateWatchEvents(Consumer<ISourceLocationWatcher.ISourceLocationChanged> original, ISourceLocation originalLoc, ISourceLocation resolvedLoc, boolean recursive) {
        KeyedWeakReference stored;
        Consumer actualResult;
        if (resolvedLoc.equals(originalLoc)) {
            return original;
        }
        Consumer<ISourceLocationWatcher.ISourceLocationChanged> newHandler = changes -> {
            ISourceLocation relative = URIUtil.relativize(resolvedLoc, changes.getLocation());
            ISourceLocation unresolved = URIUtil.getChildLocation(originalLoc, relative.getPath());
            original.accept(ISourceLocationWatcher.makeChange(unresolved, changes.getChangeType()));
        };
        WatchKey key = new WatchKey(originalLoc, recursive, original, this.clearedReferences);
        while ((actualResult = (Consumer)(stored = this.wrappedHandlers.compute(key, (k, v) -> {
            if (v == null || v.get() == null) {
                return new KeyedWeakReference((WatchKey)k, newHandler, this.clearedReferences);
            }
            return v;
        })).get()) == null) {
        }
        return actualResult;
    }

    public void unwatch(ISourceLocation loc, boolean recursive, Predicate<ISourceLocation> hasResolvers, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback) throws IOException {
        ISourceLocationWatcher watcher;
        Consumer notClearedYet;
        KeyedWeakReference actualCallback = this.wrappedHandlers.remove(new WatchKey(loc, recursive, callback, this.clearedReferences));
        if (actualCallback != null && (notClearedYet = (Consumer)actualCallback.get()) != null) {
            callback = notClearedYet;
        }
        if ((watcher = this.watchers.get((loc = this.safeResolve(loc)).getScheme())) != null) {
            SimulatedRecursiveWatcher simulated = this.simulatedRecursiveWatchers.get(loc);
            if (simulated != null) {
                simulated.remove(callback);
            } else {
                watcher.unwatch(loc, callback, recursive);
            }
        } else if (hasResolvers.test(loc)) {
            Set entries = (Set)this.internalWatchers.get(loc);
            if (entries != null) {
                Consumer finalCallback = callback;
                entries.removeIf(p -> p.isRecursive() == recursive && p.getHandler() == finalCallback);
            }
        } else if (this.fallback != null) {
            this.fallback.unwatch(loc, callback, recursive);
        }
    }

    public void notifySimulatedWatchers(ISourceLocation loc, ISourceLocationWatcher.ISourceLocationChanged event) {
        if (this.watchers.containsKey(loc.getScheme())) {
            return;
        }
        for (Map.Entry watchedEntry : this.internalWatchers.headMap(loc, true).descendingMap().entrySet()) {
            ISourceLocation watchedParent;
            ISourceLocation watchedPath = (ISourceLocation)watchedEntry.getKey();
            boolean exactMatch = watchedPath.equals(loc);
            boolean childMatch = URIUtil.isParentOf(watchedPath, loc);
            if (exactMatch || childMatch) {
                boolean onlyRecursive = !exactMatch && !this.isDirectParentOf(watchedPath, loc);
                for (SimulatedWatchEntry c : (Set)watchedEntry.getValue()) {
                    if (onlyRecursive && !c.isRecursive()) continue;
                    this.exec.submit(() -> c.getHandler().accept(event));
                }
            }
            if ((watchedParent = URIUtil.getParentLocation(watchedPath)).equals(loc) || URIUtil.isParentOf(watchedParent, loc)) continue;
            break;
        }
    }

    private boolean isDirectParentOf(ISourceLocation parent, ISourceLocation child) {
        return URIUtil.relativize(parent, URIUtil.getParentLocation(child)).getPath().equals("/");
    }

    private void cleanup() {
        try {
            this.cleanupInternalWatchers();
            this.cleanupSimulatedWatchers();
            this.cleanupWrappedHandlers();
        }
        finally {
            CompletableFuture.delayedExecutor(1L, TimeUnit.MINUTES, this.exec).execute(this::cleanup);
        }
    }

    private void cleanupSimulatedWatchers() {
        for (Map.Entry<ISourceLocation, SimulatedRecursiveWatcher> e : this.simulatedRecursiveWatchers.entrySet()) {
            SimulatedRecursiveWatcher v;
            if (!e.getValue().isEmpty()) continue;
            ISourceLocation k = e.getKey();
            if (this.simulatedRecursiveWatchers.remove(k, v = e.getValue()) && !v.isEmpty()) {
                this.simulatedRecursiveWatchers.merge(k, v, (a, b) -> a.merge((SimulatedRecursiveWatcher)b));
                continue;
            }
            v.close();
        }
    }

    private void cleanupInternalWatchers() {
        for (Map.Entry e : this.internalWatchers.entrySet()) {
            Set v;
            ISourceLocation k;
            if (!((Set)e.getValue()).isEmpty() || !this.internalWatchers.remove(k = (ISourceLocation)e.getKey(), v = (Set)e.getValue()) || v.isEmpty()) continue;
            this.internalWatchers.merge(k, v, (a, b) -> {
                a.addAll(b);
                return a;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupWrappedHandlers() {
        ArrayList<WatchKey> toClear = new ArrayList<WatchKey>();
        ReferenceQueue<? super Consumer<ISourceLocationWatcher.ISourceLocationChanged>> referenceQueue = this.clearedReferences;
        synchronized (referenceQueue) {
            Reference<? super Consumer<ISourceLocationWatcher.ISourceLocationChanged>> entry;
            while ((entry = this.clearedReferences.poll()) != null) {
                if (entry instanceof WatchKey) {
                    toClear.add((WatchKey)entry);
                    continue;
                }
                toClear.add(((KeyedWeakReference)entry).key);
            }
        }
        toClear.forEach(this.wrappedHandlers::remove);
    }

    public boolean hasNativeSupport(String scheme) {
        return this.watchers.containsKey(scheme);
    }

    private static class WatchKey
    extends WeakReference<Consumer<ISourceLocationWatcher.ISourceLocationChanged>> {
        private final ISourceLocation loc;
        private final boolean recursive;
        private final int hash;

        public WatchKey(ISourceLocation loc, boolean recursive, Consumer<ISourceLocationWatcher.ISourceLocationChanged> handler, ReferenceQueue<? super Consumer<ISourceLocationWatcher.ISourceLocationChanged>> queue) {
            super(handler, queue);
            this.hash = Objects.hash(loc, recursive, handler);
            this.loc = loc;
            this.recursive = recursive;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WatchKey)) {
                return false;
            }
            WatchKey other = (WatchKey)obj;
            return this.hash == other.hash && this.recursive == other.recursive && Objects.equals(this.loc, other.loc) && this.get() != null && Objects.equals(this.get(), other.get());
        }
    }

    private static class KeyedWeakReference
    extends WeakReference<Consumer<ISourceLocationWatcher.ISourceLocationChanged>> {
        private final WatchKey key;

        public KeyedWeakReference(WatchKey key, Consumer<ISourceLocationWatcher.ISourceLocationChanged> handler, ReferenceQueue<? super Consumer<ISourceLocationWatcher.ISourceLocationChanged>> queue) {
            super(handler, queue);
            this.key = key;
        }
    }

    private static class SimulatedWatchEntry {
        private final boolean recursive;
        private final Consumer<ISourceLocationWatcher.ISourceLocationChanged> handler;

        public SimulatedWatchEntry(boolean recursive, Consumer<ISourceLocationWatcher.ISourceLocationChanged> handler) {
            this.recursive = recursive;
            this.handler = handler;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public Consumer<ISourceLocationWatcher.ISourceLocationChanged> getHandler() {
            return this.handler;
        }
    }
}

